/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.uas.TargetSystem;
import de.fzj.unicore.uas.impl.reservation.ReservationManagementImpl;
import de.fzj.unicore.uas.impl.tss.TargetSystemImpl;
import de.fzj.unicore.uas.impl.tss.rp.ReservationReferenceResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class RecreateReservationReferenceList
implements Runnable {
    private final Logger logger = LogUtil.getLogger((String)"unicore.services", RecreateReservationReferenceList.class);
    private final String tssID;
    private final Client client;
    private final Home tssHome;
    private final Home reservations;

    public RecreateReservationReferenceList(Kernel kernel, String tssID, Client client) throws PersistenceException {
        this.tssID = tssID;
        this.client = client;
        this.tssHome = kernel.getHome("TargetSystemService");
        this.reservations = kernel.getHome("ReservationManagement");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.reservations == null) {
                return;
            }
            String user = this.client.getDistinguishedName();
            X500Principal userP = new X500Principal(user);
            Set tssIds = this.tssHome.getStore().getUniqueIDs();
            tssIds.remove(this.tssID);
            for (String id : tssIds) {
                TargetSystemImpl t = (TargetSystemImpl)this.tssHome.get(id);
                if (!userP.equals(t.getOwner())) continue;
                return;
            }
            this.logger.info((Object)("Re-generating reservation reference list for " + user));
            ArrayList<String> oldReservations = new ArrayList<String>();
            for (String reservationID : this.getExistingReservations()) {
                try {
                    ReservationManagementImpl reservation = (ReservationManagementImpl)this.reservations.get(reservationID);
                    if (reservation.getOwner() != null && !userP.equals(reservation.getOwner())) continue;
                    oldReservations.add(reservationID);
                    try {
                        reservation = (ReservationManagementImpl)this.reservations.getForUpdate(reservationID);
                        reservation.setTSSID(this.tssID);
                        this.reservations.persist((Resource)reservation);
                    }
                    catch (Exception ex) {
                        Log.logException((String)("Could not change TSS ID of reservation <" + reservationID + ">"), (Throwable)ex, (Logger)this.logger);
                    }
                }
                catch (ResourceUnknownException re) {
                    this.logger.debug((Object)("Reservation <" + reservationID + "> not found any more."));
                }
            }
            TargetSystemImpl tss = null;
            try {
                tss = (TargetSystemImpl)this.tssHome.getForUpdate(this.tssID);
                ReservationReferenceResourceProperty rRP = (ReservationReferenceResourceProperty)tss.getResourceProperty(TargetSystem.RPReservationReference);
                if (rRP != null) {
                    rRP.addAll(oldReservations);
                    this.logger.info((Object)("Added <" + rRP.getNumberOfElements() + "> existing reservations to target system"));
                }
            }
            finally {
                if (tss != null) {
                    this.tssHome.getStore().persist((Resource)tss);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Could not restore reservations for " + this.client.getDistinguishedName()), (Throwable)ex);
        }
    }

    private Set<String> getExistingReservations() throws PersistenceException {
        return this.reservations.getStore().getUniqueIDs();
    }
}

