/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.uas.TargetSystem;
import de.fzj.unicore.uas.impl.job.JobManagementImpl;
import de.fzj.unicore.uas.impl.tss.TargetSystemImpl;
import de.fzj.unicore.uas.impl.tss.rp.JobReferenceResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class RecreateJMSReferenceList
implements Runnable {
    private final Logger logger = LogUtil.getLogger((String)"unicore.services", RecreateJMSReferenceList.class);
    private final String tssID;
    private final Client client;
    private final Home tssHome;
    private final Home jms;

    public RecreateJMSReferenceList(Kernel kernel, String tssID, Client client) throws PersistenceException {
        this.tssID = tssID;
        this.client = client;
        this.tssHome = kernel.getHome("TargetSystemService");
        this.jms = kernel.getHome("JobManagement");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String user = this.client.getDistinguishedName();
            X500Principal userP = new X500Principal(user);
            Set tssIds = this.tssHome.getStore().getUniqueIDs();
            tssIds.remove(this.tssID);
            for (String id : tssIds) {
                TargetSystemImpl t = (TargetSystemImpl)this.tssHome.get(id);
                if (!userP.equals(t.getOwner())) continue;
                return;
            }
            this.logger.info((Object)("Re-generating job list for " + user));
            ArrayList<String> oldJobs = new ArrayList<String>();
            for (String jobID : this.getExistingJobs()) {
                try {
                    JobManagementImpl j = (JobManagementImpl)this.jms.get(jobID);
                    if (j.getOwner() != null && !userP.equals(j.getOwner())) continue;
                    oldJobs.add(jobID);
                    try {
                        j = (JobManagementImpl)this.jms.getForUpdate(jobID);
                        j.setTSSID(this.tssID);
                        this.jms.persist((Resource)j);
                    }
                    catch (Exception ex) {
                        Log.logException((String)("Could not change TSS ID of job <" + jobID + ">"), (Throwable)ex, (Logger)this.logger);
                    }
                }
                catch (ResourceUnknownException re) {
                    this.logger.debug((Object)("Job <" + jobID + "> not found any more."));
                }
            }
            TargetSystemImpl tss = null;
            try {
                try {
                    tss = (TargetSystemImpl)this.tssHome.getForUpdate(this.tssID);
                }
                catch (ResourceUnknownException rue) {
                    this.logger.error((Object)rue);
                }
                JobReferenceResourceProperty jRP = (JobReferenceResourceProperty)tss.getResourceProperty(TargetSystem.RPJobReference);
                jRP.addAll(oldJobs);
                this.logger.info((Object)("Added <" + jRP.getNumberOfElements() + "> existing jobs to target system"));
            }
            catch (Throwable throwable) {
                this.tssHome.getStore().persist(tss);
                throw throwable;
            }
            this.tssHome.getStore().persist((Resource)tss);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Could not restore jobs for " + this.client.getDistinguishedName()), (Throwable)ex);
        }
    }

    private Set<String> getExistingJobs() throws PersistenceException {
        return this.jms.getStore().getUniqueIDs();
    }
}

