/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.uas.impl.tss.TargetSystemImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.InternalAction;
import eu.unicore.security.Client;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenerateJMSInstances
implements Runnable {
    private final Logger logger = LogUtil.getLogger((String)"unicore.services", GenerateJMSInstances.class);
    private final String tssID;
    private final Client client;
    private final String xnjsReference;
    private final Home tssHome;
    private final Home jms;
    private final Set<String> existingJobs;
    private final List<String> jobIDs;
    private final Kernel kernel;

    public GenerateJMSInstances(Kernel kernel, String tssID, Client client, String xnjsReference) throws Exception {
        this.kernel = kernel;
        this.tssID = tssID;
        this.client = client;
        this.xnjsReference = xnjsReference;
        this.tssHome = kernel.getHome("TargetSystemService");
        this.jms = kernel.getHome("JobManagement");
        this.existingJobs = this.getExistingJobs();
        this.jobIDs = this.getXNJSJobs();
    }

    List<String> getXNJSJobs() throws Exception {
        XNJSFacade xnjs = XNJSFacade.get(this.xnjsReference, this.kernel);
        return xnjs.listJobIDs(this.client);
    }

    @Override
    public void run() {
        try {
            this.logger.info((Object)("Regenerating UNICORE jobs for " + this.client.getDistinguishedName()));
            XNJSFacade xnjs = XNJSFacade.get(this.xnjsReference, this.kernel);
            for (String jobID : this.jobIDs) {
                Action action = xnjs.getAction(jobID);
                if (action == null || !this.accept(action) || this.jobExists(jobID)) continue;
                try {
                    this.add(action);
                }
                catch (Exception ex) {
                    this.logger.error((Object)("Could not restore job for : " + action.getUUID()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Could not restore jobs for " + this.client), (Throwable)ex);
        }
    }

    protected boolean accept(Action action) {
        if (action instanceof InternalAction) {
            return false;
        }
        String type = action.getType();
        if (!"JSDL".equals(type)) {
            return false;
        }
        String owner = action.getClient().getDistinguishedName();
        return this.client.getDistinguishedName().equalsIgnoreCase(owner);
    }

    protected boolean jobExists(String uid) {
        return this.existingJobs.contains(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Action action) throws Exception {
        TargetSystemImpl tss = (TargetSystemImpl)this.tssHome.getForUpdate(this.tssID);
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uas.jobmanagement.action", action);
            map.put("uas.jobmanagement.action.no_xnjs_submit", Boolean.TRUE);
            map.put("uas.jobmanagement.TSS", this.tssID);
            map.put(TargetSystemImpl.INITPARAM_XNJS_REFERENCE, this.xnjsReference);
            tss.createJob(map);
        }
        finally {
            if (tss != null) {
                this.tssHome.persist((Resource)tss);
            }
        }
    }

    private Set<String> getExistingJobs() throws PersistenceException {
        return this.jms.getStore().getUniqueIDs();
    }
}

