/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.task;

import de.fzj.unicore.uas.Task;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.task.ResultRP;
import de.fzj.unicore.uas.impl.task.StatusRP;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.rp.AddressResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import eu.unicore.unicore6.task.CancelRequestDocument;
import eu.unicore.unicore6.task.CancelResponseDocument;
import eu.unicore.unicore6.task.SubmissionServiceReferenceDocument;
import eu.unicore.unicore6.task.SubmissionTimeDocument;
import eu.unicore.unicore6.task.TaskPropertiesDocument;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.StatusType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TaskImpl
extends UASWSResourceImpl
implements Task {
    private static final Map<String, XmlObject> results = new ConcurrentHashMap<String, XmlObject>();
    private static final Map<String, TaskStatus> status = new ConcurrentHashMap<String, TaskStatus>();
    public static final String INIT_PARENT_SERVICE = "parentServiceEPR";

    public CancelResponseDocument Cancel(CancelRequestDocument in) throws BaseFault {
        TaskStatus s = TaskImpl.getStatus(this.getUniqueID());
        if (StatusType.RUNNING.equals(s.status)) {
            s.status = StatusType.FAILED;
            TaskImpl.putResult(this.getUniqueID(), TaskImpl.getCancelledResult());
        }
        CancelResponseDocument crd = CancelResponseDocument.Factory.newInstance();
        crd.addNewCancelResponse();
        return crd;
    }

    @Override
    public void initialise(String serviceName, Map<String, Object> initParams) throws Exception {
        super.initialise(serviceName, initParams);
        EndpointReferenceType parent = (EndpointReferenceType)initParams.get(INIT_PARENT_SERVICE);
        QName q = SubmissionServiceReferenceDocument.type.getDocumentElementName();
        String parentService = WSUtilities.extractServiceName((String)parent.getAddress().getStringValue());
        String parentID = WSUtilities.extractResourceID((EndpointReferenceType)parent);
        String serviceSpec = parentID != null ? parentService + "?res=" + parentID : parentService;
        AddressResourceProperty p1 = new AddressResourceProperty((Resource)this, q, serviceSpec, true);
        this.properties.put(RP_SUBMISSION_SERVICE_REFERENCE, p1);
        this.properties.put(RP_RESULT, new ResultRP(this));
        SubmissionTimeDocument time = SubmissionTimeDocument.Factory.newInstance();
        time.setSubmissionTime(Calendar.getInstance());
        ImmutableResourceProperty p2 = new ImmutableResourceProperty((XmlObject)time);
        this.properties.put(RP_SUBMISSION_TIME, p2);
        TaskStatus s = new TaskStatus();
        s.status = StatusType.RUNNING;
        status.put(this.getUniqueID(), s);
        this.properties.put(RP_STATUS, new StatusRP(this));
    }

    @Override
    public QName getResourcePropertyDocumentQName() {
        return TaskPropertiesDocument.type.getDocumentElementName();
    }

    public static XmlObject getAndRemoveResult(String uuid) {
        return results.remove(uuid);
    }

    public static TaskStatus putResult(String uuid, XmlObject result) {
        results.put(uuid, result);
        TaskImpl.status.get((Object)uuid).status = StatusType.SUCCESSFUL;
        return status.get(uuid);
    }

    public static TaskStatus getStatus(String uuid) {
        return status.get(uuid);
    }

    public static void updateStatus(String uuid, TaskStatus taskStatus) {
        status.put(uuid, taskStatus);
    }

    public void destroy() {
        results.remove(this.getUniqueID());
        status.remove(this.getUniqueID());
        super.destroy();
    }

    public static XmlObject getDefaultResult() {
        String x = "<Completed xmlns=\"http://www.unicore.eu/unicore6/task\"/>";
        try {
            return XmlObject.Factory.parse((String)x);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static XmlObject getCancelledResult() {
        String x = "<Cancelled xmlns=\"http://www.unicore.eu/unicore6/task\"/>";
        try {
            return XmlObject.Factory.parse((String)x);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class TaskStatus {
        public volatile String message;
        public volatile Float progress;
        public volatile Integer exitCode;
        public volatile StatusType.Enum status = StatusType.UNDEFINED;
    }
}

