/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.sms;

import de.fzj.unicore.uas.impl.sms.FixedStorageImpl;
import de.fzj.unicore.uas.impl.sms.HomeStorageImpl;
import de.fzj.unicore.uas.impl.sms.PathedStorageImpl;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceHomeImpl;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import java.util.Map;
import org.apache.log4j.Logger;

public class StorageManagementHomeImpl
extends WSResourceHomeImpl {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", StorageManagementHomeImpl.class);
    private static final String STORAGECLASS_INTERNAL = StorageManagementHomeImpl.class.getName() + ".storageclass.internal";

    protected WSResourceImpl doCreateInstance(Map<String, Object> map) {
        try {
            String clazz = (String)map.get(STORAGECLASS_INTERNAL);
            SMSBaseImpl sms = (SMSBaseImpl)Class.forName(clazz).newInstance();
            logger.debug((Object)("Created sms class <" + sms.getClass().getName() + ">"));
            return sms;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Can't create sms class.", (Throwable)e, (Logger)logger);
            return null;
        }
    }

    protected WSResourceImpl doCreateInstance() {
        return null;
    }

    public synchronized String createWSRFServiceInstance(Map<String, Object> map) throws ResourceNotCreatedException {
        StorageDescription storageDesc = (StorageDescription)map.get(SMSBaseImpl.INIT_STORAGE_DESCRIPTION);
        StorageTypes st = storageDesc.getStorageType();
        String clazz = null;
        if (st.equals((Object)StorageTypes.HOME)) {
            clazz = HomeStorageImpl.class.getName();
        } else if (st.equals((Object)StorageTypes.FIXEDPATH)) {
            clazz = FixedStorageImpl.class.getName();
        } else if (st.equals((Object)StorageTypes.VARIABLE)) {
            clazz = PathedStorageImpl.class.getName();
        } else if (st.equals((Object)StorageTypes.CUSTOM)) {
            clazz = storageDesc.getStorageClass().getName();
        } else {
            throw new ResourceNotCreatedException("Unknown storage type!?");
        }
        map.put(STORAGECLASS_INTERNAL, clazz);
        return super.createWSRFServiceInstance(map);
    }

    protected void postInitialise(Resource r) {
        if (r instanceof SMSBaseImpl) {
            try {
                ((SMSBaseImpl)r).setupMetadataService();
            }
            catch (Exception ex) {
                LogUtil.logException((String)("Error setting up metadata service instance for storage " + r.getUniqueID()), (Throwable)ex, (Logger)logger);
            }
        }
    }

    public static enum StorageTypes {
        HOME,
        FIXEDPATH,
        CUSTOM,
        VARIABLE;

    }
}

