/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.sms;

import de.fzj.unicore.uas.Enumeration;
import de.fzj.unicore.uas.StorageFactory;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.sms.AccessibleSMSReferenceRP;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.SMSReferenceResourceProperty;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageDescriptionRP;
import de.fzj.unicore.uas.impl.sms.StorageManagementHomeImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.rl2.DestroyDocument;
import org.oasisOpen.docs.wsrf.rl2.DestroyResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument;
import org.unigrids.services.atomic.types.PropertyType;
import org.unigrids.x2006.x04.services.smf.AccessibleStorageEnumerationDocument;
import org.unigrids.x2006.x04.services.smf.CreateSMSDocument;
import org.unigrids.x2006.x04.services.smf.CreateSMSResponseDocument;
import org.unigrids.x2006.x04.services.smf.StorageBackendParametersDocument;
import org.unigrids.x2006.x04.services.smf.StorageDescriptionType;
import org.unigrids.x2006.x04.services.smf.StorageEnumerationDocument;
import org.unigrids.x2006.x04.services.smf.StorageFactoryPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class StorageFactoryImpl
extends UASWSResourceImpl
implements StorageFactory {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", StorageFactoryImpl.class);
    @Persist
    private Map<String, String> smsOwners = new HashMap<String, String>();

    public String getOwnerForSMS(String smsID) {
        return this.smsOwners.get(smsID);
    }

    public SMSReferenceResourceProperty getSMSReferenceProperty() {
        return (SMSReferenceResourceProperty)((Object)this.properties.get(RPSMSReferences));
    }

    @Override
    public void initialise(String serviceName, Map<String, Object> initParams) throws Exception {
        StorageEnumerationDocument sred;
        super.initialise(serviceName, initParams);
        this.properties.put(RPSMSReferences, new SMSReferenceResourceProperty(new EndpointReferenceType[0]));
        this.properties.put(RPAccessibleSMSReferences, new AccessibleSMSReferenceRP(this));
        try {
            sred = StorageEnumerationDocument.Factory.newInstance();
            sred.setStorageEnumeration(this.createEnumeration(RPSMSReferences));
            this.properties.put(RPSMSEnumeration, new ImmutableResourceProperty((XmlObject)sred));
        }
        catch (Exception ex) {
            LogUtil.logException((String)"Error creating SMS reference enumeration", (Throwable)ex, (Logger)logger);
        }
        try {
            sred = AccessibleStorageEnumerationDocument.Factory.newInstance();
            sred.setAccessibleStorageEnumeration(this.createEnumeration(RPAccessibleSMSReferences));
            this.properties.put(RPAccessibleSMSEnumeration, new ImmutableResourceProperty((XmlObject)sred));
        }
        catch (Exception ex) {
            LogUtil.logException((String)"Error creating SMS reference enumeration", (Throwable)ex, (Logger)logger);
        }
        String xnjsRef = null;
        this.properties.put(RPStorageDescription, new StorageDescriptionRP((Resource)this, xnjsRef));
        logger.info((Object)("Storage factory <" + this.getUniqueID() + "> created"));
        this.publish();
    }

    public CreateSMSResponseDocument CreateSMS(CreateSMSDocument in) throws BaseFault {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("CreateSMS: " + in));
        }
        String clientName = this.getClient() != null ? this.getClient().getDistinguishedName() : "<no client>";
        try {
            StorageDescription factoryDesc;
            Map<String, StorageDescription> factories = this.uasProperties.getStorageFactories();
            String storageBackendType = null;
            ArrayList<String> types = new ArrayList<String>();
            types.addAll(factories.keySet());
            if (types.contains("DEFAULT")) {
                storageBackendType = "DEFAULT";
            } else if (types.size() == 1) {
                storageBackendType = (String)types.get(0);
            } else {
                throw new IllegalArgumentException("Please specify the storage backend type. Available are " + types);
            }
            HashMap<String, String> extraProperties = new HashMap<String, String>();
            StorageDescriptionType sdType = in.getCreateSMS().getStorageDescription();
            if (sdType != null) {
                if (sdType.getStorageBackendType() != null) {
                    storageBackendType = sdType.getStorageBackendType();
                }
                if (sdType.getStorageBackendParameters() != null) {
                    extraProperties.putAll(this.getAdditionClientConfigurationItems(sdType.getStorageBackendParameters()));
                }
            }
            if ((factoryDesc = factories.get(storageBackendType)) == null) {
                throw new IllegalArgumentException("Unknown type of storage factory: " + storageBackendType);
            }
            factoryDesc = factoryDesc.clone();
            if (sdType != null && sdType.getFileSystem() != null && sdType.getFileSystem().getName() != null) {
                factoryDesc.setName(sdType.getFileSystem().getName());
            }
            extraProperties.putAll(factoryDesc.getAdditionalProperties());
            factoryDesc.getAdditionalProperties().putAll(extraProperties);
            HashMap<String, Object> initMap = new HashMap<String, Object>();
            initMap.put(SMSBaseImpl.INIT_STORAGE_DESCRIPTION, factoryDesc);
            initMap.put(SMSBaseImpl.INIT_DIRECTORY_APPEND_UNIQUE_ID, Boolean.TRUE);
            initMap.put(SMSBaseImpl.INIT_FACTORYID, this.getUniqueID());
            initMap.put(INIT_PARENT_NODE, this.getNode());
            initMap.put(SMSBaseImpl.INIT_SKIP_EXISTENCECHECK, Boolean.TRUE);
            TerminationTimeDocument.TerminationTime tt = in.getCreateSMS().getTerminationTime();
            if (tt != null) {
                initMap.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", tt.getCalendarValue());
            }
            EndpointReferenceType epr = this.createStorageResource(initMap);
            CreateSMSResponseDocument resD = CreateSMSResponseDocument.Factory.newInstance();
            resD.addNewCreateSMSResponse().setSmsReference(epr);
            String smsID = WSServerUtilities.extractResourceID((EndpointReferenceType)epr);
            this.initStorage(smsID);
            logger.info((Object)("Created new StorageManagement resource <" + smsID + "> for " + clientName));
            this.smsOwners.put(smsID, clientName);
            this.getSMSReferenceProperty().add(epr);
            this.setDirty();
            return resD;
        }
        catch (Exception ex) {
            LogUtil.logException((String)("Could not create Storage instance for <" + clientName + ">"), (Throwable)ex, (Logger)logger);
            throw BaseFault.createFault((String)"Could not create Storage instance. Please consult the site administrator.", (Throwable)ex);
        }
    }

    private Map<String, String> getAdditionClientConfigurationItems(StorageBackendParametersDocument.StorageBackendParameters params) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (PropertyType p : params.getPropertyArray()) {
            ret.put(p.getName(), p.getValue());
        }
        return ret;
    }

    protected EndpointReferenceType createEnumeration(QName rp) throws Exception {
        HashMap<String, Object> init = new HashMap<String, Object>();
        init.put("targetServiceEPR", this.getEPR());
        init.put("targetPropertyQName", rp);
        Calendar c = Calendar.getInstance();
        c.add(2, 24);
        init.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", c);
        init.put(INIT_PARENT_NODE, this.getNode());
        Home h = this.kernel.getHome("Enumeration");
        if (h == null) {
            throw new Exception("Enumeration service is not deployed!");
        }
        String id = h.createWSRFServiceInstance(init);
        return WSServerUtilities.makeEPR((String)"Enumeration", (String)id, (QName)Enumeration.ENUM_PORT, (Kernel)this.kernel);
    }

    protected EndpointReferenceType createStorageResource(Map<String, Object> initParam) throws Exception {
        Home home = this.kernel.getHome("StorageManagement");
        if (home == null) {
            throw new ResourceUnknownException("Storage management service is not deployed.");
        }
        String id = home.createWSRFServiceInstance(initParam);
        return WSServerUtilities.makeEPR((String)"StorageManagement", (String)id, (QName)StorageManagement.SMS_PORT, (Kernel)this.kernel);
    }

    protected void initStorage(String uniqueID) throws Exception {
        StorageManagementHomeImpl smsHome = (StorageManagementHomeImpl)this.kernel.getHome("StorageManagement");
        SMSBaseImpl sms = (SMSBaseImpl)smsHome.get(uniqueID);
        if (sms.getStorageDescription().getStorageType() != StorageManagementHomeImpl.StorageTypes.CUSTOM) {
            sms.getStorageAdapter().mkdir("/");
        }
    }

    public QName getPortType() {
        return SMF_PORT;
    }

    @Override
    public QName getResourcePropertyDocumentQName() {
        return StorageFactoryPropertiesDocument.type.getDocumentElementName();
    }

    public DestroyResponseDocument Destroy(DestroyDocument in) throws ResourceNotDestroyedFault, ResourceUnknownFault, ResourceUnavailableFault {
        throw ResourceNotDestroyedFault.createFault((String)"Not destroyed.");
    }

    public SetTerminationTimeResponseDocument SetTerminationTime(SetTerminationTimeDocument in) throws UnableToSetTerminationTimeFault, TerminationTimeChangeRejectedFault, ResourceUnknownFault, ResourceUnavailableFault {
        throw TerminationTimeChangeRejectedFault.createFault((String)"Not changed.");
    }

    @Override
    public void customPostActivate() {
        try {
            PullPoint p = this.kernel.getMessaging().getPullPoint(this.getUniqueID());
            SMSReferenceResourceProperty smsRef = this.getSMSReferenceProperty();
            while (p.hasNext()) {
                String m = (String)((Object)p.next().getBody());
                if (!m.startsWith("deleted:")) continue;
                String id = m.substring(m.indexOf(":") + 1);
                logger.debug((Object)("Removing Storage with ID " + id + "..."));
                smsRef.remove(id);
                this.smsOwners.remove(id);
                this.setDirty();
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)e.getMessage(), (Throwable)e, (Logger)logger);
        }
    }
}

