/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.sms;

import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageInfoProvider;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import eu.unicore.security.Client;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemDocument;
import org.unigrids.x2006.x04.services.smf.StorageDescriptionDocument;
import org.unigrids.x2006.x04.services.smf.StorageDescriptionType;

public class StorageDescriptionRP
extends ResourceProperty<Object> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", StorageDescriptionRP.class);
    StorageDescriptionDocument[] xml = new StorageDescriptionDocument[0];
    private long lastPropertyUpdate = -1L;
    private final String xnjsReference;

    public StorageDescriptionRP(Resource parent, String xnjsReference) {
        super(parent);
        this.xnjsReference = xnjsReference;
    }

    public StorageDescriptionDocument[] getXml() {
        return this.xml;
    }

    public ResourceProperty<Object> update() {
        if (this.mustUpdate()) {
            UASProperties props = (UASProperties)((Object)this.parentWSResource.getKernel().getAttribute(UASProperties.class));
            Map<String, StorageDescription> factoriesDesc = props.getStorageFactories();
            this.xml = new StorageDescriptionDocument[factoriesDesc.size()];
            int i = 0;
            for (String type : factoriesDesc.keySet()) {
                this.xml[i] = this.getStorageDescription(factoriesDesc.get(type));
                ++i;
            }
        }
        return this;
    }

    protected StorageDescriptionDocument getStorageDescription(StorageDescription storageDesc) {
        StorageDescriptionDocument sdd = StorageDescriptionDocument.Factory.newInstance();
        StorageDescriptionType sType = sdd.addNewStorageDescription();
        sType.setStorageBackendType(storageDesc.getName());
        FileSystemDocument fs = this.getFileSystemDescription(storageDesc);
        if (fs != null) {
            sType.setFileSystem(fs.getFileSystem());
        }
        return sdd;
    }

    protected FileSystemDocument getFileSystemDescription(StorageDescription storageDesc) {
        Kernel kernel = this.parentWSResource.getKernel();
        Class<? extends StorageInfoProvider> infoP = storageDesc.getInfoProviderClass();
        if (infoP != null) {
            try {
                StorageInfoProvider infoProvider = (StorageInfoProvider)kernel.load(infoP);
                Client client = AuthZAttributeStore.getClient();
                FileSystemDocument fs = infoProvider.getInformation(storageDesc, client, this.xnjsReference);
                return fs;
            }
            catch (Exception ex) {
                LogUtil.logException((String)("Can't get storage information for <" + storageDesc.getName() + ">"), (Throwable)ex, (Logger)logger);
            }
        }
        return null;
    }

    protected boolean mustUpdate() {
        return this.lastPropertyUpdate <= this.parentWSResource.getKernel().getLastConfigFileChangeTime();
    }
}

