/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.sms;

import de.fzj.unicore.uas.SMSProperties;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.impl.sms.DefaultStorageInfoProvider;
import de.fzj.unicore.uas.impl.sms.StorageInfoProvider;
import de.fzj.unicore.uas.impl.sms.StorageManagementHomeImpl;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StorageDescription
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private String name;
    private final Class<? extends StorageManagement> clazz;
    private final StorageManagementHomeImpl.StorageTypes type;
    private Class<? extends StorageInfoProvider> infoProviderClass;
    private final String pathSpec;
    private final boolean disableMetadata;
    private String description;
    private String protocols;
    private Map<String, String> additionalProperties;
    private boolean filterListing;
    private boolean cleanup;
    private String defaultUmask;

    public StorageDescription(String id, String name, String pathSpec, StorageManagementHomeImpl.StorageTypes type, Class<? extends StorageManagement> clazz, String protocols, Boolean filterListing, Boolean cleanup, Boolean disableMetadata, String defaultUmask, String description, Map<String, String> additionalProperties) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("Storage identifier can not be null");
        }
        this.name = name == null ? id : name;
        this.type = type;
        this.pathSpec = pathSpec;
        this.clazz = clazz;
        this.disableMetadata = disableMetadata == null ? false : disableMetadata;
        this.update(protocols, filterListing, cleanup, defaultUmask, description, additionalProperties);
    }

    public void update(String protocols, Boolean filterListing, Boolean cleanup, String defaultUmask, String description, Map<String, String> additionalProperties) {
        this.description = description == null ? "Filesystem" : description;
        this.protocols = protocols;
        this.additionalProperties = additionalProperties;
        if (additionalProperties == null) {
            additionalProperties = Collections.emptyMap();
        }
        this.filterListing = filterListing == null ? false : filterListing;
        this.defaultUmask = defaultUmask == null ? Integer.toOctalString(63) : defaultUmask;
        boolean bl = this.cleanup = cleanup == null ? true : cleanup;
        if (!SMSProperties.umaskPattern.matcher(this.defaultUmask).matches()) {
            throw new ConfigurationException("Specified umask must be an octal number from 0 to 777.");
        }
        if (this.type.equals((Object)StorageManagementHomeImpl.StorageTypes.CUSTOM) && this.clazz == null) {
            throw new ConfigurationException("No class defined for the CUSTOM storage");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProtocols() {
        return this.protocols;
    }

    public StorageManagementHomeImpl.StorageTypes getStorageType() {
        return this.type;
    }

    public String getStorageTypeAsString() {
        return this.type.toString();
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getPathSpec() {
        return this.pathSpec;
    }

    public Class<? extends StorageManagement> getStorageClass() {
        return this.clazz;
    }

    public boolean isFilterListing() {
        return this.filterListing;
    }

    public boolean isCleanupOnDestroy() {
        return this.cleanup;
    }

    public String getDefaultUmask() {
        return this.defaultUmask;
    }

    public Class<? extends StorageInfoProvider> getInfoProviderClass() {
        return this.infoProviderClass;
    }

    public void setInfoProviderClass(Class<? extends StorageInfoProvider> clazz) {
        this.infoProviderClass = clazz;
        if (this.infoProviderClass == null) {
            switch (this.getStorageType()) {
                case FIXEDPATH: 
                case VARIABLE: {
                    this.infoProviderClass = DefaultStorageInfoProvider.class;
                }
            }
        }
    }

    public String toString() {
        return "Storage description: name=" + this.name + ", type=" + (Object)((Object)this.type) + ", protocols=" + this.protocols + ", pathSpec=" + this.pathSpec + ", defaultUmask=" + this.defaultUmask + ", filterListing=" + this.filterListing;
    }

    public StorageDescription clone() {
        HashMap<String, String> clonedAdd = new HashMap<String, String>();
        clonedAdd.putAll(this.additionalProperties);
        StorageDescription ret = new StorageDescription(this.id, this.name, this.pathSpec, this.type, this.clazz, this.protocols, this.filterListing, this.cleanup, this.disableMetadata, this.defaultUmask, this.description, clonedAdd);
        if (this.infoProviderClass != null) {
            ret.setInfoProviderClass(this.infoProviderClass);
        }
        return ret;
    }
}

