/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.sms;

import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.fts.ProtocolRP;
import de.fzj.unicore.uas.fts.UpdatingProtocolRP;
import de.fzj.unicore.uas.impl.PersistingPreferencesResource;
import de.fzj.unicore.uas.impl.UmaskResourceProperty;
import de.fzj.unicore.uas.impl.bp.BPSupportImpl;
import de.fzj.unicore.uas.impl.sms.ACLSupportedRP;
import de.fzj.unicore.uas.impl.sms.FileSystemRP;
import de.fzj.unicore.uas.impl.sms.FiletransferReferenceRP;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageSharingMode;
import de.fzj.unicore.uas.metadata.BaseMetadataManagementImpl;
import de.fzj.unicore.uas.metadata.MetadataManagementImpl;
import de.fzj.unicore.uas.metadata.MetadataManager;
import de.fzj.unicore.uas.metadata.MetadataSupport;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.StorageAdapterFactory;
import de.fzj.unicore.uas.xnjs.TSIStorageAdapterFactory;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.InvalidModificationException;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.messaging.ResourceAddedMessage;
import de.fzj.unicore.wsrflite.messaging.ResourceDeletedMessage;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.security.IContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.security.VODescription;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.wsrflite.utils.Utilities;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.rp.AddressResourceProperty;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.ACLEntry;
import de.fzj.unicore.xnjs.io.ChangeACL;
import de.fzj.unicore.xnjs.io.ChangePermissions;
import de.fzj.unicore.xnjs.io.CompositeFindOptions;
import de.fzj.unicore.xnjs.io.FileFilter;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.simple.LocalTS;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.URIUtils;
import eu.unicore.security.Client;
import eu.unicore.security.OperationType;
import eu.unicore.util.ConcurrentAccess;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.xml.namespace.QName;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.ACLEntryType;
import org.unigrids.services.atomic.types.ACLEntryTypeType;
import org.unigrids.services.atomic.types.ACLType;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.MetadataType;
import org.unigrids.services.atomic.types.PermissionsType;
import org.unigrids.services.atomic.types.PropertyType;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.services.atomic.types.TextInfoType;
import org.unigrids.services.atomic.types.UmaskDocument;
import org.unigrids.x2006.x04.services.sms.ACLChangeModeType;
import org.unigrids.x2006.x04.services.sms.ChangeACLEntryType;
import org.unigrids.x2006.x04.services.sms.ChangeACLType;
import org.unigrids.x2006.x04.services.sms.ChangePermissionsDocument;
import org.unigrids.x2006.x04.services.sms.ChangePermissionsEntryType;
import org.unigrids.x2006.x04.services.sms.ChangePermissionsResponseDocument;
import org.unigrids.x2006.x04.services.sms.CopyDocument;
import org.unigrids.x2006.x04.services.sms.CopyResponseDocument;
import org.unigrids.x2006.x04.services.sms.CreateDirectoryDocument;
import org.unigrids.x2006.x04.services.sms.CreateDirectoryResponseDocument;
import org.unigrids.x2006.x04.services.sms.DeleteDocument;
import org.unigrids.x2006.x04.services.sms.DeleteResponseDocument;
import org.unigrids.x2006.x04.services.sms.ExportFileDocument;
import org.unigrids.x2006.x04.services.sms.ExportFileResponseDocument;
import org.unigrids.x2006.x04.services.sms.ExtendedChangePermissionsType;
import org.unigrids.x2006.x04.services.sms.ExtraParametersDocument;
import org.unigrids.x2006.x04.services.sms.FindDocument;
import org.unigrids.x2006.x04.services.sms.FindResponseDocument;
import org.unigrids.x2006.x04.services.sms.ImportFileDocument;
import org.unigrids.x2006.x04.services.sms.ImportFileResponseDocument;
import org.unigrids.x2006.x04.services.sms.ListDirectoryDocument;
import org.unigrids.x2006.x04.services.sms.ListDirectoryResponseDocument;
import org.unigrids.x2006.x04.services.sms.ListPropertiesDocument;
import org.unigrids.x2006.x04.services.sms.ListPropertiesResponseDocument;
import org.unigrids.x2006.x04.services.sms.MetadataServiceReferenceDocument;
import org.unigrids.x2006.x04.services.sms.PermissionsChangeModeType;
import org.unigrids.x2006.x04.services.sms.PermissionsClassType;
import org.unigrids.x2006.x04.services.sms.ReceiveFileDocument;
import org.unigrids.x2006.x04.services.sms.ReceiveFileResponseDocument;
import org.unigrids.x2006.x04.services.sms.RenameDocument;
import org.unigrids.x2006.x04.services.sms.RenameResponseDocument;
import org.unigrids.x2006.x04.services.sms.SendFileDocument;
import org.unigrids.x2006.x04.services.sms.SendFileResponseDocument;
import org.unigrids.x2006.x04.services.sms.StoragePropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class SMSBaseImpl
extends PersistingPreferencesResource
implements StorageManagement {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", SMSBaseImpl.class);
    public static final int MAX_LS_RESULTS = 50000;
    public static final String INIT_STORAGE_DESCRIPTION = SMSBaseImpl.class.getName() + "_storageDescription";
    public static final String INIT_DIRECTORY_APPEND_UNIQUE_ID = SMSBaseImpl.class.getName() + "_appenduniqueid";
    public static final String INIT_FACTORYID = SMSBaseImpl.class.getName() + "_factoryid";
    public static final String INIT_DISABLE_METADATA = SMSBaseImpl.class.getName() + "_disable_metadata";
    public static final String INIT_INHERIT_SHARING = SMSBaseImpl.class.getName() + "_inherit_sharing";
    public static final String INIT_SKIP_EXISTENCECHECK = SMSBaseImpl.class.getName() + "skip_initial_exist_check";
    private static final Set<String> AUTO_NEGOTIATE_SCHEMES = new HashSet<String>(Arrays.asList(UAS.AUTO_NEGOTIATE_FT_PROTOCOL));
    private static final Cache protocolCache = SMSBaseImpl.initProtocolCache();
    public static final QName RPInternalFiletransferReference = new QName("http://unigrids.org/2006/04/services/sms", "internal_list_of_filetransfers");
    @Persist
    protected StorageDescription storageDescription;
    @Persist
    protected String workdir;
    @Persist
    protected Boolean enableDirectFiletransfer = Boolean.FALSE;
    @Persist
    protected Boolean disableMetadata = Boolean.FALSE;
    @Persist
    protected Boolean inheritSharing = Boolean.FALSE;
    private static final boolean allowConcurrency = true;
    @Persist
    protected String storageFactoryID = null;
    private String sep = null;

    @Override
    protected void addWSResourceInterfaces(BPSupportImpl baseProfile) {
        super.addWSResourceInterfaces(baseProfile);
        baseProfile.addWSResourceInterface(SMS_PORT);
    }

    public QName getPortType() {
        return SMS_PORT;
    }

    @Override
    public QName getResourcePropertyDocumentQName() {
        return StoragePropertiesDocument.type.getDocumentElementName();
    }

    @ConcurrentAccess(allow=true)
    public ChangePermissionsResponseDocument ChangePermissions(ChangePermissionsDocument inDoc) throws BaseFault {
        try {
            ChangePermissionsDocument.ChangePermissions in = inDoc.getChangePermissions();
            String file = this.makeSMSLocal(in.getPath());
            IStorageAdapter tsi = this.getStorageAdapter();
            boolean recursive = in.isSetRecursive() ? in.getRecursive() : false;
            ExtendedChangePermissionsType extendedCh = in.getExtendedPermissions();
            if (extendedCh == null || extendedCh.isNil()) {
                if (in.getPermissions() != null) {
                    SMSBaseImpl.legacyChangePermissions(file, tsi, in);
                }
            } else {
                SMSBaseImpl.extendedChangePermissions(file, tsi, extendedCh, recursive);
            }
            String newGroup = in.getChangeOwningGroup();
            if (in.isSetChangeOwningGroup() && newGroup != null) {
                tsi.chgrp(file, newGroup, recursive);
            }
            ChangeACLType aclChange = in.getACL();
            if (in.isSetACL() && aclChange != null) {
                SMSBaseImpl.setACL(file, tsi, aclChange, recursive);
            }
            ChangePermissionsResponseDocument res = ChangePermissionsResponseDocument.Factory.newInstance();
            res.addNewChangePermissionsResponse();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not change permissions.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)("Could not change permissions. Reason: " + e.toString()));
        }
    }

    public static void extendedChangePermissions(String file, IStorageAdapter tsi, ExtendedChangePermissionsType extendedCh, boolean recursive) throws ExecutionException {
        ChangePermissionsEntryType[] request = extendedCh.getChangePermissionsEntryArray();
        if (request == null) {
            throw new ExecutionException("Invalid request - null change perms array");
        }
        ChangePermissions[] xnjsRequest = new ChangePermissions[request.length];
        for (int i = 0; i < request.length; ++i) {
            xnjsRequest[i] = new ChangePermissions();
            if (request[i].getKind() == null || request[i].getMode() == null || request[i].getPermissions() == null) {
                throw new ExecutionException("Invalid request - null change perms entries");
            }
            if (request[i].getKind().equals(PermissionsClassType.GROUP)) {
                xnjsRequest[i].setClazz(ChangePermissions.PermissionsClass.GROUP);
            } else if (request[i].getKind().equals(PermissionsClassType.USER)) {
                xnjsRequest[i].setClazz(ChangePermissions.PermissionsClass.OWNER);
            } else {
                xnjsRequest[i].setClazz(ChangePermissions.PermissionsClass.OTHER);
            }
            if (request[i].getMode().equals(PermissionsChangeModeType.ADD)) {
                xnjsRequest[i].setMode(ChangePermissions.Mode.ADD);
            } else if (request[i].getMode().equals(PermissionsChangeModeType.SUBTRACT)) {
                xnjsRequest[i].setMode(ChangePermissions.Mode.SUBTRACT);
            } else {
                xnjsRequest[i].setMode(ChangePermissions.Mode.SET);
            }
            xnjsRequest[i].setPermissions(request[i].getPermissions());
        }
        tsi.chmod2(file, xnjsRequest, recursive);
    }

    public static void setACL(String file, IStorageAdapter tsi, ChangeACLType aclChange, boolean recursive) throws ExecutionException {
        ChangeACLEntryType[] request = aclChange.getChangeACLEntryArray();
        if (request == null) {
            throw new ExecutionException("Invalid request - null change ACL array");
        }
        ChangeACL[] xnjsRequest = new ChangeACL[request.length];
        for (int i = 0; i < request.length; ++i) {
            if (request[i].getKind() == null || request[i].getMode() == null || request[i].getPermissions() == null) {
                throw new ExecutionException("Invalid request - null change ACL entries");
            }
            xnjsRequest[i] = new ChangeACL();
            if (request[i].getMode().equals(ACLChangeModeType.MODIFY)) {
                xnjsRequest[i].setChangeMode(ChangeACL.ACLChangeMode.MODIFY);
                xnjsRequest[i].setPermissions(request[i].getPermissions());
            } else {
                xnjsRequest[i].setChangeMode(ChangeACL.ACLChangeMode.REMOVE);
            }
            xnjsRequest[i].setSubject(request[i].getSubject());
            if (request[i].getKind().equals(ACLEntryTypeType.GROUP)) {
                xnjsRequest[i].setType(ACLEntry.Type.GROUP);
            } else {
                xnjsRequest[i].setType(ACLEntry.Type.USER);
            }
            if (request[i].isSetDefaultACL() && request[i].getDefaultACL()) {
                xnjsRequest[i].setDefaultACL(true);
                continue;
            }
            xnjsRequest[i].setDefaultACL(false);
        }
        boolean clearAll = aclChange.isSetClearACL() && aclChange.getClearACL();
        tsi.setfacl(file, clearAll, xnjsRequest, recursive);
    }

    public static void legacyChangePermissions(String file, IStorageAdapter tsi, ChangePermissionsDocument.ChangePermissions in) throws ExecutionException {
        PermissionsType p = in.getPermissions();
        Permissions permissions = new Permissions(p.getReadable(), p.getWritable(), p.getExecutable());
        tsi.chmod(file, permissions);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Changed user permissions for '" + file + "' to <" + permissions.toString() + ">"));
        }
    }

    @ConcurrentAccess(allow=true)
    public CopyResponseDocument Copy(CopyDocument in) throws BaseFault {
        try {
            String source = this.makeSMSLocal(in.getCopy().getSource());
            String target = this.makeSMSLocal(in.getCopy().getDestination());
            IStorageAdapter tsi = this.getStorageAdapter();
            tsi.cp(source, target);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Copied '" + source + "' -> '" + target + "'"));
            }
            CopyResponseDocument res = CopyResponseDocument.Factory.newInstance();
            res.addNewCopyResponse();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not copy.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)("Could not copy. Reason: " + e.getClass().getName()));
        }
    }

    protected abstract String getStorageRoot() throws ExecutionException;

    @ConcurrentAccess(allow=true)
    public CreateDirectoryResponseDocument CreateDirectory(CreateDirectoryDocument in) throws BaseFault {
        try {
            String path = this.makeSMSLocal(in.getCreateDirectory().getPath());
            IStorageAdapter tsi = this.getStorageAdapter();
            tsi.mkdir(path);
            logger.debug((Object)("Created directory " + path));
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not create directory", (Throwable)e, (Logger)logger);
            throw new BaseFault("Could not create directory.");
        }
        CreateDirectoryResponseDocument res = CreateDirectoryResponseDocument.Factory.newInstance();
        res.addNewCreateDirectoryResponse();
        return res;
    }

    @ConcurrentAccess(allow=true)
    public DeleteResponseDocument Delete(DeleteDocument in) throws BaseFault {
        try {
            String path = this.makeSMSLocal(in.getDelete().getPath());
            IStorageAdapter tsi = this.getStorageAdapter();
            tsi.rmdir(path);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleted '" + path + "'"));
            }
            DeleteResponseDocument res = DeleteResponseDocument.Factory.newInstance();
            res.addNewDeleteResponse();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not perform delete.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)("Could not perform delete. Reason: " + e.getClass().getName()));
        }
    }

    @ConcurrentAccess(allow=true)
    public ExportFileResponseDocument ExportFile(ExportFileDocument in) throws BaseFault {
        try {
            String source = this.makeSMSLocal(in.getExportFile().getSource());
            XnjsFileWithACL file = this.getProperties(source);
            if (file == null) {
                throw new FileNotFoundException("File <" + source + "> not found on storage");
            }
            ExportFileResponseDocument res = ExportFileResponseDocument.Factory.newInstance();
            HashMap<String, Object> map = new HashMap<String, Object>();
            Boolean isPipe = in.getExportFile().getIsPipe();
            ProtocolType.Enum protocol = in.getExportFile().getProtocol();
            map.put("uas.filetransfer.impl.source", source);
            map.put("uas.filetransfer.impl.ispipe", isPipe);
            map.put("uas.filetransfer.impl.protocol", protocol);
            map.put("uas.filetransfer.impl.sms.isexport", Boolean.TRUE);
            map.put("uas.filetransfer.impl.sms.umask", this.getUmask());
            ExtraParametersDocument.ExtraParameters param = in.getExportFile().getExtraParameters();
            if (param != null) {
                map.put("uas.filetransfer.impl.extraparameters", this.parseExtraParameters(param));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Export: '" + source + "' " + protocol + " from " + this.getStorageRoot()));
            }
            EndpointReferenceType epr = this.createFileTransfer(map, protocol);
            res.addNewExportFileResponse().setExportEPR(epr);
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not create file export.", (Throwable)e, (Logger)logger);
            String errMsg = LogUtil.createFaultMessage((String)"Could not create file export", (Throwable)e);
            throw BaseFault.createFault((String)errMsg);
        }
    }

    @ConcurrentAccess(allow=true)
    public ImportFileResponseDocument ImportFile(ImportFileDocument in) throws BaseFault {
        try {
            ImportFileResponseDocument res = ImportFileResponseDocument.Factory.newInstance();
            HashMap<String, Object> map = new HashMap<String, Object>();
            String target = this.makeSMSLocal(in.getImportFile().getDestination());
            this.checkImportTarget(target);
            Boolean isPipe = in.getImportFile().getIsPipe();
            ProtocolType.Enum protocol = in.getImportFile().getProtocol();
            map.put("uas.filetransfer.impl.target", target);
            map.put("uas.filetransfer.impl.ispipe", isPipe);
            map.put("uas.filetransfer.impl.protocol", protocol);
            map.put("uas.filetransfer.impl.sms.wd", this.getStorageRoot());
            map.put("uas.filetransfer.impl.sms.isexport", Boolean.FALSE);
            map.put("uas.filetransfer.impl.sms.umask", this.getUmask());
            Boolean overwrite = Boolean.TRUE;
            if (in.getImportFile().isSetOverwrite()) {
                overwrite = in.getImportFile().getOverwrite();
            }
            map.put("uas.filetransfer.impl.sms.overwrite", overwrite);
            ExtraParametersDocument.ExtraParameters param = in.getImportFile().getExtraParameters();
            if (param != null) {
                map.put("uas.filetransfer.impl.extraparameters", this.parseExtraParameters(param));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Import: '" + target + "' " + protocol + " to " + this.getStorageRoot() + " overwrite=" + overwrite));
            }
            this.createParentDirectories(target);
            EndpointReferenceType epr = this.createFileTransfer(map, protocol);
            res.addNewImportFileResponse().setImportEPR(epr);
            return res;
        }
        catch (Exception e) {
            String msg = LogUtil.createFaultMessage((String)"Could not create file import", (Throwable)e);
            LogUtil.logException((String)"Could not create file import", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)msg);
        }
    }

    protected void checkImportTarget(String target) throws Exception {
        XnjsFileWithACL f = this.getProperties(target);
        if (f == null) {
            return;
        }
        if (f.isDirectory()) {
            throw new IllegalArgumentException("Invalid target filename " + target + ": is a directory");
        }
    }

    @ConcurrentAccess(allow=true)
    public ReceiveFileResponseDocument ReceiveFile(ReceiveFileDocument in) throws BaseFault {
        String source = in.getReceiveFile().getSource();
        String target = in.getReceiveFile().getDestination();
        try {
            URI sourceURI = new URI(SMSBaseImpl.urlEncode(source));
            HashMap<String, Object> map = new HashMap<String, Object>();
            Boolean isPipe = Boolean.FALSE;
            if (!target.startsWith(this.getSeparator())) {
                target = this.getSeparator() + target;
            }
            if (this.isAutoNegotiateScheme(sourceURI.getScheme())) {
                ProtocolType.Enum protocol = this.autoNegotiateProtocol(sourceURI);
                source = new URI(protocol.toString(), sourceURI.getSchemeSpecificPart(), sourceURI.getFragment()).toString();
            }
            map.put("uas.filetransfer.impl.target", target);
            map.put("uas.filetransfer.impl.ispipe", isPipe);
            map.put("uas.filetransfer.impl.source", source);
            map.put("uas.filetransfer.impl.sms.isexport", Boolean.FALSE);
            map.put("uas.filetransfer.impl.sms.umask", this.getUmask());
            if (in.getReceiveFile().isSetReliableMode()) {
                map.put("reliableMode", in.getReceiveFile().getReliableMode());
            } else {
                map.put("reliableMode", Boolean.FALSE);
            }
            ExtraParametersDocument.ExtraParameters param = in.getReceiveFile().getExtraParameters();
            if (param != null) {
                map.put("uas.filetransfer.impl.extraparameters", this.parseExtraParameters(param));
            }
            EndpointReferenceType epr = this.createTransferResource(map);
            ReceiveFileResponseDocument res = ReceiveFileResponseDocument.Factory.newInstance();
            res.addNewReceiveFileResponse().setReceiveFileEPR(epr);
            logger.debug((Object)("Receiving data from <" + source + "> target is <" + target + ">"));
            return res;
        }
        catch (Exception e) {
            String msg = LogUtil.createFaultMessage((String)"Could not initiate receive file.", (Throwable)e);
            LogUtil.logException((String)"Could not initiate receive file.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)msg);
        }
    }

    @ConcurrentAccess(allow=true)
    public SendFileResponseDocument SendFile(SendFileDocument in) throws BaseFault {
        String source = in.getSendFile().getSource();
        String target = in.getSendFile().getDestination();
        try {
            XnjsFileWithACL xnjsFile = this.getProperties(source);
            if (xnjsFile == null) {
                throw new Exception("File " + source + " not found on this storage.");
            }
            URI targetURI = new URI(SMSBaseImpl.urlEncode(target));
            if (this.isAutoNegotiateScheme(targetURI.getScheme())) {
                ProtocolType.Enum protocol = null;
                protocol = xnjsFile.getSize() > 0x100000L ? ProtocolType.BFT : this.autoNegotiateProtocol(targetURI);
                target = new URI(protocol.toString(), targetURI.getSchemeSpecificPart(), targetURI.getFragment()).toString();
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            Boolean isPipe = Boolean.FALSE;
            if (!source.startsWith(this.getSeparator())) {
                source = this.getSeparator() + source;
            }
            map.put("uas.filetransfer.impl.target", target);
            map.put("uas.filetransfer.impl.ispipe", isPipe);
            map.put("uas.filetransfer.impl.source", source);
            map.put("uas.filetransfer.impl.sms.isexport", Boolean.TRUE);
            map.put("uas.filetransfer.impl.sms.umask", this.getUmask());
            ExtraParametersDocument.ExtraParameters param = in.getSendFile().getExtraParameters();
            if (param != null) {
                map.put("uas.filetransfer.impl.extraparameters", this.parseExtraParameters(param));
            }
            EndpointReferenceType epr = this.createTransferResource(map);
            SendFileResponseDocument res = SendFileResponseDocument.Factory.newInstance();
            res.addNewSendFileResponse().setSendFileEPR(epr);
            logger.debug((Object)("Sending data to <" + target + "> source is <" + source + ">"));
            return res;
        }
        catch (Exception e) {
            String msg = LogUtil.createFaultMessage((String)"Could not initiate send file", (Throwable)e);
            LogUtil.logException((String)"Could not initiate send file", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)msg);
        }
    }

    protected EndpointReferenceType createTransferResource(Map<String, Object> initParam) throws Exception {
        initParam.put("uas.filetransfer.impl.sms", WSServerUtilities.makeEPR((String)this.getServiceName(), (String)this.getUniqueID(), (Kernel)this.kernel));
        initParam.put("uas.filetransfer.impl.sms.wd", this.getStorageRoot());
        initParam.put("uas.filetransfer.impl.sms.storageadapterfactory", this.getStorageAdapterFactory());
        initParam.put(INITPARAM_XNJS_REFERENCE, this.xnjsReference);
        initParam.put(INIT_PARENT_NODE, this.nodeHelper);
        String id = this.kernel.getHome("FileTransfer").createWSRFServiceInstance(initParam);
        ResourceAddedMessage m = new ResourceAddedMessage("FileTransfer", id);
        this.getKernel().getMessaging().getChannel(this.getUniqueID()).publish((Message)m);
        EndpointReferenceType epr = WSServerUtilities.makeEPR((String)"FileTransfer", (String)id, (Kernel)this.kernel);
        WSServerUtilities.addUGSRefparamToEpr((EndpointReferenceType)epr, (String)id);
        return epr;
    }

    public ListDirectoryResponseDocument ListDirectory(ListDirectoryDocument in) throws BaseFault {
        int limit;
        ListDirectoryResponseDocument resd = ListDirectoryResponseDocument.Factory.newInstance();
        ListDirectoryResponseDocument.ListDirectoryResponse res = resd.addNewListDirectoryResponse();
        BigInteger offsetP = in.getListDirectory().getOffset();
        int offset = offsetP != null ? offsetP.intValue() : 0;
        BigInteger limitP = in.getListDirectory().getLimit();
        int max = this.uasProperties.getIntValue("sms.lsLimit");
        int n = limit = limitP != null ? limitP.intValue() : max;
        if (limit > max) {
            String msg = "Could not list directory: the requested number of results exceeds the internal limit of <" + max + ">. " + "Please use the limit and offset parameters!";
            logger.warn((Object)msg);
            throw BaseFault.createFault((String)msg);
        }
        try {
            XnjsFile[] tsifiles;
            String p = this.makeSMSLocal(in.getListDirectory().getPath());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Listing '" + p + "' workdir=" + this.getStorageRoot()));
            }
            for (XnjsFile f : tsifiles = this.getListing(p, offset, limit, this.storageDescription.isFilterListing())) {
                GridFileType gf = res.addNewGridFile();
                this.convert(f, gf);
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("XNJS filepath: " + f.getPath() + " -> " + gf.getPath()));
            }
        }
        catch (Exception e) {
            String msg = "Could not list directory: " + e.getMessage();
            LogUtil.logException((String)"Could not list directory", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)msg);
        }
        return resd;
    }

    protected XnjsFile[] getListing(String path, int offset, int limit, boolean filter) throws Exception {
        IStorageAdapter tsi = this.getStorageAdapter();
        return tsi.ls(path, offset, limit, filter);
    }

    protected XnjsFileWithACL getProperties(String path) throws Exception {
        IStorageAdapter tsi = this.getStorageAdapter();
        return tsi.getProperties(path);
    }

    protected String makeSMSLocal(String p) {
        String res = SMSBaseImpl.urlDecode(p).replace('\\', '/');
        if (res.length() == 0 || '/' != res.charAt(0)) {
            res = "/" + res;
        }
        res = res.replace("//", "/");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Got path:" + p + ", converted to " + res));
        }
        return res;
    }

    public static String urlDecode(String p) {
        try {
            return URLDecoder.decode(p.replaceAll("\\+", "%20"), "UTF-8");
        }
        catch (Exception ex) {
            logger.warn((Object)ex);
            return p;
        }
    }

    public static String urlEncode(String orig) {
        try {
            return URIUtils.encodeAll((String)orig);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return orig;
        }
    }

    protected void convert(XnjsFile f, GridFileType gf, boolean addMetadata) throws Exception {
        XnjsFileWithACL fWithACL;
        ACLEntry[] acl;
        gf.setPath(f.getPath());
        gf.setSize(f.getSize());
        gf.setIsDirectory(f.isDirectory());
        gf.setLastModified(f.getLastModified());
        Permissions p = f.getPermissions();
        gf.addNewPermissions().setReadable(p.isReadable());
        gf.getPermissions().setWritable(p.isWritable());
        gf.getPermissions().setExecutable(p.isExecutable());
        if (addMetadata) {
            MetadataManager mm = this.getMetadataManager();
            try {
                if (mm != null) {
                    this.attachMetadata(f, gf, mm);
                }
            }
            catch (Exception ex) {
                LogUtil.logException((String)("Error attaching metadata for file " + f.getPath()), (Throwable)ex);
            }
        }
        if (f.getUNIXPermissions() != null) {
            gf.setFilePermissions(f.getUNIXPermissions());
        }
        if (f.getGroup() != null) {
            gf.setGroup(f.getGroup());
        }
        if (f.getOwner() != null) {
            gf.setOwner(f.getOwner());
        }
        if (f instanceof XnjsFileWithACL && (acl = (fWithACL = (XnjsFileWithACL)f).getACL()) != null) {
            ACLType xmlACL = gf.addNewACL();
            for (ACLEntry aclEntry : acl) {
                ACLEntryType xmlACLEntry = xmlACL.addNewEntry();
                xmlACLEntry.setPermissions(aclEntry.getPermissions());
                xmlACLEntry.setSubject(aclEntry.getSubject());
                if (aclEntry.getType() == ACLEntry.Type.GROUP) {
                    xmlACLEntry.setType(ACLEntryTypeType.GROUP);
                } else {
                    xmlACLEntry.setType(ACLEntryTypeType.USER);
                }
                xmlACLEntry.setDefaultACL(aclEntry.isDefaultACL());
            }
        }
    }

    protected void attachMetadata(XnjsFile f, GridFileType gridFile, MetadataManager metaManager) throws Exception {
        if (gridFile.getIsDirectory()) {
            return;
        }
        String resourceName = gridFile.getPath();
        Map<String, String> metadata = metaManager.getMetadataByName(resourceName);
        MetadataType md = gridFile.addNewMetadata();
        for (Map.Entry<String, String> item : metadata.entrySet()) {
            String key = item.getKey();
            String value = item.getValue();
            if ("Content-MD5".equalsIgnoreCase(key)) {
                md.setContentMD5(value);
                continue;
            }
            if ("Content-Type".equalsIgnoreCase(key)) {
                md.setContentType(value);
                continue;
            }
            TextInfoType t = md.addNewProperty();
            t.setName(key);
            t.setValue(value);
        }
    }

    protected void convert(XnjsFile f, GridFileType gf) throws Exception {
        this.convert(f, gf, false);
    }

    public ListPropertiesResponseDocument ListProperties(ListPropertiesDocument in) throws BaseFault {
        String request = in.getListProperties().getPath();
        if (request == null) {
            throw BaseFault.createFault((String)"Could not list properties: target path is null.");
        }
        ListPropertiesResponseDocument res = ListPropertiesResponseDocument.Factory.newInstance();
        res.addNewListPropertiesResponse();
        try {
            String path = this.makeSMSLocal(request);
            XnjsFileWithACL file = this.getProperties(path);
            if (file != null) {
                GridFileType gf = res.getListPropertiesResponse().addNewGridFile();
                this.convert((XnjsFile)file, gf, true);
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)("Could not list properties of <" + request + ">"), (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)("Could not list properties of <" + request + ">. Reason: " + e.getClass().getName()));
        }
        return res;
    }

    public RenameResponseDocument Rename(RenameDocument in) throws BaseFault {
        try {
            String source = this.makeSMSLocal(in.getRename().getSource());
            String target = this.makeSMSLocal(in.getRename().getDestination());
            IStorageAdapter tsi = this.getStorageAdapter();
            tsi.rename(source, target);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Renamed '" + source + "' -> '" + target + "'"));
            }
            RenameResponseDocument res = RenameResponseDocument.Factory.newInstance();
            res.addNewRenameResponse();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not rename.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)("Could not rename. Reason: " + e.getClass().getName()));
        }
    }

    public FindResponseDocument Find(FindDocument in) throws BaseFault {
        FindResponseDocument resd = FindResponseDocument.Factory.newInstance();
        FindResponseDocument.FindResponse res = resd.addNewFindResponse();
        try {
            XnjsFile[] tsifiles;
            FindDocument.Find find = in.getFind();
            String base = find.getBase();
            CompositeFindOptions opts = XNJSFacade.get(this.xnjsReference, this.kernel).getFindOptions(find.getFilter());
            if (find.isSetRecurse()) {
                opts.setRecurse(find.getRecurse());
            }
            String p = this.makeSMSLocal(base);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Listing <" + p + "> workdir=" + this.getStorageRoot()));
            }
            IStorageAdapter tsi = this.getStorageAdapter();
            for (XnjsFile f : tsifiles = tsi.find(base, (FileFilter)opts, -1, -1)) {
                if (this.storageDescription.isFilterListing() && !f.isOwnedByCaller()) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("Skipping " + f.getPath() + ", not owned by caller."));
                    continue;
                }
                GridFileType gf = res.addNewGridFile();
                this.convert(f, gf);
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("XNJS filepath: " + f.getPath() + " -> " + gf.getPath()));
            }
            return resd;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not perform find operation.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)("Could not perform find operation. Reason: " + e.getClass().getName()));
        }
    }

    @Override
    public void initialise(String name, Map<String, Object> initobjs) throws Exception {
        Boolean inheritSharing;
        super.initialise(name, initobjs);
        this.storageDescription = (StorageDescription)initobjs.get(INIT_STORAGE_DESCRIPTION);
        if (this.storageDescription == null) {
            throw new IllegalStateException("No storage configuration found");
        }
        this.properties.put(RPProtocol, new UpdatingProtocolRP((Resource)this, this.storageDescription));
        String fsname = this.storageDescription.getName();
        this.properties.put(RPFileSystem, this.makeFileSystemRP(fsname));
        this.properties.put(ACLSupported, new ACLSupportedRP((ResourceImpl)this, fsname));
        this.addUmaskRP(this.storageDescription.getDefaultUmask());
        this.storageFactoryID = (String)initobjs.get(INIT_FACTORYID);
        this.disableMetadata = (Boolean)initobjs.get(INIT_DISABLE_METADATA);
        if (this.disableMetadata == null) {
            this.disableMetadata = Boolean.FALSE;
        }
        if ((inheritSharing = (Boolean)initobjs.get(INIT_INHERIT_SHARING)) != null) {
            this.inheritSharing = inheritSharing;
        }
        this.properties.put(RPInternalFiletransferReference, new FiletransferReferenceRP((Resource)this));
        String enumerationID = this.createFTListEnumeration();
        AddressResourceProperty ftListAddress = new AddressResourceProperty((Resource)this, RPFiletransferEnumerationReference, "Enumeration?res=" + enumerationID, true);
        this.properties.put(RPFiletransferEnumerationReference, ftListAddress);
        try {
            Boolean publishFlag = (Boolean)initobjs.get(INITPARAM_PUBLISH_TO_REGISTRY);
            if (Boolean.TRUE.equals(publishFlag)) {
                logger.info((Object)("Publishing StorageManagement <" + this.getUniqueID() + "> to registry."));
                this.publish();
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)"Problem publishing to registry", (Throwable)e, (Logger)logger);
        }
    }

    protected String createFTListEnumeration() throws Exception {
        HashMap<String, Object> init = new HashMap<String, Object>();
        init.put("targetServiceEPR", this.getEPR());
        init.put("targetPropertyQName", RPInternalFiletransferReference);
        Calendar c = Calendar.getInstance();
        c.add(2, 24);
        init.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", c);
        init.put(INIT_PARENT_NODE, this.getNode());
        Home h = this.kernel.getHome("Enumeration");
        if (h == null) {
            throw new Exception("Enumeration service is not deployed!");
        }
        return h.createWSRFServiceInstance(init);
    }

    protected UmaskResourceProperty addUmaskRP(String umask) {
        UmaskResourceProperty umaskRP = new UmaskResourceProperty(this, umask);
        umaskRP.setListener(new UmaskListenerImpl());
        this.properties.put(StorageManagement.RPUmask, umaskRP);
        return umaskRP;
    }

    @Override
    protected final void customPostActivate() {
        this.enableDirectFiletransfer = this.uasProperties.getBooleanValue("filetransfer.direct");
        UmaskResourceProperty umaskRP = (UmaskResourceProperty)((Object)this.properties.get(RPUmask));
        if (umaskRP == null) {
            umaskRP = this.addUmaskRP(Integer.toOctalString(63));
        }
        umaskRP.setListener(new UmaskListenerImpl());
        try {
            logger.trace((Object)("Getting messages from queue " + this.getUniqueID()));
            PullPoint p = this.kernel.getMessaging().getPullPoint(this.getUniqueID());
            FiletransferReferenceRP rp = (FiletransferReferenceRP)((Object)this.properties.get(RPInternalFiletransferReference));
            while (p.hasNext()) {
                String service;
                String id;
                Message message = p.next();
                if (message instanceof ResourceDeletedMessage) {
                    ResourceDeletedMessage rdm = (ResourceDeletedMessage)message;
                    id = rdm.getDeletedResource();
                    service = rdm.getServiceName();
                    if (!"FileTransfer".equals(service)) continue;
                    rp.remove(id);
                    this.setDirty();
                    continue;
                }
                if (!(message instanceof ResourceAddedMessage)) continue;
                ResourceAddedMessage ram = (ResourceAddedMessage)message;
                id = ram.getAddedResource();
                service = ram.getServiceName();
                if (!"FileTransfer".equals(service)) continue;
                rp.add(id);
                this.setDirty();
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)e.getMessage(), (Throwable)e, (Logger)logger);
        }
        this.smsPostActivate();
    }

    protected void smsPostActivate() {
    }

    public void destroy() {
        AddressResourceProperty mrp;
        if (this.storageFactoryID != null) {
            try {
                ResourceDeletedMessage m = new ResourceDeletedMessage((Serializable)((Object)("deleted:" + this.getUniqueID())));
                m.setDeletedResource(this.getUniqueID());
                m.setServiceName(this.getServiceName());
                this.kernel.getMessaging().getChannel(this.storageFactoryID).publish((Message)m);
            }
            catch (Exception e) {
                LogUtil.logException((String)"Could not send internal message.", (Throwable)e, (Logger)logger);
            }
        }
        if (this.storageDescription.isCleanupOnDestroy()) {
            try {
                this.getStorageAdapter().rmdir("/");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((mrp = (AddressResourceProperty)this.properties.get(RPMetadataServiceReference)) != null) {
            try {
                EndpointReferenceType uspace = ((MetadataServiceReferenceDocument)mrp.update().getXml()[0]).getMetadataServiceReference();
                BaseUASClient c = new BaseUASClient(uspace, (IClientConfiguration)this.kernel.getClientConfiguration());
                c.destroy();
            }
            catch (Exception e) {
                LogUtil.logException((String)"Could not destroy metadata service instance.", (Throwable)e, (Logger)logger);
            }
        }
        super.destroy();
    }

    public static List<ProtocolType.Enum> parseStorageProtocols(String protocolList) {
        ArrayList<ProtocolType.Enum> protocols = new ArrayList<ProtocolType.Enum>();
        if (protocolList != null) {
            logger.debug((Object)("Adding protocols <" + protocolList + ">"));
            try {
                String[] ps;
                for (String entry : ps = protocolList.split(" +")) {
                    ProtocolType.Enum p = ProtocolType.Enum.forString((String)entry.toUpperCase());
                    if (p == null) continue;
                    protocols.add(p);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Can't add protocols", (Throwable)e);
            }
        }
        if (protocols.size() == 0) {
            logger.debug((Object)"No protocols configured for SMS. Falling back to 'RBYTEIO' and 'BFT'");
            protocols.add(ProtocolType.RBYTEIO);
            protocols.add(ProtocolType.BFT);
        }
        return protocols;
    }

    protected EndpointReferenceType createFileTransfer(Map<String, Object> initParam, ProtocolType.Enum protocol) throws Exception {
        initParam.put("uas.filetransfer.impl.sms", WSServerUtilities.makeEPR((String)this.getServiceName(), (String)this.getUniqueID(), (Kernel)this.kernel));
        initParam.put("uas.filetransfer.impl.sms.wd", this.getStorageRoot());
        initParam.put("uas.filetransfer.impl.sms.storageadapterfactory", this.getStorageAdapterFactory());
        initParam.put(INITPARAM_XNJS_REFERENCE, this.xnjsReference);
        initParam.put(INIT_PARENT_NODE, this.getNode());
        Home home = this.kernel.getHome("FileTransfer" + protocol.toString());
        if (home == null) {
            throw new Exception("Requested service <FileTransfer" + protocol.toString() + "> is not available.");
        }
        String id = home.createWSRFServiceInstance(initParam);
        EndpointReferenceType epr = WSServerUtilities.newEPR((IContainerSecurityConfiguration)this.kernel.getContainerSecurityConfiguration());
        if (!this.enableDirectFiletransfer.booleanValue()) {
            epr.addNewAddress().setStringValue(WSServerUtilities.makeAddress((String)("FileTransfer" + protocol), (String)id, (ContainerProperties)this.kernel.getContainerProperties()));
        } else {
            String serv = this.kernel.getContainerProperties().getValue("servletpath");
            String baseAddr = Utilities.getPhysicalServerAddress((ContainerProperties)this.kernel.getContainerProperties(), (boolean)this.kernel.getContainerSecurityConfiguration().isSslEnabled());
            String add = baseAddr + serv + "/" + "FileTransfer" + protocol + "?res=" + id;
            epr.addNewAddress().setStringValue(add);
            logger.debug((Object)("Direct filetransfer enabled, address= " + add));
        }
        WSServerUtilities.addUGSRefparamToEpr((EndpointReferenceType)epr, (String)id);
        return epr;
    }

    protected String getSeparator() {
        if (this.sep == null) {
            try {
                this.sep = this.getTSI().getFileSeparator();
            }
            catch (ExecutionException ex) {
                LogUtil.logException((String)"Could not get file separator", (Throwable)ex, (Logger)logger);
                this.sep = "/";
            }
        }
        return this.sep;
    }

    protected void createParentDirectories(String target) throws Exception {
        while (target.startsWith("/")) {
            target = target.substring(1);
        }
        String[] dirs = target.split("/");
        String dir = "";
        if (dirs.length > 1 && dirs[0].length() != 0) {
            for (int i = 0; i < dirs.length - 1; ++i) {
                if (i > 0) {
                    dir = dir + "/";
                }
                dir = dir + dirs[i];
            }
        }
        if (dir.length() > 0) {
            String path = dir;
            IStorageAdapter tsi = this.getStorageAdapter();
            XnjsFileWithACL xDir = tsi.getProperties(path);
            if (xDir == null) {
                logger.debug((Object)("Creating directory " + path));
                tsi.mkdir(path);
            } else if (!xDir.isDirectory()) {
                throw new IOException("</" + dir + "> already exists on this storage and is not a directory");
            }
        }
    }

    public IStorageAdapter getStorageAdapter() throws Exception {
        TSI tsi = this.getTSI();
        tsi.setStorageRoot(this.getStorageRoot());
        return tsi;
    }

    private TSI getTSI() {
        Client client = this.getClient();
        TSI ret = XNJSFacade.get(this.xnjsReference, this.kernel).getConfiguration().getTargetSystemInterface(client);
        ret.setUmask(this.getUmask());
        return ret;
    }

    protected StorageAdapterFactory getStorageAdapterFactory() {
        return new TSIStorageAdapterFactory(this.xnjsReference);
    }

    protected FileSystemRP makeFileSystemRP(String name) {
        return new FileSystemRP((ResourceImpl)this, name);
    }

    protected MetadataManager getMetadataManager() throws Exception {
        if (this.disableMetadata.booleanValue()) {
            return null;
        }
        MetadataManager mm = MetadataSupport.getManager(this.kernel, this.getStorageAdapter(), this.getUniqueID());
        return mm;
    }

    protected String getMetadataManagementImplClassName() {
        return MetadataManagementImpl.class.getName();
    }

    protected String createMetadataServiceInstance() {
        Home mdHome = this.kernel.getHome("MetadataManagement");
        if (mdHome != null) {
            try {
                HashMap<String, Object> opts = new HashMap<String, Object>();
                opts.put(BaseMetadataManagementImpl.INIT_SMS_ID, this.getUniqueID());
                Calendar tt = Calendar.getInstance();
                tt.add(1, 10);
                opts.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", tt);
                opts.put(INIT_UNIQUE_ID, this.getUniqueID() + "_metadata");
                opts.put(INIT_PARENT_NODE, this.getNode());
                return mdHome.createWSRFServiceInstance(opts);
            }
            catch (Exception ex) {
                Log.logException((String)"", (Throwable)ex, (Logger)logger);
            }
        }
        return null;
    }

    protected void setupMetadataService() throws Exception {
        if (!this.disableMetadata.booleanValue()) {
            String uid = this.createMetadataServiceInstance();
            if (uid == null) {
                this.disableMetadata = Boolean.TRUE;
            } else {
                QName q = MetadataServiceReferenceDocument.type.getDocumentElementName();
                String serviceSpec = "MetadataManagement?res=" + uid;
                AddressResourceProperty rp = new AddressResourceProperty((Resource)this, q, serviceSpec, false);
                this.properties.put(RPMetadataServiceReference, rp);
            }
        }
    }

    protected EndpointReferenceType createRemoteStorageEPR(URI uri) {
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        String withoutScheme = uri.getSchemeSpecificPart();
        String upToFragment = withoutScheme.split("#")[0];
        epr.addNewAddress().setStringValue(upToFragment);
        return epr;
    }

    protected boolean isAutoNegotiateScheme(String scheme) {
        return AUTO_NEGOTIATE_SCHEMES.contains(scheme.toLowerCase());
    }

    protected ProtocolType.Enum autoNegotiateProtocol(URI fileURI) throws Exception {
        ProtocolType.Enum result;
        EndpointReferenceType storageEpr = this.createRemoteStorageEPR(fileURI);
        String key = storageEpr.getAddress().getStringValue();
        Element cached = protocolCache.get((Serializable)((Object)key));
        ProtocolType.Enum enum_ = result = cached == null ? null : (ProtocolType.Enum)cached.getValue();
        if (result == null) {
            StorageClient sc = new StorageClient(storageEpr, (IClientConfiguration)this.getKernel().getClientConfiguration());
            ProtocolType.Enum[] supported = sc.getSupportedProtocols();
            HashSet<ProtocolType.Enum> supportedSet = new HashSet<ProtocolType.Enum>();
            if (supported != null && supported.length > 0) {
                supportedSet.addAll(Arrays.asList(supported));
            }
            for (ProtocolType.Enum current : this.getStorageProtocols()) {
                if (!supportedSet.contains(current)) continue;
                return current;
            }
            if (result == null) {
                return ProtocolType.BFT;
            }
        }
        if (cached == null) {
            cached = new Element((Serializable)((Object)key), (Serializable)result);
        }
        protocolCache.put(cached);
        return result;
    }

    protected ProtocolType.Enum[] getStorageProtocols() {
        ResourceProperty p = this.getResourceProperty(RPProtocol);
        if (p == null) {
            return new ProtocolType.Enum[0];
        }
        if (p instanceof ProtocolRP) {
            return ((ProtocolRP)p).getProperty();
        }
        return ((UpdatingProtocolRP)p).getProperty();
    }

    protected synchronized FiletransferReferenceRP getFiletransferReferenceRP() {
        FiletransferReferenceRP rp = (FiletransferReferenceRP)((Object)this.properties.get(RPInternalFiletransferReference));
        if (rp == null) {
            rp = new FiletransferReferenceRP((Resource)this);
            this.properties.put(RPInternalFiletransferReference, rp);
            this.setDirty();
        }
        return rp;
    }

    private static Cache initProtocolCache() {
        Configuration cmCfg = new Configuration();
        CacheConfiguration def = new CacheConfiguration();
        cmCfg.setUpdateCheck(false);
        cmCfg.addDefaultCache(def);
        DiskStoreConfiguration dsCfg = new DiskStoreConfiguration();
        dsCfg.setPath(System.getProperty("java.io.tmpdir") + File.separator + "protocolCache" + new Random().nextLong());
        cmCfg.addDiskStore(dsCfg);
        CacheManager cacheMan = new CacheManager(cmCfg);
        Cache result = new Cache("protocolCache", 100, MemoryStoreEvictionPolicy.LFU, false, null, false, 300L, 300L, false, 60L, null);
        cacheMan.addCache(result);
        return result;
    }

    private Map<String, String> parseExtraParameters(ExtraParametersDocument.ExtraParameters param) {
        HashMap<String, String> result = new HashMap<String, String>();
        PropertyType[] params = param.getParameterArray();
        if (params != null) {
            for (PropertyType p : params) {
                result.put(p.getName(), p.getValue());
            }
        }
        return result;
    }

    public String getUmask() {
        UmaskResourceProperty rp = (UmaskResourceProperty)((Object)this.properties.get(RPUmask));
        if (rp == null) {
            return Integer.toOctalString(63);
        }
        return ((UmaskDocument[])rp.getXml())[0].getUmask();
    }

    public StorageDescription getStorageDescription() {
        return this.storageDescription;
    }

    public boolean isRecursiveVOMembershipChangeHonored() {
        return this.inheritSharing;
    }

    public void updateVoMembership(Map<? extends VODescription, Set<OperationType>> addedVos, Map<? extends VODescription, Set<OperationType>> modifiedVos, Map<? extends VODescription, Set<OperationType>> removedVos, Map<? extends VODescription, Set<OperationType>> newVoMembership) throws Exception {
        StorageSharingMode mode = (StorageSharingMode)this.uasProperties.getEnumValue("sms.sharingMode", StorageSharingMode.class);
        if (mode == StorageSharingMode.DISABLED) {
            throw new Exception("Sharing of files is disabled on this service by administrators.");
        }
        if (this.getStorageAdapter() instanceof LocalTS) {
            throw new Exception("Sharing of files is not possibled in storage served by embedded Java TSI.");
        }
        if (mode == StorageSharingMode.PREFER_ACL) {
            StorageSharingMode storageSharingMode = mode = this.getStorageAdapter().isACLSupported(this.getStorageRoot()) ? StorageSharingMode.ACL : StorageSharingMode.CHMOD;
        }
        if (mode == StorageSharingMode.ACL) {
            this.updateVoMembershipViaAcl(addedVos, modifiedVos, removedVos, newVoMembership);
        } else {
            this.updateVoMembershipViaChmod(addedVos, modifiedVos, removedVos, newVoMembership);
        }
    }

    protected void updateVoMembershipViaChmod(Map<? extends VODescription, Set<OperationType>> addedVos, Map<? extends VODescription, Set<OperationType>> modifiedVos, Map<? extends VODescription, Set<OperationType>> removedVos, Map<? extends VODescription, Set<OperationType>> newVoMembership) throws Exception {
        if (newVoMembership.size() > 1) {
            throw new Exception("This storage can be shared only with in a single group.");
        }
        Client client = AuthZAttributeStore.getClient();
        String pgid = client.getXlogin().getGroup();
        IStorageAdapter storage = this.getStorageAdapter();
        if (removedVos.size() == 1) {
            int curUmask = Integer.parseInt(storage.getUmask(), 8);
            int newMask = 0x38 | curUmask & 0xFFFFFFC7;
            storage.setUmask(Integer.toOctalString(newMask));
            ChangePermissions chPerm = new ChangePermissions(ChangePermissions.Mode.SUBTRACT, ChangePermissions.PermissionsClass.GROUP, "rwx");
            storage.chmod2(this.getStorageRoot(), new ChangePermissions[]{chPerm}, true);
        }
        Map.Entry<? extends VODescription, Set<OperationType>> added = null;
        if (modifiedVos.size() == 1) {
            added = modifiedVos.entrySet().iterator().next();
        } else if (addedVos.size() == 1) {
            added = addedVos.entrySet().iterator().next();
        }
        if (added != null) {
            String permsMod = this.getPermsMod(added.getValue());
            int curUmask = Integer.parseInt(storage.getUmask(), 8);
            int ownerUmaskShifted = (curUmask & 0x1C0) >> 8;
            int newMask = curUmask & 0x1C7 | ownerUmaskShifted;
            storage.setUmask(Integer.toOctalString(newMask));
            storage.chgrp(this.getStorageRoot(), pgid, true);
            ChangePermissions chPerm = new ChangePermissions(ChangePermissions.Mode.SET, ChangePermissions.PermissionsClass.GROUP, permsMod);
            storage.chmod2(this.getStorageRoot(), new ChangePermissions[]{chPerm}, true);
        }
    }

    protected void updateVoMembershipViaAcl(Map<? extends VODescription, Set<OperationType>> addedVos, Map<? extends VODescription, Set<OperationType>> modifiedVos, Map<? extends VODescription, Set<OperationType>> removedVos, Map<? extends VODescription, Set<OperationType>> newVoMembership) throws Exception {
        String permsMod;
        Client client = AuthZAttributeStore.getClient();
        String pgid = client.getXlogin().getGroup();
        if (removedVos.size() > 0) {
            this.setNormalAndDefACL(pgid, "---");
        }
        for (VODescription vODescription : addedVos.keySet()) {
            permsMod = this.getPermsMod(addedVos.get(vODescription));
            this.setNormalAndDefACL(pgid, permsMod);
        }
        for (VODescription vODescription : modifiedVos.keySet()) {
            permsMod = this.getPermsMod(addedVos.get(vODescription));
            this.setNormalAndDefACL(pgid, permsMod);
        }
    }

    protected void setNormalAndDefACL(String gid, String aclSpec) throws Exception {
        IStorageAdapter storage = this.getStorageAdapter();
        ChangeACL change = new ChangeACL(ACLEntry.Type.GROUP, gid, aclSpec, false, ChangeACL.ACLChangeMode.MODIFY);
        ChangeACL change2 = new ChangeACL(ACLEntry.Type.GROUP, gid, aclSpec, true, ChangeACL.ACLChangeMode.MODIFY);
        storage.setfacl(this.getStorageRoot(), false, new ChangeACL[]{change, change2}, true);
    }

    private String getPermsMod(Set<OperationType> ops) throws Exception {
        if (ops.contains(OperationType.modify)) {
            return "rwX";
        }
        if (ops.contains(OperationType.read)) {
            return "rX";
        }
        throw new Exception("Unsupported operation type for files sharing");
    }

    private class UmaskListenerImpl
    implements UmaskResourceProperty.UmaskChangedListener {
        private UmaskListenerImpl() {
        }

        @Override
        public void umaskChanged(String newUmask) throws InvalidModificationException {
            try {
                SMSBaseImpl.this.getTSI().setUmask(newUmask);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidModificationException(e.getMessage());
            }
        }
    }
}

