/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.sms;

import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.tsi.TSI;
import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;

public class PathedStorageImpl
extends SMSBaseImpl {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", PathedStorageImpl.class);
    protected String storageRoot;
    public static String INIT_SKIP_RESOLVE = PathedStorageImpl.class.getName() + "_skip_initial_resolve";

    @Override
    protected void smsPostActivate() {
        this.storageRoot = null;
    }

    @Override
    protected synchronized String getStorageRoot() {
        if (this.storageRoot == null) {
            try {
                this.resolveRootDir();
            }
            catch (ExecutionException e) {
                LogUtil.logException((String)("Could not resolve location: " + this.workdir), (Throwable)e, (Logger)logger);
                return this.workdir;
            }
        }
        return this.storageRoot;
    }

    private void resolveRootDir() throws ExecutionException {
        TSI tsi = XNJSFacade.get(this.xnjsReference, this.kernel).getTSI(this.getClient());
        this.storageRoot = tsi.resolve(this.workdir);
        if (tsi.isLocal()) {
            this.storageRoot = new File(this.storageRoot).getAbsolutePath();
        }
        if (this.getSeparator().equals(this.storageRoot)) {
            throw new ExecutionException("Variable path was resolved to '/', this is not allowed");
        }
    }

    @Override
    public void initialise(String name, Map<String, Object> initobjs) throws Exception {
        super.initialise(name, initobjs);
        this.workdir = this.storageDescription.getPathSpec();
        if (this.workdir == null) {
            throw new IllegalArgumentException("Work directory cannot be null.");
        }
        if (!this.workdir.endsWith(this.getSeparator())) {
            this.workdir = this.workdir + this.getSeparator();
        }
        if (!Boolean.TRUE.equals(initobjs.get(INIT_SKIP_RESOLVE))) {
            this.resolveRootDir();
        }
        if (this.storageRoot != null) {
            logger.info((Object)("SMS init in <" + this.workdir + "> resolved as <" + this.storageRoot + ">"));
            if (!Boolean.TRUE.equals(initobjs.get(SMSBaseImpl.INIT_SKIP_EXISTENCECHECK))) {
                this.checkDirExists();
            }
        } else {
            logger.info((Object)("SMS init in <" + this.workdir + ">"));
        }
    }

    private void checkDirExists() throws ExecutionException {
        TSI tsi = XNJSFacade.get(this.xnjsReference, this.kernel).getTSI(this.getClient());
        XnjsFileWithACL xnjsFile = tsi.getProperties(this.storageRoot);
        if (xnjsFile == null) {
            throw new ExecutionException("Directory '" + this.storageRoot + "' does not exist.");
        }
        if (!xnjsFile.isDirectory()) {
            throw new ExecutionException("Path '" + this.storageRoot + "' is not a directory.");
        }
    }
}

