/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.sms;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.impl.LockSupport;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class InitDefaultStorageFactory
implements Runnable {
    private static final Logger logger = LogUtil.getLogger((String)"unicore", InitDefaultStorageFactory.class);
    private final Kernel kernel;

    public InitDefaultStorageFactory(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void run() {
        try {
            this.createDefaultStorageFactoryIfNotExists();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup default storage factory.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultStorageFactoryIfNotExists() throws ResourceNotCreatedException, PersistenceException {
        Home smfHome = this.kernel.getHome("StorageFactory");
        if (smfHome == null) {
            logger.info((Object)"No StorageFactory service configured for this site!");
            return;
        }
        LockSupport ls = this.kernel.getPersistenceManager().getLockSupport();
        Lock smfLock = ls.getOrCreateLock(InitDefaultStorageFactory.class.getName());
        String defaultSmfName = "default_storage_factory";
        if (smfLock.tryLock()) {
            try {
                smfHome.get(defaultSmfName);
                UASWSResourceImpl smf = (UASWSResourceImpl)smfHome.get(defaultSmfName);
                smf.publish();
                return;
            }
            catch (ResourceUnknownException e) {
                this.doCreateSMF(smfHome);
            }
            finally {
                smfLock.unlock();
            }
        }
    }

    private void doCreateSMF(Home smfHome) throws ResourceNotCreatedException {
        String defaultSmfName = "default_storage_factory";
        HashMap<String, Object> imap = new HashMap<String, Object>();
        imap.put(WSResourceImpl.INIT_UNIQUE_ID, defaultSmfName);
        GregorianCalendar c = new GregorianCalendar();
        ((Calendar)c).add(2, 36);
        imap.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", c);
        smfHome.createWSRFServiceInstance(imap);
        logger.info((Object)("Added default StorageFactory resource " + defaultSmfName + "."));
    }
}

