/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.sms;

import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import eu.unicore.security.Client;
import java.util.Map;
import org.apache.log4j.Logger;

public class HomeStorageImpl
extends SMSBaseImpl {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", HomeStorageImpl.class);
    private transient String homeDirectory = null;

    @Override
    public void initialise(String name, Map<String, Object> initobjs) throws Exception {
        super.initialise(name, initobjs);
        this.setHome();
    }

    private void setHome() throws ExecutionException {
        Client client = this.getClient();
        this.homeDirectory = XNJSFacade.get(this.xnjsReference, this.kernel).getGrounder().incarnatePath("", "HOME", null, client);
        if (logger.isDebugEnabled()) {
            String xlogin = "n/a";
            String dn = "unknown";
            if (client != null && client.getXlogin().getUserName() != null) {
                xlogin = client.getXlogin().getUserName();
            }
            if (client != null && client.getDistinguishedName() != null) {
                dn = client.getDistinguishedName();
            }
            logger.debug((Object)("Got home directory for " + dn + " xlogin='" + xlogin + "'" + ": <" + this.homeDirectory + ">"));
        }
        if (this.getSeparator().equals(this.homeDirectory)) {
            throw new ExecutionException("No proper HOME can be determined");
        }
        if (!this.homeDirectory.endsWith(this.getSeparator())) {
            this.homeDirectory = this.homeDirectory + this.getSeparator();
        }
    }

    @Override
    protected String getStorageRoot() throws ExecutionException {
        if (this.homeDirectory == null) {
            try {
                this.setHome();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.homeDirectory;
    }

    @Override
    protected void smsPostActivate() {
        this.homeDirectory = null;
    }
}

