/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.sms;

import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.tsi.TSI;
import java.io.File;
import java.util.Map;

public class FixedStorageImpl
extends SMSBaseImpl {
    @Override
    public void initialise(String name, Map<String, Object> initobjs) throws Exception {
        super.initialise(name, initobjs);
        this.workdir = this.storageDescription.getPathSpec();
        if (this.workdir == null) {
            throw new IllegalArgumentException("Work directory cannot be null.");
        }
        TSI tsi = XNJSFacade.get(this.xnjsReference, this.kernel).getTSI(this.getClient());
        if (tsi != null && tsi.isLocal()) {
            this.workdir = new File(this.workdir).getAbsolutePath();
        }
        if (!this.workdir.endsWith(this.getSeparator())) {
            this.workdir = this.workdir + this.getSeparator();
        }
        if (Boolean.TRUE.equals(initobjs.get(SMSBaseImpl.INIT_DIRECTORY_APPEND_UNIQUE_ID))) {
            this.workdir = this.workdir + this.getUniqueID();
        }
        if (!Boolean.TRUE.equals(initobjs.get(SMSBaseImpl.INIT_SKIP_EXISTENCECHECK))) {
            this.checkWorkdirExists();
        }
    }

    private void checkWorkdirExists() throws ExecutionException {
        TSI tsi = XNJSFacade.get(this.xnjsReference, this.kernel).getTSI(this.getClient());
        XnjsFileWithACL xnjsFile = tsi.getProperties(this.workdir);
        if (xnjsFile == null) {
            throw new ExecutionException("Directory '" + this.workdir + "' does not exist.");
        }
        if (!xnjsFile.isDirectory()) {
            throw new ExecutionException("Path '" + this.workdir + "' is not a directory.");
        }
    }

    @Override
    protected String getStorageRoot() {
        return this.workdir;
    }
}

