/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.sms;

import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.xnjs.io.XnjsStorageInfo;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ExactType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemTypeEnumeration;

public class FileSystemRP
extends ResourceProperty<Object> {
    private static final long serialVersionUID = 1L;
    private final FileSystemDocument[] xdoc;

    public FileSystemRP(ResourceImpl parent, String name) {
        super((Resource)parent);
        FileSystemDocument fs = FileSystemDocument.Factory.newInstance();
        fs.addNewFileSystem().setName(name);
        fs.getFileSystem().setFileSystemType(FileSystemTypeEnumeration.NORMAL);
        this.xdoc = new FileSystemDocument[]{fs};
    }

    public ResourceProperty<Object> update() throws Exception {
        XnjsStorageInfo info;
        FileSystemDocument fs = this.xdoc[0];
        SMSBaseImpl parent = (SMSBaseImpl)this.parentWSResource;
        String description = parent.getStorageAdapter().getFileSystemIdentifier();
        String root = parent.getStorageRoot();
        if (description != null) {
            fs.getFileSystem().setDescription(description);
        }
        if (root != null) {
            fs.getFileSystem().setMountPoint(root);
        }
        if (root == null) {
            root = ".";
        }
        if ((info = parent.getStorageAdapter().getAvailableDiskSpace(root)).getUsableSpace() > -1L) {
            this.getOrCreateDiskSpaceValue(fs).setDoubleValue((double)info.getUsableSpace());
        } else if (info.getFreeSpace() > -1L) {
            this.getOrCreateDiskSpaceValue(fs).setDoubleValue((double)info.getFreeSpace());
        }
        return this;
    }

    private ExactType getOrCreateDiskSpaceValue(FileSystemDocument fs) {
        if (fs.getFileSystem().getDiskSpace() == null) {
            fs.getFileSystem().addNewDiskSpace();
        }
        if (fs.getFileSystem().getDiskSpace().getExactArray().length == 0) {
            fs.getFileSystem().getDiskSpace().addNewExact();
        }
        return fs.getFileSystem().getDiskSpace().getExactArray()[0];
    }

    public FileSystemDocument[] getXml() {
        return this.xdoc;
    }
}

