/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.sms;

import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageInfoProvider;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.io.XnjsStorageInfo;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemDocument;

public class DefaultStorageInfoProvider
implements StorageInfoProvider {
    private final Kernel kernel;

    public DefaultStorageInfoProvider(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public FileSystemDocument getInformation(StorageDescription factoryDesc, Client client, String xnjsRef) {
        FileSystemDocument fs = FileSystemDocument.Factory.newInstance();
        String workdir = factoryDesc.getPathSpec();
        if (workdir != null) {
            TSI tsi = XNJSFacade.get(xnjsRef, this.kernel).getTSI(client);
            XnjsStorageInfo info = tsi.getAvailableDiskSpace(workdir);
            fs.addNewFileSystem().setMountPoint(workdir);
            if (info.getUsableSpace() > -1L) {
                fs.getFileSystem().addNewDiskSpace().addNewExact().setDoubleValue((double)info.getUsableSpace());
            } else if (info.getFreeSpace() > -1L) {
                fs.getFileSystem().addNewDiskSpace().addNewExact().setDoubleValue((double)info.getFreeSpace());
            }
        }
        fs.getFileSystem().setDescription(factoryDesc.getDescription());
        return fs;
    }
}

