/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.rns;

import de.fzj.unicore.uas.impl.rns.RNSNode;
import de.fzj.unicore.uas.impl.rns.RNSNodeWSRFHandler;
import de.fzj.unicore.uas.impl.rns.RNSSupport;
import de.fzj.unicore.uas.impl.rns.VirtualWSResource;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSResource;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.InvalidResourcePropertyQNameFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import eu.unicore.util.Log;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.GDate;
import org.apache.xmlbeans.GDateBuilder;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.GDurationSpecification;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.rl2.DestroyDocument;
import org.oasisOpen.docs.wsrf.rl2.DestroyResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.DeleteResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.DeleteResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.DeleteType;
import org.oasisOpen.docs.wsrf.rp2.GetMultipleResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.GetMultipleResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentDocument1;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.InsertResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.InsertResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.InsertType;
import org.oasisOpen.docs.wsrf.rp2.PutResourcePropertyDocumentDocument1;
import org.oasisOpen.docs.wsrf.rp2.PutResourcePropertyDocumentResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.QueryResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.QueryResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.SetResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.SetResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateType;

public class WSRFMethodMultiplexer
implements WSResource {
    protected static final Logger logger = Log.getLogger((String)"unicore.services", WSResourceImpl.class);
    private RNSNodeWSRFHandler handler;
    private RNSSupport rnsSupport;
    private WSResource parent;

    public DestroyResponseDocument Destroy(DestroyDocument in) throws ResourceNotDestroyedFault, ResourceUnknownFault, ResourceUnavailableFault {
        if (this.requestAimsAtParent()) {
            return this.getParent().Destroy(in);
        }
        RNSNode child = this.getRequestedNode();
        try {
            this.handler.destroy(child);
            DestroyResponseDocument drd = DestroyResponseDocument.Factory.newInstance();
            drd.addNewDestroyResponse();
            return drd;
        }
        catch (Exception e) {
            Log.logException((String)"Error during resource destruction.", (Throwable)e, (Logger)logger);
            throw ResourceNotDestroyedFault.createFault((String)e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SetTerminationTimeResponseDocument SetTerminationTime(SetTerminationTimeDocument in) throws UnableToSetTerminationTimeFault, TerminationTimeChangeRejectedFault, ResourceUnknownFault, ResourceUnavailableFault {
        if (this.requestAimsAtParent()) {
            return this.getParent().SetTerminationTime(in);
        }
        RNSNode child = this.getRequestedNode();
        Calendar c = null;
        if (!in.getSetTerminationTime().isNilRequestedTerminationTime()) {
            c = in.getSetTerminationTime().getRequestedTerminationTime();
            GDuration d = in.getSetTerminationTime().getRequestedLifetimeDuration();
            if (d != null) {
                c = Calendar.getInstance();
                GDateBuilder b = new GDateBuilder(c);
                b.addGDuration((GDurationSpecification)d);
                GDate date = b.toGDate();
                c.setTime(date.getDate());
            }
            if (c == null) throw UnableToSetTerminationTimeFault.createFault((String)"Illegal arguments to SetTerminationTime.");
            this.handler.setTerminationTime(child, c);
        } else {
            this.handler.setTerminationTime(child, null);
        }
        SetTerminationTimeResponseDocument response = SetTerminationTimeResponseDocument.Factory.newInstance();
        response.addNewSetTerminationTimeResponse().setNewTerminationTime(c);
        response.getSetTerminationTimeResponse().setCurrentTime(Calendar.getInstance());
        return response;
    }

    public DeleteResourcePropertiesResponseDocument DeleteResourceProperties(DeleteResourcePropertiesDocument in) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
        if (this.requestAimsAtParent()) {
            return this.getParent().DeleteResourceProperties(in);
        }
        RNSNode child = this.getRequestedNode();
        try {
            DeleteType delete = in.getDeleteResourceProperties().getDelete();
            QName q = delete.getResourceProperty();
            this.handler.deleteResourceProperties(child, q);
        }
        catch (NullPointerException e) {
            throw BaseFault.createFault((String)"Missing arguments", (Throwable)e);
        }
        DeleteResourcePropertiesResponseDocument res = DeleteResourcePropertiesResponseDocument.Factory.newInstance();
        res.addNewDeleteResourcePropertiesResponse();
        return res;
    }

    public PutResourcePropertyDocumentResponseDocument PutResourcePropertyDocument(PutResourcePropertyDocumentDocument1 in) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
        if (this.requestAimsAtParent()) {
            return this.getParent().PutResourcePropertyDocument(in);
        }
        throw BaseFault.createFault((String)"Not implemented.");
    }

    public InsertResourcePropertiesResponseDocument InsertResourceProperties(InsertResourcePropertiesDocument in) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
        if (this.requestAimsAtParent()) {
            return this.getParent().InsertResourceProperties(in);
        }
        RNSNode child = this.getRequestedNode();
        try {
            InsertType insert = in.getInsertResourceProperties().getInsert();
            QName q = WSUtilities.findAnyElementQName((XmlObject)insert);
            XmlObject[] rpChange = WSUtilities.extractAnyElements((XmlObject)insert, (QName)q);
            this.handler.insertResourceProperty(child, rpChange);
            InsertResourcePropertiesResponseDocument res = InsertResourcePropertiesResponseDocument.Factory.newInstance();
            res.addNewInsertResourcePropertiesResponse();
            return res;
        }
        catch (Exception e) {
            throw BaseFault.createFault((String)"Modifications are not valid.", (Throwable)e, (boolean)true);
        }
    }

    public GetResourcePropertyDocumentResponseDocument GetResourcePropertyDocument(GetResourcePropertyDocumentDocument1 in) throws BaseFault, ResourceUnknownFault, ResourceUnavailableFault {
        if (this.requestAimsAtParent()) {
            return this.getParent().GetResourcePropertyDocument(in);
        }
        return this.createResource().GetResourcePropertyDocument(in);
    }

    public UpdateResourcePropertiesResponseDocument UpdateResourceProperties(UpdateResourcePropertiesDocument in) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
        if (this.requestAimsAtParent()) {
            return this.getParent().UpdateResourceProperties(in);
        }
        RNSNode child = this.getRequestedNode();
        try {
            UpdateType update = in.getUpdateResourceProperties().getUpdate();
            QName q = WSUtilities.findAnyElementQName((XmlObject)update);
            if (q == null) {
                throw BaseFault.createFault((String)"Invalid update request, qname is null.");
            }
            XmlObject[] rpChange = WSUtilities.extractAnyElements((XmlObject)update, (QName)q);
            this.handler.updateResourceProperty(child, q, rpChange);
            UpdateResourcePropertiesResponseDocument res = UpdateResourcePropertiesResponseDocument.Factory.newInstance();
            res.addNewUpdateResourcePropertiesResponse();
            return res;
        }
        catch (Exception ime) {
            throw BaseFault.createFault((String)"Modifications are not valid.", (Throwable)ime, (boolean)true);
        }
    }

    public GetResourcePropertyResponseDocument GetResourceProperty(GetResourcePropertyDocument in) throws BaseFault, ResourceUnknownFault, ResourceUnavailableFault, InvalidResourcePropertyQNameFault {
        if (this.requestAimsAtParent()) {
            return this.getParent().GetResourceProperty(in);
        }
        return this.createResource().GetResourceProperty(in);
    }

    public GetMultipleResourcePropertiesResponseDocument GetMultipleResourceProperties(GetMultipleResourcePropertiesDocument in) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
        if (this.requestAimsAtParent()) {
            return this.getParent().GetMultipleResourceProperties(in);
        }
        return this.createResource().GetMultipleResourceProperties(in);
    }

    public QueryResourcePropertiesResponseDocument QueryResourceProperties(QueryResourcePropertiesDocument in) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
        if (this.requestAimsAtParent()) {
            return this.getParent().QueryResourceProperties(in);
        }
        return this.createResource().QueryResourceProperties(in);
    }

    public SetResourcePropertiesResponseDocument SetResourceProperties(SetResourcePropertiesDocument in) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
        if (this.requestAimsAtParent()) {
            return this.getParent().SetResourceProperties(in);
        }
        throw BaseFault.createFault((String)"Not implemented.");
    }

    public RNSNodeWSRFHandler getHandler() {
        return this.handler;
    }

    public void setHandler(RNSNodeWSRFHandler handler) {
        this.handler = handler;
    }

    public RNSSupport getRnsSupport() {
        return this.rnsSupport;
    }

    public void setRnsSupport(RNSSupport rnsSupport) {
        this.rnsSupport = rnsSupport;
    }

    public WSResource getParent() {
        return this.parent;
    }

    public void setParent(WSResource parent) {
        this.parent = parent;
    }

    private RNSNode getRequestedNode() throws ResourceUnknownFault {
        try {
            return this.rnsSupport.getRequestedNode();
        }
        catch (BaseFault e) {
            throw ResourceUnknownFault.createFault();
        }
    }

    private boolean requestAimsAtParent() {
        String path = this.getRnsSupport().getRequestedPath();
        return "/".equals(path);
    }

    private WSResource createResource() throws ResourceUnknownFault, InvalidResourcePropertyQNameFault, BaseFault, ResourceUnavailableFault {
        RNSNode child = this.getRequestedNode();
        QName docName = this.handler.getResourcePropertyDocumentQName();
        VirtualWSResource res = new VirtualWSResource(docName);
        for (QName name : this.handler.getResourcePropertyQNames()) {
            res.setResourceProperty(name, this.handler.getResourceProperty(child, name));
        }
        return res;
    }
}

