/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.rns;

import de.fzj.unicore.uas.impl.rns.RNSNode;
import de.fzj.unicore.uas.impl.rns.RNSNodeWithMetadata;
import de.fzj.unicore.uas.impl.rns.RNSUtils;
import de.fzj.unicore.uas.rns.RNSEntryDoesNotExistFault;
import de.fzj.unicore.uas.rns.RNSEntryExistsFault;
import de.fzj.unicore.uas.rns.WriteNotPermittedFault;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class SimpleRNSNode
extends RNSNodeWithMetadata {
    private static final long serialVersionUID = 1L;
    private SortedMap<String, RNSNode> children = new ConcurrentSkipListMap<String, RNSNode>();

    public SimpleRNSNode(String name) {
        this(name, null);
    }

    public SimpleRNSNode(String name, EndpointReferenceType epr) {
        this(name, epr, new ArrayList<RNSNode>());
    }

    public SimpleRNSNode(String name, EndpointReferenceType epr, RNSNode ... children) {
        this(name, epr, Arrays.asList(children));
    }

    public SimpleRNSNode(String name, EndpointReferenceType epr, Collection<RNSNode> kids) {
        super(name, epr, kids);
    }

    @Override
    public Collection<RNSNode> getChildren() throws BaseFault {
        return this.children.values();
    }

    @Override
    public RNSNode getChild(String name) throws BaseFault {
        RNSNode result = (RNSNode)this.children.get(name);
        if (result == null) {
            throw new RNSEntryDoesNotExistFault(name);
        }
        return result;
    }

    @Override
    public void addChild(RNSNode child) throws BaseFault {
        RNSNode previous = this.children.put(child.getName(), child);
        if (previous != null) {
            this.children.put(previous.getName(), previous);
            throw new RNSEntryExistsFault(child.getName());
        }
    }

    @Override
    public RNSNode removeChild(String name) throws BaseFault, WriteNotPermittedFault {
        RNSNode result = (RNSNode)this.children.remove(name);
        if (result == null) {
            throw new RNSEntryDoesNotExistFault(name);
        }
        return result;
    }

    @Override
    public RNSNode createDir(String name, boolean supportsRNS) throws BaseFault {
        EndpointReferenceType childEpr;
        try {
            childEpr = RNSUtils.getChildEPR(this.getEPR(), name);
        }
        catch (Exception e) {
            LogUtil.logException((String)("Could not create child dir: " + e.getMessage()), (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)("Could not create child dir: " + e.getMessage()));
        }
        SimpleRNSNode result = new SimpleRNSNode(name, childEpr);
        this.addChild(result);
        return result;
    }

    @Override
    public RNSNode createFile(String name) throws BaseFault {
        throw new WriteNotPermittedFault(name);
    }
}

