/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.rns;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.uas.impl.rns.RNSNode;
import de.fzj.unicore.uas.impl.rns.RNSNodeWithMetadata;
import de.fzj.unicore.uas.impl.rns.XMLToNodeConverter;
import de.fzj.unicore.uas.rns.RNSEntryDoesNotExistFault;
import de.fzj.unicore.uas.rns.RNSEntryExistsFault;
import de.fzj.unicore.uas.rns.WriteNotPermittedFault;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RPBasedRNSNode
extends RNSNodeWithMetadata {
    private static final long serialVersionUID = 1L;
    private QName targetProperty;
    private String targetServiceName;
    private String targetServiceUUID;
    private XMLToNodeConverter converter;
    private transient Kernel kernel;

    public RPBasedRNSNode(Kernel kernel, String name, EndpointReferenceType epr, QName targetProperty, String targetServiceName, String targetServiceUUID, XMLToNodeConverter converter) {
        super(name, epr);
        this.targetProperty = targetProperty;
        this.targetServiceName = targetServiceName;
        this.targetServiceUUID = targetServiceUUID;
        this.converter = converter;
    }

    protected ResourceProperty<?> getTargetResourceProperty() throws ResourceUnknownException, PersistenceException {
        Home h = this.kernel.getHome(this.targetServiceName);
        WSResourceImpl inst = (WSResourceImpl)h.get(this.targetServiceUUID);
        ResourceProperty rp = inst.getResourceProperty(this.targetProperty);
        return rp;
    }

    @Override
    public Collection<RNSNode> getChildren() {
        try {
            XmlObject[] xmls = this.getTargetResourceProperty().getXml();
            return Arrays.asList(this.converter.convert(xmls));
        }
        catch (Exception ex) {
            LogUtil.logException((String)"Error creating RNS child list", (Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public RNSNode getChild(String name) {
        if (name == null) {
            return null;
        }
        for (RNSNode n : this.getChildren()) {
            if (!name.equals(n.getName())) continue;
            return n;
        }
        return null;
    }

    @Override
    public void addChild(RNSNode child) throws WriteNotPermittedFault {
        throw new WriteNotPermittedFault(child.getName());
    }

    @Override
    public RNSNode removeChild(String name) throws RNSEntryDoesNotExistFault, WriteNotPermittedFault {
        throw new WriteNotPermittedFault(name);
    }

    @Override
    public RNSNode createDir(String name, boolean supportsRNS) throws WriteNotPermittedFault, RNSEntryExistsFault {
        throw new WriteNotPermittedFault(name);
    }

    @Override
    public RNSNode createFile(String name) throws WriteNotPermittedFault, RNSEntryExistsFault {
        throw new WriteNotPermittedFault(name);
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }
}

