/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.rns;

import de.fzj.unicore.uas.impl.rns.RNSNode;
import de.fzj.unicore.uas.impl.rns.RNSOperationResult;
import de.fzj.unicore.uas.impl.rns.SimpleRNSNode;
import de.fzj.unicore.uas.rns.RNSPortType;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.util.Pair;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.xfire.transport.http.XFireServletController;
import org.ggf.rns.AddRequestDocument;
import org.ggf.rns.AddRequestType;
import org.ggf.rns.AddResponseDocument;
import org.ggf.rns.AddResponseType;
import org.ggf.rns.LookupRequestDocument;
import org.ggf.rns.LookupRequestType;
import org.ggf.rns.LookupResponseDocument;
import org.ggf.rns.LookupResponseType;
import org.ggf.rns.MetadataMappingType;
import org.ggf.rns.NameMappingType;
import org.ggf.rns.RNSEntryResponseType;
import org.ggf.rns.RNSEntryType;
import org.ggf.rns.RNSMetadataType;
import org.ggf.rns.RNSSupportType;
import org.ggf.rns.RemoveRequestDocument;
import org.ggf.rns.RemoveRequestType;
import org.ggf.rns.RemoveResponseDocument;
import org.ggf.rns.RemoveResponseType;
import org.ggf.rns.RenameRequestDocument;
import org.ggf.rns.RenameRequestType;
import org.ggf.rns.RenameResponseDocument;
import org.ggf.rns.RenameResponseType;
import org.ggf.rns.SetMetadataRequestDocument;
import org.ggf.rns.SetMetadataRequestType;
import org.ggf.rns.SetMetadataResponseDocument;
import org.ggf.rns.SetMetadataResponseType;

public class RNSSupport
implements RNSPortType,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = LogUtil.getLogger((String)"unicore.services", RNSSupport.class);
    private static final Pattern pathPattern = Pattern.compile(".*&path=([^=]+).*");
    private RNSNode rootNode;

    public RNSSupport(RNSNode rootNode) {
        this.rootNode = rootNode;
    }

    public AddResponseDocument add(AddRequestDocument addRequest) throws BaseFault {
        RNSEntryType[] entries;
        AddResponseDocument result = AddResponseDocument.Factory.newInstance();
        AddRequestType request = addRequest.getAddRequest();
        if (request == null) {
            logger.warn((Object)("Received empty request: " + addRequest));
            return result;
        }
        AddResponseType response = result.addNewAddResponse();
        ArrayList<SimpleRNSNode> toAdd = new ArrayList<SimpleRNSNode>();
        for (RNSEntryType entry : entries = request.getEntryArray()) {
            SimpleRNSNode node = new SimpleRNSNode(entry.getEntryName(), entry.getEndpoint());
            RNSMetadataType metaDataType = entry.getMetadata();
            XmlObject[] metaData = metaDataType == null ? null : WSUtilities.extractAllChildren((XmlObject)entry.getMetadata());
            node.setMetadata(metaData);
            boolean supportsRNS = metaDataType == null ? true : RNSSupportType.TRUE.equals(metaDataType.getSupportsRns().getValue());
            node.setSupportsRNS(supportsRNS);
            toAdd.add(node);
        }
        RNSNode targetNode = this.getRequestedNode();
        RNSOperationResult internalResult = targetNode.add(toAdd.toArray(new RNSNode[toAdd.size()]));
        for (int i = 0; i < internalResult.getSize(); ++i) {
            RNSEntryType entry;
            entry = response.addNewEntryResponse();
            this.fillEntry((RNSEntryResponseType)entry, internalResult, i);
        }
        return result;
    }

    public LookupResponseDocument lookup(LookupRequestDocument lookupRequest) throws BaseFault {
        LookupResponseDocument result = LookupResponseDocument.Factory.newInstance();
        LookupRequestType request = lookupRequest.getLookupRequest();
        if (request == null) {
            logger.warn((Object)("Received empty request: " + lookupRequest));
            return result;
        }
        LookupResponseType response = result.addNewLookupResponse();
        RNSNode targetNode = this.getRequestedNode();
        RNSOperationResult internalResult = targetNode.lookup(request.getEntryNameArray());
        for (int i = 0; i < internalResult.getSize(); ++i) {
            RNSEntryResponseType entry = response.addNewEntryResponse();
            this.fillEntry(entry, internalResult, i);
        }
        return result;
    }

    public RenameResponseDocument rename(RenameRequestDocument renameRequest) throws BaseFault {
        NameMappingType[] entries;
        RenameResponseDocument result = RenameResponseDocument.Factory.newInstance();
        RenameRequestType request = renameRequest.getRenameRequest();
        if (request == null) {
            logger.warn((Object)("Received empty request: " + renameRequest));
            return result;
        }
        RenameResponseType response = result.addNewRenameResponse();
        ArrayList<Pair> toRename = new ArrayList<Pair>();
        for (NameMappingType entry : entries = request.getRenameRequestArray()) {
            toRename.add(new Pair((Object)entry.getSourceName(), (Object)entry.getTargetName()));
        }
        RNSNode targetNode = this.getRequestedNode();
        RNSOperationResult internalResult = targetNode.rename(toRename.toArray(new Pair[toRename.size()]));
        for (int i = 0; i < internalResult.getSize(); ++i) {
            NameMappingType entry;
            entry = response.addNewEntryResponse();
            this.fillEntry((RNSEntryResponseType)entry, internalResult, i);
        }
        return result;
    }

    public RemoveResponseDocument remove(RemoveRequestDocument removeRequest) throws BaseFault {
        String[] entries;
        RemoveResponseDocument result = RemoveResponseDocument.Factory.newInstance();
        RemoveRequestType request = removeRequest.getRemoveRequest();
        if (request == null) {
            logger.warn((Object)("Received empty request: " + removeRequest));
            return result;
        }
        RemoveResponseType response = result.addNewRemoveResponse();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String entry : entries = request.getEntryNameArray()) {
            toRemove.add(entry);
        }
        RNSNode targetNode = this.getRequestedNode();
        RNSOperationResult internalResult = targetNode.remove(toRemove.toArray(new String[toRemove.size()]));
        for (int i = 0; i < internalResult.getSize(); ++i) {
            String entry;
            entry = response.addNewEntryResponse();
            this.fillEntry((RNSEntryResponseType)entry, internalResult, i);
        }
        return result;
    }

    public SetMetadataResponseDocument setMetadata(SetMetadataRequestDocument setMetadataRequest) throws BaseFault {
        MetadataMappingType[] entries;
        SetMetadataResponseDocument result = SetMetadataResponseDocument.Factory.newInstance();
        SetMetadataRequestType request = setMetadataRequest.getSetMetadataRequest();
        if (request == null) {
            logger.warn((Object)("Received empty request: " + setMetadataRequest));
            return result;
        }
        SetMetadataResponseType response = result.addNewSetMetadataResponse();
        ArrayList<Pair> toSetMetadata = new ArrayList<Pair>();
        for (MetadataMappingType entry : entries = request.getSetMetadataRequestArray()) {
            RNSMetadataType setTo = RNSMetadataType.Factory.newInstance();
            setTo.setSupportsRns(entry.getSupportsRns());
            XmlObject[] metadata = WSUtilities.extractAllChildren((XmlObject)entry);
            WSUtilities.append((XmlObject[])metadata, (XmlObject)setTo);
            Pair pair = new Pair((Object)entry.getEntryName(), (Object)setTo);
            toSetMetadata.add(pair);
        }
        RNSNode targetNode = this.getRequestedNode();
        RNSOperationResult internalResult = targetNode.setChildrenMetadata(toSetMetadata.toArray(new Pair[toSetMetadata.size()]));
        for (int i = 0; i < internalResult.getSize(); ++i) {
            MetadataMappingType entry;
            entry = response.addNewEntryResponse();
            this.fillEntry((RNSEntryResponseType)entry, internalResult, i);
        }
        return result;
    }

    protected void fillEntry(RNSEntryResponseType entry, RNSOperationResult internalResult, int i) {
        if (internalResult.wasSuccessful(i)) {
            entry.setEndpoint(internalResult.getEPR(i));
            entry.setEntryName(internalResult.getName(i));
            entry.setMetadata(internalResult.getMetadata(i));
        } else {
            entry.setFault(internalResult.getFault(i).getFaultInfo());
        }
    }

    protected RNSNode getRequestedNode() throws BaseFault {
        String path = this.getRequestedPath();
        if (path.trim().length() > 0 && !"/".equals(path)) {
            return this.getRootNode().getChildForPath(path);
        }
        return this.getRootNode();
    }

    public String getRequestedPath() {
        HttpServletRequest request = XFireServletController.getRequest();
        String query = request.getQueryString();
        Matcher m = pathPattern.matcher(query);
        if (m.matches()) {
            String result = m.group(1);
            if ((result = FilenameUtils.normalizeNoEndSeparator((String)result, (boolean)true)) == null || result.trim().length() == 0 || result.matches("/")) {
                return "/";
            }
            return result;
        }
        return "/";
    }

    public RNSNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(RNSNode rootNode) {
        this.rootNode = rootNode;
    }
}

