/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.rns;

import de.fzj.unicore.uas.impl.rns.RNSNode;
import de.fzj.unicore.uas.impl.rns.SimpleRNSNode;
import de.fzj.unicore.uas.impl.rns.XMLToNodeConverter;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlObject;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class EPRToNodeConverter
implements XMLToNodeConverter {
    private static final long serialVersionUID = 1L;

    @Override
    public RNSNode[] convert(XmlObject[] xml) {
        String fallBackName = this.getFallBackName();
        int count = 1;
        ArrayList<SimpleRNSNode> result = new ArrayList<SimpleRNSNode>();
        for (XmlObject o : xml) {
            if (!(o instanceof EndpointReferenceDocument)) continue;
            EndpointReferenceType epr = ((EndpointReferenceDocument)o).getEndpointReference();
            String friendlyName = WSUtilities.extractFriendlyNameFromEPR((EndpointReferenceType)epr);
            if (friendlyName == null) {
                friendlyName = fallBackName + count++;
            }
            SimpleRNSNode node = new SimpleRNSNode(friendlyName, epr);
            result.add(node);
        }
        return result.toArray(new RNSNode[result.size()]);
    }

    protected abstract String getFallBackName();
}

