/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.rns;

import de.fzj.unicore.uas.impl.rns.RNSNode;
import de.fzj.unicore.uas.impl.rns.RNSOperationResult;
import de.fzj.unicore.uas.rns.RNSEntryDoesNotExistFault;
import de.fzj.unicore.uas.rns.RNSEntryExistsFault;
import de.fzj.unicore.uas.rns.WriteNotPermittedFault;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.util.Pair;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.rns.RNSMetadataType;
import org.ggf.rns.RNSSupportType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class BasicRNSNode
implements RNSNode {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = LogUtil.getLogger((String)"unicore.services", RNSNode.class);
    private String name;
    EndpointReferenceType epr;

    public BasicRNSNode(String name) {
        this(name, null);
    }

    public BasicRNSNode(String name, EndpointReferenceType epr) {
        this(name, epr, new ArrayList<RNSNode>());
    }

    public BasicRNSNode(String name, EndpointReferenceType epr, RNSNode ... children) {
        this(name, epr, Arrays.asList(children));
    }

    public BasicRNSNode(String name, EndpointReferenceType epr, Collection<RNSNode> kids) {
        this.name = name;
        this.epr = epr;
        for (RNSNode child : kids) {
            try {
                this.addChild(child);
            }
            catch (RNSEntryExistsFault e) {
                logger.error((Object)("Tried to initialize an RNS node with multiple children with the same name.. the conflicting name is " + child.getName()), (Throwable)e);
            }
            catch (WriteNotPermittedFault e) {
                logger.error((Object)"Thrown WriteNotPermittedFault while initializing BasicRNSNode...", (Throwable)e);
            }
            catch (BaseFault e) {
                logger.error((Object)"Thrown BaseFault while initializing BasicRNSNode...", (Throwable)e);
            }
        }
    }

    @Override
    public EndpointReferenceType getEPR() {
        return this.epr;
    }

    public void setEPR(EndpointReferenceType epr) {
        this.epr = epr;
    }

    @Override
    public RNSOperationResult add(RNSNode ... newChildren) {
        RNSOperationResult result = new RNSOperationResult();
        for (RNSNode node : newChildren) {
            if (node.getName() == null) {
                result.addFault(BaseFault.createFault((String)"Invalid request: asked to add an RNS Entry that's missing a name!"));
                continue;
            }
            if (node.getEPR() == null) {
                try {
                    node = this.createDir(node.getName(), node.getSupportsRNS());
                    result.addSuccess();
                    result.addEPR(node.getEPR());
                    result.addMetadata(node.getMetadataType());
                    result.addName(node.getName());
                }
                catch (BaseFault e) {
                    result.addFault(e);
                }
                continue;
            }
            try {
                this.addChild(node);
                result.addSuccess();
                result.addEPR(node.getEPR());
                result.addMetadata(node.getMetadataType());
                result.addName(node.getName());
            }
            catch (BaseFault e) {
                result.addFault(e);
            }
        }
        return result;
    }

    @Override
    public RNSOperationResult lookup(String ... names) throws BaseFault {
        RNSOperationResult result = new RNSOperationResult();
        if (names == null || names.length == 0) {
            for (RNSNode child : this.getChildren()) {
                if (child == null) continue;
                result.addName(child.getName());
                result.addEPR(child.getEPR());
                result.addMetadata(child.getMetadataType());
                result.addSuccess();
            }
        } else {
            for (String name : names) {
                try {
                    RNSNode child = this.getChild(name);
                    result.addName(name);
                    result.addEPR(child.getEPR());
                    result.addMetadata(child.getMetadataType());
                    result.addSuccess();
                }
                catch (RNSEntryDoesNotExistFault e) {
                    result.addFault((BaseFault)((Object)e));
                }
            }
        }
        return result;
    }

    @Override
    public RNSOperationResult rename(Pair<String, String> ... namePairs) {
        RNSOperationResult result = new RNSOperationResult();
        for (Pair<String, String> pair : namePairs) {
            String oldName = (String)pair.getM1();
            String newName = (String)pair.getM2();
            if (oldName == null) {
                result.addFault(BaseFault.createFault((String)"Invalid request: asked to rename an RNS Entry without specifying its old name"));
                continue;
            }
            if (newName == null) {
                result.addFault(BaseFault.createFault((String)"Invalid request: asked to rename an RNS Entry without specifying its new name"));
                continue;
            }
            try {
                RNSNode node = this.getChild(oldName);
                node.setName(newName);
                this.addChild(node);
                try {
                    this.remove(oldName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                result.addSuccess();
                result.addEPR(node.getEPR());
                result.addMetadata(node.getMetadataType());
                result.addName(node.getName());
            }
            catch (BaseFault e) {
                result.addFault(e);
            }
        }
        return result;
    }

    @Override
    public RNSOperationResult setChildrenMetadata(Pair<String, RNSMetadataType> ... metadata) {
        RNSOperationResult result = new RNSOperationResult();
        for (Pair<String, RNSMetadataType> pair : metadata) {
            String name = (String)pair.getM1();
            RNSMetadataType data = (RNSMetadataType)pair.getM2();
            if (name == null) {
                result.addFault(BaseFault.createFault((String)"Invalid request: asked to set an RNS Entry's metadata without specifying its name"));
                continue;
            }
            try {
                RNSNode node = this.getChild(name);
                node.setSupportsRNS(RNSSupportType.TRUE.equals(data.getSupportsRns().getValue()));
                XmlObject[] xml = WSUtilities.extractAllChildren((XmlObject)data);
                node.setMetadata(xml);
                result.addSuccess();
                result.addEPR(node.getEPR());
                result.addMetadata(node.getMetadataType());
                result.addName(node.getName());
            }
            catch (BaseFault e) {
                result.addFault(e);
            }
        }
        return result;
    }

    @Override
    public RNSOperationResult remove(String ... names) {
        RNSOperationResult result = new RNSOperationResult();
        for (String name : names) {
            if (name == null) {
                result.addFault(BaseFault.createFault((String)"Invalid request: asked to remove an RNS Entry without specifying its name"));
                continue;
            }
            try {
                RNSNode node = this.removeChild(name);
                result.addSuccess();
                result.addEPR(node.getEPR());
                result.addMetadata(node.getMetadataType());
                result.addName(node.getName());
            }
            catch (BaseFault e) {
                result.addFault(e);
            }
        }
        return result;
    }

    @Override
    public RNSNode getChildForPath(String path) throws BaseFault {
        if ((path = BasicRNSNode.normalizePath(path)).length() == 0) {
            return this;
        }
        int index = path.indexOf("/");
        if (index < 0) {
            return this.getChild(path);
        }
        String childName = path.substring(0, index);
        path = path.substring(index + 1);
        RNSNode child = this.getChild(childName);
        return child.getChildForPath(path);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(RNSNode o) {
        return this.getName().compareTo(o.getName());
    }

    protected static String normalizePath(String path) {
        if (path == null) {
            return "";
        }
        String result = FilenameUtils.normalizeNoEndSeparator((String)(path = path.trim()), (boolean)true);
        if (result == null) {
            return "";
        }
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }
}

