/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.reservation;

import de.fzj.unicore.uas.ReservationManagement;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.reservation.ReservationStatusDescriptionResourceProperty;
import de.fzj.unicore.uas.impl.reservation.ReservationStatusResourceProperty;
import de.fzj.unicore.uas.impl.reservation.StartTimeResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.messaging.ResourceDeletedMessage;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.tsi.IReservation;
import de.fzj.unicore.xnjs.tsi.ReservationStatus;
import eu.unicore.security.Client;
import eu.unicore.security.Xlogin;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.unigrids.x2006.x04.services.jms.TargetSystemReferenceDocument;
import org.unigrids.x2006.x04.services.reservation.ReservationPropertiesDocument;
import org.unigrids.x2006.x04.services.reservation.ReservationReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ReservationManagementImpl
extends UASWSResourceImpl
implements ReservationManagement {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", ReservationManagementImpl.class);
    public static String INITPARAM_RESOURCES = "resources";
    public static String INITPARAM_STARTTIME = "starttime";
    public static String INITPARAM_TSS_REFERENCE = "tss_reference";
    @Persist
    private String reservationReference;
    @Persist
    private String tssID;
    @Persist
    private Xlogin xlogin;
    long lastUpdate = 0L;
    final long updateInterval = 3000L;
    transient ReservationStatus reservationStatus;

    @Override
    public QName getResourcePropertyDocumentQName() {
        return ReservationPropertiesDocument.type.getDocumentElementName();
    }

    @Override
    public void initialise(String serviceName, Map<String, Object> initParams) throws Exception {
        Calendar startTime = (Calendar)initParams.get(INITPARAM_STARTTIME);
        ResourcesDocument resources = (ResourcesDocument)initParams.get(INITPARAM_RESOURCES);
        this.setServiceName(serviceName);
        Calendar lifetime = Calendar.getInstance();
        lifetime.setTime(startTime.getTime());
        lifetime.add(13, this.getDefaultLifetime());
        initParams.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", lifetime);
        super.initialise(serviceName, initParams);
        IReservation reservation = XNJSFacade.get(this.xnjsReference, this.kernel).getReservation();
        if (reservation == null) {
            throw new Exception("Reservation not supported.");
        }
        this.reservationReference = reservation.makeReservation((XmlObject)resources, startTime, this.getClient());
        ReservationReferenceDocument res = ReservationReferenceDocument.Factory.newInstance();
        res.setReservationReference(this.reservationReference);
        this.properties.put(RPReservationReference, new ImmutableResourceProperty((XmlObject)res));
        this.properties.put(RPStartTime, new StartTimeResourceProperty(startTime, this));
        this.properties.put(RPReservationStatus, new ReservationStatusResourceProperty(this));
        this.properties.put(RPReservationStatusDescription, new ReservationStatusDescriptionResourceProperty(this));
        this.properties.put(RPResources, new ImmutableResourceProperty((XmlObject)resources));
        this.xlogin = this.getClient() != null ? this.getClient().getXlogin() : null;
        TargetSystemReferenceDocument tssRef = TargetSystemReferenceDocument.Factory.newInstance();
        EndpointReferenceType tssEPR = (EndpointReferenceType)initParams.get(INITPARAM_TSS_REFERENCE);
        tssRef.setTargetSystemReference(tssEPR);
        this.tssID = WSServerUtilities.extractResourceID((EndpointReferenceType)tssEPR);
        this.properties.put(RPTargetSystemReference, new ImmutableResourceProperty((XmlObject)tssRef));
    }

    public void destroy() {
        try {
            ResourceDeletedMessage m = new ResourceDeletedMessage((Serializable)((Object)("deleted:" + this.getUniqueID())));
            m.setServiceName(this.getServiceName());
            m.setDeletedResource(this.getUniqueID());
            this.kernel.getMessaging().getChannel(this.tssID).publish((Message)m);
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not send internal message.", (Throwable)e, (Logger)logger);
        }
        try {
            Client client = this.getClient();
            if (Client.Type.LOCAL == client.getType() || Client.Type.ANONYMOUS == client.getType()) {
                client.setXlogin(this.xlogin);
                logger.info((Object)("Cancelling reservation " + this.reservationReference + " using xlogin " + this.xlogin));
            }
            XNJSFacade.get(this.xnjsReference, this.kernel).getReservation().cancelReservation(this.reservationReference, this.getClient());
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not cancel resource reservation.", (Throwable)e, (Logger)logger);
        }
        super.destroy();
    }

    public void setTSSID(String tssID) {
        this.tssID = tssID;
    }

    public synchronized ReservationStatus getReservationStatus() throws ExecutionException {
        if (this.reservationStatus == null || System.currentTimeMillis() > this.lastUpdate + 3000L) {
            this.reservationStatus = XNJSFacade.get(this.xnjsReference, this.kernel).getReservation().queryReservation(this.reservationReference, this.getClient());
            this.lastUpdate = System.currentTimeMillis();
        }
        return this.reservationStatus;
    }
}

