/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.job;

import de.fzj.unicore.uas.impl.job.JobManagementImpl;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.xnjs.ems.Action;
import eu.unicore.security.Client;
import java.math.BigInteger;
import org.unigrids.services.atomic.types.StatusInfoDocument;
import org.unigrids.services.atomic.types.StatusType;

public class StatusInfoResourceProperty
extends ResourceProperty<Object> {
    private static final long serialVersionUID = 1L;
    private final StatusInfoDocument status = StatusInfoDocument.Factory.newInstance();
    private StatusInfoDocument[] xdoc;
    private final String actionId;
    private final String xnjsReference;

    public StatusInfoResourceProperty(String jobID, JobManagementImpl parent, String xnjsReference) {
        super((Resource)parent);
        this.status.addNewStatusInfo();
        this.xdoc = new StatusInfoDocument[]{this.status};
        this.actionId = jobID;
        this.xnjsReference = xnjsReference;
    }

    public StatusInfoDocument[] getXml() {
        return this.xdoc;
    }

    public StatusInfoResourceProperty update() throws Exception {
        Action a;
        Float progress;
        Kernel k = this.parentWSResource.getKernel();
        Client client = ((JobManagementImpl)this.parentWSResource).getClient();
        XNJSFacade xnjs = XNJSFacade.get(this.xnjsReference, k);
        this.status.getStatusInfo().setStatus(this.convertStatus(xnjs.getStatus(this.actionId, client)));
        this.status.getStatusInfo().setDescription("");
        Integer exitCode = xnjs.getExitCode(this.actionId, client);
        if (exitCode != null) {
            this.status.getStatusInfo().setExitCode(BigInteger.valueOf(exitCode.longValue()));
        }
        if ((progress = xnjs.getProgress(this.actionId, client)) != null) {
            this.status.getStatusInfo().setProgress(progress.floatValue());
        }
        if (!(a = xnjs.getAction(this.actionId)).getResult().isSuccessful()) {
            String errorMessage = a.getResult().getErrorMessage();
            if (errorMessage == null) {
                errorMessage = "";
            }
            this.status.getStatusInfo().setDescription(errorMessage);
        }
        return this;
    }

    protected StatusType.Enum convertStatus(Integer emsStatus) {
        int i = emsStatus;
        switch (i) {
            case 1: {
                return StatusType.STAGINGIN;
            }
            case 6: {
                return StatusType.STAGINGOUT;
            }
            case 5: {
                return StatusType.RUNNING;
            }
            case 21: {
                return StatusType.QUEUED;
            }
            case 22: {
                return StatusType.QUEUED;
            }
            case 2: {
                return StatusType.READY;
            }
            case 7: {
                Kernel k = this.parentWSResource.getKernel();
                if (XNJSFacade.get(this.xnjsReference, k).getAction(this.actionId).getResult().isSuccessful()) {
                    return StatusType.SUCCESSFUL;
                }
                return StatusType.FAILED;
            }
        }
        return StatusType.UNDEFINED;
    }
}

