/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.job;

import de.fzj.unicore.uas.JobManagement;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.TargetSystem;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.faults.JobNotStartedFault;
import de.fzj.unicore.uas.impl.PersistingPreferencesResource;
import de.fzj.unicore.uas.impl.bp.BPSupportImpl;
import de.fzj.unicore.uas.impl.job.ExecutionJSDLResourceProperty;
import de.fzj.unicore.uas.impl.job.LogResourceProperty;
import de.fzj.unicore.uas.impl.job.StatusInfoResourceProperty;
import de.fzj.unicore.uas.impl.job.StdErrProperty;
import de.fzj.unicore.uas.impl.job.StdOutProperty;
import de.fzj.unicore.uas.impl.job.TSSReferenceResourceProperty;
import de.fzj.unicore.uas.impl.job.WorkingDirResourceProperty;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageManagementHomeImpl;
import de.fzj.unicore.uas.impl.tss.rp.StorageReferenceResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.messaging.ResourceDeletedMessage;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.security.IContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.xnjs.ems.Action;
import eu.unicore.security.Client;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.unigrids.services.atomic.types.StorageReferenceType;
import org.unigrids.services.atomic.types.StorageTypeEnumeration;
import org.unigrids.x2006.x04.services.jms.AbortDocument;
import org.unigrids.x2006.x04.services.jms.AbortResponseDocument;
import org.unigrids.x2006.x04.services.jms.HoldDocument;
import org.unigrids.x2006.x04.services.jms.HoldResponseDocument;
import org.unigrids.x2006.x04.services.jms.JobPropertiesDocument;
import org.unigrids.x2006.x04.services.jms.OriginalJSDLDocument;
import org.unigrids.x2006.x04.services.jms.ResumeDocument;
import org.unigrids.x2006.x04.services.jms.ResumeResponseDocument;
import org.unigrids.x2006.x04.services.jms.StartDocument;
import org.unigrids.x2006.x04.services.jms.StartResponseDocument;
import org.unigrids.x2006.x04.services.jms.SubmissionTimeDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class JobManagementImpl
extends PersistingPreferencesResource
implements JobManagement {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", JobManagementImpl.class);
    public static final String INITPARAM_ACTION = "uas.jobmanagement.action";
    public static final String INITPARAM_ACTION_AUTOSTART = "uas.jobmanagement.action.autostart";
    public static final String INITPARAM_ACTION_NO_XNJS_SUBMIT = "uas.jobmanagement.action.no_xnjs_submit";
    public static final String INITPARAM_TSS_UNIQUEID = "uas.jobmanagement.TSS";
    public static final String INITPARAM_STORAGE_REFERENCE = "uas.jobmanagement.SMS";
    public static final String JMS_NS = "http://unigrids.org/2006/04/services/jms";
    public static final QName STDOUT = new QName("http://unigrids.org/2006/04/services/jms", "StdOut");
    public static final QName STDERR = new QName("http://unigrids.org/2006/04/services/jms", "StdErr");
    @Persist
    private String tssId;

    @Override
    protected void addWSResourceInterfaces(BPSupportImpl baseProfile) {
        super.addWSResourceInterfaces(baseProfile);
        baseProfile.addWSResourceInterface(JMS_PORT);
    }

    public QName getPortType() {
        return JMS_PORT;
    }

    @Override
    public QName getResourcePropertyDocumentQName() {
        return JobPropertiesDocument.type.getDocumentElementName();
    }

    public StartResponseDocument Start(StartDocument in) throws JobNotStartedFault {
        StartResponseDocument res = StartResponseDocument.Factory.newInstance();
        try {
            XNJSFacade.get(this.xnjsReference, this.kernel).getManager().run(this.getUniqueID(), AuthZAttributeStore.getClient());
            res.addNewStartResponse();
            logger.info((Object)("Started " + this.getUniqueID()));
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)("Could not start job " + this.getUniqueID()), (Throwable)e, (Logger)logger);
            throw JobNotStartedFault.createFault((String)e.getMessage());
        }
    }

    public AbortResponseDocument Abort(AbortDocument in) throws BaseFault {
        AbortResponseDocument res = AbortResponseDocument.Factory.newInstance();
        try {
            XNJSFacade.get(this.xnjsReference, this.kernel).getManager().abort(this.getUniqueID(), AuthZAttributeStore.getClient());
            res.addNewAbortResponse();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not abort the job.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)"Could not abort the job.", (Throwable)e);
        }
    }

    public HoldResponseDocument Hold(HoldDocument in) throws BaseFault {
        HoldResponseDocument res = HoldResponseDocument.Factory.newInstance();
        try {
            XNJSFacade.get(this.xnjsReference, this.kernel).getManager().pause(this.getUniqueID(), AuthZAttributeStore.getClient());
            res.addNewHoldResponse();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not hold the job.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)"Could not hold the job.", (Throwable)e);
        }
    }

    public ResumeResponseDocument Resume(ResumeDocument in) throws BaseFault {
        ResumeResponseDocument res = ResumeResponseDocument.Factory.newInstance();
        try {
            XNJSFacade.get(this.xnjsReference, this.kernel).getManager().resume(this.getUniqueID(), AuthZAttributeStore.getClient());
            res.addNewResumeResponse();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not resume the job.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)"Could not resume the job", (Throwable)e);
        }
    }

    @Override
    public void initialise(String serviceName, Map<String, Object> initParams) throws Exception {
        Boolean noXNJSSubmit;
        Action action = (Action)initParams.get(INITPARAM_ACTION);
        initParams.put(INIT_UNIQUE_ID, action.getUUID());
        super.initialise(serviceName, initParams);
        this.tssId = (String)initParams.get(INITPARAM_TSS_UNIQUEID);
        if (Boolean.TRUE.equals(initParams.get(INITPARAM_ACTION_AUTOSTART))) {
            action.getProcessingContext().put((Object)"EMS_AUTOSUBMIT", (Object)"true");
        }
        if (!Boolean.TRUE.equals(noXNJSSubmit = (Boolean)initParams.get(INITPARAM_ACTION_NO_XNJS_SUBMIT))) {
            Client client = AuthZAttributeStore.getClient();
            XNJSFacade.get(this.xnjsReference, this.kernel).getManager().add(action, client);
            logger.info((Object)("Submitted job with id " + action.getUUID() + " for client " + client));
        }
        SubmissionTimeDocument std = SubmissionTimeDocument.Factory.newInstance();
        std.setSubmissionTime(Calendar.getInstance());
        this.properties.put(RPSubmissionTime, new ImmutableResourceProperty((XmlObject)std));
        StatusInfoResourceProperty info = new StatusInfoResourceProperty(this.getUniqueID(), this, this.xnjsReference);
        this.properties.put(RPStatusInfo, info);
        this.properties.put(RPTargetSystemReference, this.createTSSReferenceProperty());
        OriginalJSDLDocument ojd = OriginalJSDLDocument.Factory.newInstance();
        ojd.setOriginalJSDL(((JobDefinitionDocument)action.getAjd()).getJobDefinition());
        ImmutableResourceProperty oJsdl = new ImmutableResourceProperty((XmlObject)ojd);
        this.properties.put(RPOriginalJSDL, oJsdl);
        LogResourceProperty log = new LogResourceProperty((Resource)this, this.getUniqueID(), this.xnjsReference);
        this.properties.put(RPLog, log);
        ExecutionJSDLResourceProperty eJSDL = new ExecutionJSDLResourceProperty((Resource)this, this.getUniqueID(), this.xnjsReference);
        this.properties.put(RPExecutionJSDL, eJSDL);
        EndpointReferenceType uspace = this.createUspace(action);
        WorkingDirResourceProperty workDir = new WorkingDirResourceProperty(uspace);
        this.properties.put(RPWorkingDir, workDir);
        EndpointReferenceType[] smsEprs = (EndpointReferenceType[])initParams.get(INITPARAM_STORAGE_REFERENCE);
        if (smsEprs != null) {
            StorageReferenceResourceProperty sp = new StorageReferenceResourceProperty(smsEprs);
            this.properties.put(RPStorageReference, sp);
        }
        this.properties.put(STDOUT, new StdOutProperty((Resource)this, action.getUUID(), this.xnjsReference));
        this.properties.put(STDERR, new StdErrProperty((Resource)this, action.getUUID(), this.xnjsReference));
        this.setDirty();
        if (Boolean.TRUE.equals(initParams.get(INITPARAM_PUBLISH_TO_REGISTRY))) {
            this.publish();
        }
    }

    public void destroy() {
        try {
            ResourceDeletedMessage m = new ResourceDeletedMessage((Serializable)((Object)("deleted:" + this.getUniqueID())));
            m.setServiceName(this.getServiceName());
            m.setDeletedResource(this.getUniqueID());
            this.getKernel().getMessaging().getChannel(this.tssId).publish((Message)m);
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not send internal message.", (Throwable)e, (Logger)logger);
        }
        try {
            XNJSFacade.get(this.xnjsReference, this.kernel).destroyAction(this.getUniqueID(), this.getClient());
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not destroy job on XNJS.", (Throwable)e, (Logger)logger);
        }
        try {
            EndpointReferenceType uspace = ((WorkingDirResourceProperty)((Object)this.properties.get(RPWorkingDir))).getXml()[0].getWorkingDirectoryReference();
            BaseUASClient c = new BaseUASClient(uspace, (IClientConfiguration)this.kernel.getClientConfiguration());
            c.destroy();
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not destroy storages.", (Throwable)e, (Logger)logger);
        }
        super.destroy();
    }

    protected EndpointReferenceType createStorageManagementService(Map<String, Object> initParams) {
        try {
            Home smsHome = this.kernel.getHome("StorageManagement");
            String id = smsHome.createWSRFServiceInstance(initParams);
            return WSServerUtilities.makeEPR((String)"StorageManagement", (String)id, (QName)StorageManagement.SMS_PORT, (Kernel)this.kernel);
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not create storage for job", (Throwable)e, (Logger)logger);
            return null;
        }
    }

    protected EndpointReferenceType createUspace(Action a) {
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        StorageDescription description = new StorageDescription("UspaceOf-" + this.getUniqueID(), "Uspace", a.getExecutionContext().getWorkingDirectory(), StorageManagementHomeImpl.StorageTypes.VARIABLE, null, null, false, false, false, a.getUmask(), "Job's woorkspace", null);
        initMap.put(SMSBaseImpl.INIT_STORAGE_DESCRIPTION, description);
        initMap.put(INIT_PARENT_NODE, this.nodeHelper);
        initMap.put(SMSBaseImpl.INIT_INHERIT_SHARING, Boolean.TRUE);
        Calendar tt = Calendar.getInstance();
        tt.add(1, 10);
        initMap.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", tt);
        initMap.put(INITPARAM_XNJS_REFERENCE, this.xnjsReference);
        return this.createStorageManagementService(initMap);
    }

    protected StorageReferenceResourceProperty createStorageProperty(EndpointReferenceType epr) {
        StorageReferenceType type = StorageReferenceType.Factory.newInstance();
        type.setStorageEndpointReference(epr);
        type.setType(StorageTypeEnumeration.WORK);
        StorageReferenceResourceProperty srp = new StorageReferenceResourceProperty(new StorageReferenceType[]{type});
        return srp;
    }

    protected TSSReferenceResourceProperty createTSSReferenceProperty() {
        EndpointReferenceType epr = WSServerUtilities.newEPR((IContainerSecurityConfiguration)this.kernel.getContainerSecurityConfiguration());
        epr.addNewAddress().setStringValue(WSServerUtilities.makeAddress((String)"TargetSystemService", (String)this.tssId, (ContainerProperties)this.kernel.getContainerProperties()));
        WSServerUtilities.addPortType((EndpointReferenceType)epr, (QName)TargetSystem.PORTTYPE);
        TSSReferenceResourceProperty tref = new TSSReferenceResourceProperty(epr);
        return tref;
    }

    public void setTSSID(String id) {
        this.tssId = id;
        this.properties.put(RPTargetSystemReference, this.createTSSReferenceProperty());
    }
}

