/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.enumeration;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.uas.Enumeration;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.enumeration.NumberOfResultsRP;
import de.fzj.unicore.uas.impl.enumeration.ParentServiceEPRRP;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import eu.unicore.unicore6.enumeration.EnumerationPropertiesDocument;
import eu.unicore.unicore6.enumeration.GetResultsRequestDocument;
import eu.unicore.unicore6.enumeration.GetResultsResponseDocument;
import eu.unicore.unicore6.enumeration.ResultsDocument;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class EnumerationImpl
extends UASWSResourceImpl
implements Enumeration {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", EnumerationImpl.class);
    @Persist
    private QName targetProperty;
    @Persist
    private String targetServiceName;
    @Persist
    private String targetServiceUUID;
    @Persist
    EndpointReferenceType targetServiceEPR;
    public static final String INIT_TARGETSERVICE_EPR = "targetServiceEPR";
    public static final String INIT_TARGETSERVICE_RP = "targetPropertyQName";
    private ResourceProperty<?> rp;
    static final String INIT_TARGETSERVICE_RP_OBJECT = "targetProperty";

    public GetResultsResponseDocument GetResults(GetResultsRequestDocument in) throws BaseFault {
        try {
            int offset = (int)in.getGetResultsRequest().getOffset();
            int length = (int)in.getGetResultsRequest().getNumberOfResults();
            GetResultsResponseDocument resD = GetResultsResponseDocument.Factory.newInstance();
            GetResultsResponseDocument.GetResultsResponse res = resD.addNewGetResultsResponse();
            ResultsDocument d = ResultsDocument.Factory.newInstance();
            d.addNewResults();
            List xmls = this.getTargetResourceProperty().getXml(offset, length);
            for (XmlObject o : xmls) {
                WSUtilities.append((XmlObject)o, (XmlObject)d);
            }
            res.setResults(d.getResults());
            return resD;
        }
        catch (Exception ex) {
            String msg = LogUtil.createFaultMessage((String)"Error creating result list", (Throwable)ex);
            throw BaseFault.createFault((String)msg, (Throwable)ex);
        }
    }

    @Override
    public void initialise(String serviceName, Map<String, Object> initParams) throws Exception {
        super.initialise(serviceName, initParams);
        this.targetProperty = (QName)initParams.get(INIT_TARGETSERVICE_RP);
        this.targetServiceEPR = (EndpointReferenceType)initParams.get(INIT_TARGETSERVICE_EPR);
        if (this.targetServiceEPR != null) {
            this.targetServiceName = WSUtilities.extractServiceName((EndpointReferenceType)this.targetServiceEPR);
            this.targetServiceUUID = WSUtilities.extractResourceID((EndpointReferenceType)this.targetServiceEPR);
        }
        this.rp = (ResourceProperty)initParams.get(INIT_TARGETSERVICE_RP_OBJECT);
        NumberOfResultsRP nRP = new NumberOfResultsRP(this);
        this.properties.put(RPNumResults, nRP);
        ParentServiceEPRRP pRP = new ParentServiceEPRRP(this);
        this.properties.put(RPParentServiceReference, pRP);
    }

    protected ResourceProperty<?> getTargetResourceProperty() throws ResourceUnknownException, PersistenceException {
        if (this.rp != null) {
            return this.rp;
        }
        this.checkAndUpdateParent();
        Home h = this.kernel.getHome(this.targetServiceName);
        WSResourceImpl inst = (WSResourceImpl)h.get(this.targetServiceUUID);
        ResourceProperty rp = inst.getResourceProperty(this.targetProperty);
        return rp;
    }

    protected void checkAndUpdateParent() {
        try {
            if (this.kernel.getMessaging().hasMessages(this.targetServiceUUID)) {
                BaseUASClient c = new BaseUASClient(this.targetServiceEPR, (IClientConfiguration)this.kernel.getClientConfiguration());
                c.getCurrentTime();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updated parent service " + this.targetServiceEPR.getAddress().getStringValue()));
                }
            }
        }
        catch (Exception ex) {
            LogUtil.logException((String)"Error updating parent service.", (Throwable)ex);
        }
    }

    @Override
    public QName getResourcePropertyDocumentQName() {
        return EnumerationPropertiesDocument.type.getDocumentElementName();
    }
}

