/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl;

import de.fzj.unicore.uas.SMSProperties;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.exceptions.InvalidModificationException;
import de.fzj.unicore.wsrflite.xmlbeans.ModifiableResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.UmaskDocument;

public class UmaskResourceProperty
extends ModifiableResourceProperty<UmaskDocument, String> {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", UmaskResourceProperty.class);
    private static final long serialVersionUID = 1L;
    private UmaskDocument[] initialUmaskDoc = new UmaskDocument[1];
    private transient UmaskChangedListener listener = null;

    public UmaskResourceProperty(WSResourceImpl parent, String umask) {
        super(StorageManagement.RPUmask, parent, true, 1, 1);
        this.initialUmaskDoc[0] = UmaskDocument.Factory.newInstance();
        this.initialUmaskDoc[0].setUmask(umask);
        try {
            this.insert((XmlObject)this.initialUmaskDoc[0]);
        }
        catch (InvalidModificationException e) {
            throw new RuntimeException("Ups! BUG, shouldn't happen", e);
        }
    }

    public void setListener(UmaskChangedListener listener) {
        this.listener = listener;
    }

    public void update(List<UmaskDocument> o) throws InvalidModificationException {
        if (o.size() != 1) {
            throw new InvalidModificationException();
        }
        String newUmask = o.get(0).getUmask();
        if (!SMSProperties.umaskPattern.matcher(newUmask).matches()) {
            throw new InvalidModificationException("Specified umask must be an octal number from 0 to 777.");
        }
        if (this.listener != null) {
            this.listener.umaskChanged(newUmask);
        }
        super.update(o);
        logger.debug((Object)("Changed umask of " + this.parentWSResource.getUniqueID() + " to " + newUmask));
    }

    public void delete() throws InvalidModificationException {
        super.delete();
    }

    public static interface UmaskChangedListener {
        public void umaskChanged(String var1) throws InvalidModificationException;
    }
}

