/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl;

import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.security.UserAttributeCallback;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import eu.unicore.security.SecurityTokens;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class PersistingPreferencesResource
extends UASWSResourceImpl {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", PersistingPreferencesResource.class);
    @Persist
    private Map<String, String[]> storedPreferences;

    @Override
    public void initialise(String serviceName, Map<String, Object> initParams) throws Exception {
        super.initialise(serviceName, initParams);
        SecurityTokens secTokens = AuthZAttributeStore.getTokens();
        if (secTokens == null) {
            return;
        }
        Map actualPreferences = (Map)secTokens.getContext().get(UserAttributeCallback.USER_PREFERENCES_KEY);
        if (actualPreferences != null) {
            this.storedPreferences = new HashMap<String, String[]>();
            this.storedPreferences.putAll(actualPreferences);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Persisted user preferences, used to create the WS-Resource " + this.getServiceName() + " [" + this.getUniqueID() + "]: " + this.storedPreferences.keySet()));
            }
        }
    }

    public void updateSecurityTokensBeforeAIP(SecurityTokens secTokens) {
        if (this.storedPreferences == null || this.storedPreferences.size() == 0) {
            return;
        }
        HashMap<String, String[]> actualPreferences = (HashMap<String, String[]>)secTokens.getContext().get(UserAttributeCallback.USER_PREFERENCES_KEY);
        if (actualPreferences == null) {
            actualPreferences = new HashMap<String, String[]>();
            actualPreferences.putAll(this.storedPreferences);
            secTokens.getContext().put(UserAttributeCallback.USER_PREFERENCES_KEY, actualPreferences);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using saved user's preference as a defaults for " + this.getServiceName() + " [" + this.getUniqueID() + "]: " + this.storedPreferences.keySet()));
            }
            return;
        }
        for (Map.Entry<String, String[]> entry : this.storedPreferences.entrySet()) {
            if (actualPreferences.containsKey(entry.getKey())) continue;
            actualPreferences.put(entry.getKey(), entry.getValue());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Using saved user's preference as a default for " + this.getServiceName() + " [" + this.getUniqueID() + "]: " + entry.getKey() + ": " + Arrays.toString(entry.getValue())));
        }
    }
}

