/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.rft;

import de.fzj.unicore.uas.client.ReliableFileTransferClient;
import de.fzj.unicore.uas.fts.rft.AbstractStoreImpl;
import de.fzj.unicore.uas.fts.rft.ChunkImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.AsyncCommandHelper;
import eu.unicore.security.Client;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class StoreImpl
extends AbstractStoreImpl {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", StoreImpl.class);
    final TSI storage;
    final Client client;
    final Configuration config;

    public StoreImpl(Client client, TSI storage, Configuration config, String target, long totalLength) {
        super(target, totalLength);
        this.storage = storage;
        this.client = client;
        this.config = config;
    }

    protected boolean checkOK(ReliableFileTransferClient.Chunk chunk) throws Exception {
        boolean ok = false;
        XnjsFileWithACL f = this.storage.getProperties(chunk.getPath());
        logger.debug((Object)("Ack: " + chunk + " have " + f));
        if (f != null) {
            ok = chunk.getLength() == f.getSize();
        }
        return ok;
    }

    public void finish() throws Exception {
        if (this.properties.getProperty("merge.complete") == null) {
            String cmd = "/bin/cat " + this.buildFileList();
            AsyncCommandHelper ach = new AsyncCommandHelper(this.config, cmd, "merge_files", null, this.client, this.storage.getStorageRoot() + "/" + this.partsDir + "/");
            ach.setStdout("../../" + this.target);
            ach.submit();
            while (!ach.isDone()) {
                Thread.sleep(2000L);
            }
            if (!ach.getResult().getResult().isSuccessful()) {
                throw new Exception("Merge was not successful.");
            }
        }
        this.properties.setProperty("merge.complete", "true");
        this.writeProperties();
        this.storage.rmdir(this.partsDir);
    }

    protected long getActualFileSize(ReliableFileTransferClient.Chunk chunk) throws Exception {
        XnjsFileWithACL f = this.storage.getProperties(chunk.getPath());
        if (f != null) {
            return f.getSize();
        }
        return -1L;
    }

    protected void createPartsDirIfNotExists() throws Exception {
        XnjsFileWithACL parts = this.storage.getProperties(this.target + ".unicore_rft.parts");
        if (parts == null) {
            this.storage.mkdir(this.partsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPropertiesFileIfExists() throws Exception {
        XnjsFileWithACL propFile = this.storage.getProperties(this.propertiesPath);
        if (propFile != null) {
            InputStream is = this.storage.getInputStream(this.propertiesPath);
            try {
                this.properties.load(is);
            }
            finally {
                is.close();
            }
        }
    }

    protected OutputStream getOutputStream(String path, boolean append) throws IOException {
        try {
            return this.storage.getOutputStream(path, append);
        }
        catch (ExecutionException ex) {
            throw new IOException(ex);
        }
    }

    protected ReliableFileTransferClient.Chunk createChunk(int index, String path, long offset, long length) {
        return new ChunkImpl(index, (IStorageAdapter)this.storage, path, offset, length);
    }
}

