/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.http;

import de.fzj.unicore.uas.fts.http.FileServlet;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jetty.util.resource.Resource;

public class UResource
extends Resource {
    protected final String path;
    protected final String id;
    protected final IStorageAdapter storage;
    protected final Kernel kernel;
    protected long transferred = 0L;
    protected IFileTransfer.OverwritePolicy overwrite = IFileTransfer.OverwritePolicy.OVERWRITE;

    public UResource(String id, String path, IStorageAdapter storage, Kernel kernel) {
        this.id = id;
        this.path = path;
        this.storage = storage;
        this.kernel = kernel;
    }

    public void setOverwritePolicy(IFileTransfer.OverwritePolicy policy) {
        this.overwrite = policy;
    }

    protected void updateTransferredBytes() {
        if (this.id != null) {
            FileServlet fs = (FileServlet)((Object)this.kernel.getAttribute(FileServlet.class));
            fs.setTransferredBytes(this.id, this.transferred);
        }
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        return null;
    }

    public boolean delete() throws SecurityException {
        return false;
    }

    public boolean exists() {
        try {
            return this.storage.getProperties(this.path) != null;
        }
        catch (ExecutionException executionException) {
            return true;
        }
    }

    public File getFile() throws IOException {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        try {
            final InputStream is = this.storage.getInputStream(this.path);
            InputStream decoratedStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return is.read();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int r = is.read(b, off, len);
                    if (r > 0) {
                        UResource.this.transferred += (long)r;
                        UResource.this.updateTransferredBytes();
                    }
                    return r;
                }

                @Override
                public void close() throws IOException {
                    is.close();
                }
            };
            return decoratedStream;
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public String getName() {
        return this.path;
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        try {
            boolean append = IFileTransfer.OverwritePolicy.APPEND.equals((Object)this.overwrite);
            final OutputStream os = this.storage.getOutputStream(this.path, append);
            OutputStream decoratedStream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    os.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    os.write(b, off, len);
                    UResource.this.transferred += (long)len;
                    UResource.this.updateTransferredBytes();
                }

                @Override
                public void close() throws IOException {
                    os.close();
                }

                @Override
                public void flush() throws IOException {
                    os.flush();
                }
            };
            return decoratedStream;
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public URL getURL() {
        return null;
    }

    public boolean isDirectory() {
        return false;
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        try {
            return this.storage.getProperties(this.path).getSize();
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public String[] list() {
        return null;
    }

    public void release() {
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        return false;
    }

    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return false;
    }
}

