/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.http;

import de.fzj.unicore.uas.ft.http.AccessURLDocument;
import de.fzj.unicore.uas.fts.FileTransferImpl;
import de.fzj.unicore.uas.fts.http.FileServlet;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.Utilities;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

public class HttpFileTransferImpl
extends FileTransferImpl {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", HttpFileTransferImpl.class);
    public static final QName RPAccessURL = AccessURLDocument.type.getDocumentElementName();
    private static final QName portType = new QName("http://unigrids.org/2006/04/services/bfts", "BaselineFileTransferService");
    @Persist
    protected String unique;
    @Persist
    protected String accessURL;

    @Override
    public void initialise(String name, Map<String, Object> map) throws Exception {
        super.initialise(name, map);
        try {
            FileServlet.initialise(this.getKernel());
            String url = this.exposeFile();
            AccessURLDocument urlRP = AccessURLDocument.Factory.newInstance();
            urlRP.setAccessURL(url);
            this.properties.put(RPAccessURL, new ImmutableResourceProperty((XmlObject)urlRP));
            this.setOK();
        }
        catch (Exception e) {
            LogUtil.logException((String)"Error initialising filetransfer", (Throwable)e, (Logger)logger);
            this.status = 5;
            this.description = "Error initialising filetransfer";
            throw e;
        }
    }

    private String exposeFile() throws IOException {
        if (this.unique == null) {
            this.unique = Utilities.newUniqueID();
        }
        String path = this.isExport != false ? this.source : this.target;
        FileServlet fs = (FileServlet)((Object)this.kernel.getAttribute(FileServlet.class));
        fs.exposeFile(this.unique, path, this.overWrite == false, this.getStorageAdapter());
        this.accessURL = this.makeAccessURL(this.unique);
        return this.accessURL;
    }

    protected String makeAccessURL(String uniqueID) {
        String add = null;
        ContainerProperties mainProps = this.getKernel().getContainerProperties();
        if (!this.uasProperties.getBooleanValue("filetransfer.direct").booleanValue()) {
            String base = mainProps.getBaseUrl();
            add = base.replace("services", "files") + "/" + uniqueID;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Enabling HTTP access on URL: " + add));
            }
        } else {
            String host = mainProps.getValue("host");
            String port = mainProps.getValue("port");
            String serv = "/files";
            String proto = "http";
            if (this.kernel.getContainerSecurityConfiguration().isSslEnabled()) {
                proto = "https";
            }
            add = proto + "://" + host + ":" + port + serv + "/" + uniqueID;
        }
        if (this.uasProperties.getBooleanValue("filetransfer.httpPreferPost").booleanValue()) {
            add = add + "?method=POST";
        }
        return add;
    }

    private void unExposeFile() {
        FileServlet fs = (FileServlet)((Object)this.kernel.getAttribute(FileServlet.class));
        fs.unExposeFile(this.unique);
    }

    @Override
    public void destroy() {
        this.unExposeFile();
        super.destroy();
    }

    @Override
    protected Long getTransferredBytes() {
        FileServlet fs = (FileServlet)((Object)this.kernel.getAttribute(FileServlet.class));
        Long t = fs.getTransferredBytes(this.unique);
        if (t != null) {
            this.transferredBytes = t;
        } else {
            logger.debug((Object)("Can't get transferred bytes for transfer <" + this.unique + ">"));
        }
        return this.transferredBytes;
    }

    @Override
    public QName getPortType() {
        return portType;
    }
}

