/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.http;

import de.fzj.unicore.uas.fts.http.UDirectoryResource;
import de.fzj.unicore.uas.fts.http.UResource;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;

public class FileServlet
extends DefaultServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", FileServlet.class);
    private final Map<String, UResource> map = new ConcurrentHashMap<String, UResource>();
    private final Map<String, Long> transferredBytes = new ConcurrentHashMap<String, Long>();
    private final Kernel kernel;
    private static final int BUFFER_SIZE = 16384;
    private static final String multipart = "multipart/form-data";

    public FileServlet(Kernel kernel) {
        this.kernel = kernel;
    }

    public static synchronized void initialise(Kernel kernel) {
        if (kernel.getAttribute(FileServlet.class) != null) {
            return;
        }
        FileServlet fs = new FileServlet(kernel);
        kernel.setAttribute(FileServlet.class, (Object)fs);
        ServletHolder sh = new ServletHolder("fileServlet", (Servlet)fs);
        kernel.getServer().getRootServletContext().addServlet(sh, "/files/*");
    }

    public void exposeFile(String id, String remotePath, boolean append, IStorageAdapter storage) {
        try {
            UResource fr = new UResource(id, remotePath, storage, this.kernel);
            if (append) {
                fr.setOverwritePolicy(IFileTransfer.OverwritePolicy.APPEND);
            }
            this.map.put(id, fr);
        }
        catch (Exception mue) {
            LogUtil.logException((String)"", (Throwable)mue);
        }
    }

    public void exposeDirectory(String id, String remotePath, boolean append, IStorageAdapter storage) {
        try {
            UDirectoryResource fr = new UDirectoryResource(id, remotePath, storage, this.kernel);
            if (append) {
                fr.setOverwritePolicy(IFileTransfer.OverwritePolicy.APPEND);
            }
            this.map.put(id, fr);
        }
        catch (Exception mue) {
            LogUtil.logException((String)"", (Throwable)mue);
        }
    }

    public void unExposeFile(String id) {
        UResource fr = this.map.get(id);
        if (fr != null) {
            fr.release();
        }
        this.map.remove(id);
        this.transferredBytes.remove(id);
    }

    public Long getTransferredBytes(String id) {
        return this.transferredBytes.get(id);
    }

    public void setTransferredBytes(String id, Long transferred) {
        this.transferredBytes.put(id, transferred);
    }

    public UResource getResource(String pathInContext) {
        return this.getUResource(new File(pathInContext), null);
    }

    private UResource getUResource(File base, String fileName) {
        String id = base.getName();
        UResource fr = this.map.get(id);
        if (fr == null) {
            if ((base = base.getParentFile()) == null) {
                return null;
            }
            fileName = fileName != null ? id + "/" + fileName : id;
            return this.getUResource(base, fileName);
        }
        if (fileName != null && fr.isDirectory()) {
            UResource newResource = new UResource(null, fr.path + "/" + fileName, fr.storage, this.kernel);
            return newResource;
        }
        return fr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UResource r = this.getResource(request.getRequestURI());
        OutputStream out = null;
        ServletInputStream in = null;
        try {
            out = r.getOutputStream();
            in = request.getInputStream();
            this.copy((InputStream)in, out);
            response.setStatus(204);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UResource r = this.getResource(request.getRequestURI());
        OutputStream out = null;
        ServletInputStream in = null;
        String contentType = request.getHeader("Content-Type");
        if (contentType == null || contentType.indexOf(multipart) == -1) {
            throw new ServletException("Invalid content type: only 'multipart/form-data' is accepted.");
        }
        try {
            out = r.getOutputStream();
            in = request.getInputStream();
            this.copy((InputStream)in, out);
            response.setStatus(204);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[16384];
        int len = 0;
        long total = 0L;
        while ((len = in.read(buffer, 0, 16384)) >= 0) {
            if (len <= 0) continue;
            out.write(buffer, 0, len);
            total += (long)len;
        }
        logger.debug((Object)("Total bytes copied : " + total));
        out.flush();
    }
}

