/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.byteio;

import de.fzj.unicore.uas.fts.FileTransferImpl;
import de.fzj.unicore.uas.fts.byteio.ByteIO;
import de.fzj.unicore.uas.fts.byteio.ByteIOSizeResourceProperty;
import de.fzj.unicore.uas.fts.byteio.EndOfStreamRP;
import de.fzj.unicore.uas.fts.byteio.PositionRP;
import de.fzj.unicore.uas.fts.byteio.StreamableByteIO;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.simple.LocalTS;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.byteio.x2005.x10.byteIo.TransferInformationType;
import org.ggf.schemas.byteio.x2005.x10.streamableAccess.ReadableDocument;
import org.ggf.schemas.byteio.x2005.x10.streamableAccess.SeekReadDocument;
import org.ggf.schemas.byteio.x2005.x10.streamableAccess.SeekReadResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.streamableAccess.SeekWriteDocument;
import org.ggf.schemas.byteio.x2005.x10.streamableAccess.SeekWriteResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.streamableAccess.SeekableDocument;
import org.ggf.schemas.byteio.x2005.x10.streamableAccess.TransferMechanismDocument;
import org.ggf.schemas.byteio.x2005.x10.streamableAccess.WriteableDocument;

public class StreamableByteIOImpl
extends FileTransferImpl
implements StreamableByteIO {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", StreamableByteIOImpl.class);
    private static final Map<String, Object> streams = Collections.synchronizedMap(new HashMap());
    @Persist
    protected Long currentPosition = 0L;
    private static final QName portType = new QName("http://schemas.ggf.org/byteio/2005/10/streamable-access", "StreamableByteIO");

    @Override
    public SeekReadResponseDocument seekRead(SeekReadDocument req) throws BaseFault {
        try {
            SeekReadDocument.SeekRead r = req.getSeekRead();
            String origin = r.getSeekOrigin();
            long offset = r.getOffset();
            long numBytes = r.getNumBytes();
            byte[] data = this.doRead(origin, offset, numBytes);
            SeekReadResponseDocument res = SeekReadResponseDocument.Factory.newInstance();
            TransferInformationType ti = res.addNewSeekReadResponse().addNewTransferInformation();
            String mechanism = r.getTransferInformation().getTransferMechanism();
            ti.set(ByteIO.encode((String)mechanism, (byte[])data));
            ti.setTransferMechanism(mechanism);
            this.setDirty();
            this.setOK();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not perform seek-read", (Throwable)e, (Logger)logger);
            this.status = 5;
            this.description = "Could not perform seek-read.";
            throw BaseFault.createFault((String)("Could not perform seek-read: " + e.getMessage()), (Throwable)e);
        }
    }

    protected byte[] doRead(String origin, long offset, long numBytes) throws IOException, ExecutionException {
        InputStream is;
        long skipped;
        boolean fromBeginning = false;
        if ("http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/beginning".equals(origin)) {
            fromBeginning = true;
        } else if (!"http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/current".equals(origin)) {
            throw new IOException("Can't seek from <" + origin + ">, only 'current position' " + "and 'beginning of stream' are supported.");
        }
        if (fromBeginning) {
            this.removeStream();
        }
        if ((skipped = (is = this.getInputStream()).skip(offset)) < offset) {
            throw new IOException("Attempted to offset past end of file.");
        }
        this.currentPosition = this.currentPosition + offset;
        byte[] data = new byte[(int)numBytes];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int read = is.read(data);
        if (read > 0) {
            os.write(data, 0, read);
            this.currentPosition = this.currentPosition + (long)read;
            this.setDirty();
        }
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekWriteResponseDocument seekWrite(SeekWriteDocument req) throws BaseFault {
        try {
            String origin = req.getSeekWrite().getSeekOrigin();
            TransferInformationType ti = req.getSeekWrite().getTransferInformation();
            String mechanism = ti.getTransferMechanism();
            byte[] data = ByteIO.decode((String)mechanism, (XmlObject)ti);
            long offset = req.getSeekWrite().getOffset();
            SeekWriteResponseDocument res = SeekWriteResponseDocument.Factory.newInstance();
            TransferInformationType ti2 = res.addNewSeekWriteResponse().addNewTransferInformation();
            ti2.setTransferMechanism(mechanism);
            IStorageAdapter tsi = this.getStorageAdapter();
            if (tsi instanceof LocalTS) {
                String file = this.isExport != false ? this.source : this.target;
                RandomAccessFile f = ((LocalTS)tsi).getRandomAccessFile(file);
                try {
                    if ("http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/current".equalsIgnoreCase(origin)) {
                        this.currentPosition = this.currentPosition + offset;
                    } else if ("http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/beginning".equalsIgnoreCase(origin)) {
                        this.currentPosition = offset;
                    } else if ("http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/end".equalsIgnoreCase(origin)) {
                        if (offset > 0L) {
                            throw new BaseFault("Positive offset from end-of-file not allowed.");
                        }
                        this.currentPosition = f.length() + offset;
                    } else {
                        throw new BaseFault("Can't fulfil write request. Only seek-origin 'beginning' or 'current' is supported.");
                    }
                    f.seek(this.currentPosition);
                    f.write(data);
                }
                finally {
                    try {
                        f.close();
                    }
                    catch (Exception e) {}
                }
            }
            if (!"http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/current".equalsIgnoreCase(origin)) {
                if ("http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/end".equalsIgnoreCase(origin)) {
                    this.overWrite = false;
                } else if ("http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/beginning".equalsIgnoreCase(origin)) {
                    streams.remove(this.getUniqueID() + "_out");
                } else {
                    throw new BaseFault("Unsupported seek-origin");
                }
            }
            this.doWrite(data, offset);
            this.currentPosition = this.currentPosition + (long)data.length;
            this.setDirty();
            this.setOK();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not perform seekWrite", (Throwable)e, (Logger)logger);
            this.status = 5;
            this.description = "Could not perform seekWrite";
            throw BaseFault.createFault((String)("Could not perform seekWrite: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void doWrite(byte[] data, long offset) throws Exception {
        this.getOutputStream().write(data);
        this.getOutputStream().flush();
    }

    protected InputStream getInputStream() throws ExecutionException, IOException {
        InputStream is = (InputStream)streams.get(this.getUniqueID() + "_in");
        if (is == null) {
            is = this.createNewInputStream();
            streams.put(this.getUniqueID() + "_in", is);
        }
        return is;
    }

    protected OutputStream getOutputStream() throws ExecutionException, IOException {
        OutputStream os = (OutputStream)streams.get(this.getUniqueID() + "_out");
        if (os == null) {
            os = this.createNewOutputStream(this.overWrite == false);
            streams.put(this.getUniqueID() + "_out", os);
        }
        return os;
    }

    @Override
    public void initialise(String sname, Map<String, Object> map) throws Exception {
        super.initialise(sname, map);
        this.properties.put(StreamableByteIO.RPSize, new ByteIOSizeResourceProperty(this));
        TransferMechanismDocument tmd = TransferMechanismDocument.Factory.newInstance();
        tmd.setTransferMechanism("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple");
        TransferMechanismDocument tmd2 = TransferMechanismDocument.Factory.newInstance();
        tmd2.setTransferMechanism("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/mtom");
        this.properties.put(RPTransferMechanisms, new ImmutableResourceProperty(new XmlObject[]{tmd}));
        ReadableDocument r = ReadableDocument.Factory.newInstance();
        r.setReadable(true);
        WriteableDocument w = WriteableDocument.Factory.newInstance();
        w.setWriteable(true);
        SeekableDocument s = SeekableDocument.Factory.newInstance();
        s.setSeekable(true);
        this.properties.put(RPReadable, new ImmutableResourceProperty((XmlObject)r));
        this.properties.put(RPWriteable, new ImmutableResourceProperty((XmlObject)w));
        this.properties.put(RPSeekable, new ImmutableResourceProperty((XmlObject)s));
        this.properties.put(RPEndOfStream, new EndOfStreamRP(this));
        this.properties.put(RPPosition, new PositionRP(this));
    }

    @Override
    public void destroy() {
        this.removeStream();
        super.destroy();
    }

    private void removeStream() {
        Object inStr = streams.remove(this.getUniqueID() + "_in");
        Object outStr = streams.remove(this.getUniqueID() + "_out");
        try {
            if (inStr != null) {
                ((InputStream)inStr).close();
            }
            if (outStr != null) {
                ((OutputStream)outStr).close();
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not remove stream.", (Throwable)e, (Logger)logger);
        }
    }

    protected boolean isEndOfStream() {
        try {
            Object str = streams.get(this.getUniqueID());
            if (str instanceof InputStream) {
                return ((InputStream)str).available() <= 0;
            }
            if (str instanceof OutputStream) {
                return false;
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)"Error accessing stream.", (Throwable)e, (Logger)logger);
        }
        return true;
    }

    protected long getCurrentPosition() {
        return this.currentPosition;
    }

    @Override
    public QName getPortType() {
        return portType;
    }

    public static boolean streamExists(String id) {
        return streams.containsKey(id);
    }
}

