/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.byteio;

import de.fzj.unicore.uas.fts.byteio.RandomByteIOSupport;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.simple.LocalTS;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

public class StorageAdapterRByteIOSupport
extends RandomByteIOSupport {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", StorageAdapterRByteIOSupport.class);
    private IStorageAdapter storageAdapter;
    private String resourcePath;

    public StorageAdapterRByteIOSupport(IStorageAdapter storageAdapter, String resourcePath) {
        this.storageAdapter = storageAdapter;
        this.resourcePath = resourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(long offset, long bytesPerBlock, long numBlocks, long stride) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        InputStream is = this.createInputStream();
        try {
            byte[] data = new byte[(int)bytesPerBlock];
            long skipped = is.skip(offset);
            if (skipped < offset) {
                throw new IOException("Attempted to offset past end of file.");
            }
            int block = 0;
            while ((long)block < numBlocks) {
                int read = is.read(data);
                if (read > 0) {
                    this.bytesRead(read);
                    os.write(data, 0, read);
                }
                if (stride > 0L) {
                    long t;
                    if (is != null) {
                        is.close();
                    }
                    if ((skipped = (is = this.createInputStream()).skip(t = offset + stride * (long)(block + 1))) < t) {
                        throw new IOException("Attempted to skip past end of file.");
                    }
                }
                ++block;
            }
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (ExecutionException w) {
                throw new IOException(w.getMessage(), w.getCause());
            }
        }
        try {
            is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] data, long initialOffset, long bytesPerBlock, long stride) throws IOException {
        block10: {
            try {
                IStorageAdapter tsi = this.getStorageAdapter();
                if (tsi instanceof LocalTS) {
                    String file = this.getResourcePath();
                    RandomAccessFile f = ((LocalTS)tsi).getRandomAccessFile(file);
                    try {
                        int toWrite;
                        for (int off = 0; off < data.length; off += toWrite) {
                            toWrite = data.length - off;
                            if ((long)toWrite > bytesPerBlock) {
                                toWrite = (int)bytesPerBlock;
                            }
                            if (initialOffset != 0L) {
                                f.seek(initialOffset);
                            }
                            f.write(data, off, toWrite);
                            this.bytesWritten(toWrite);
                            initialOffset += stride;
                        }
                        break block10;
                    }
                    finally {
                        if (f != null) {
                            f.close();
                        }
                    }
                }
                this.writeToOutputStream(data, initialOffset, bytesPerBlock, stride);
            }
            catch (ExecutionException w) {
                throw new IOException(w.getMessage(), w.getCause());
            }
        }
    }

    protected void writeToOutputStream(byte[] data, long initialOffset, long bytesPerBlock, long stride) throws IOException, ExecutionException {
        if (initialOffset > 0L) {
            throw new IllegalArgumentException("Can't fulfil write request.");
        }
        OutputStream os = this.createOutputStream(false);
        os.write(data, 0, (int)bytesPerBlock);
        this.bytesWritten(bytesPerBlock);
        os.close();
    }

    @Override
    public void append(byte[] data) throws IOException {
        try {
            OutputStream os = this.createOutputStream(true);
            os.write(data);
            this.bytesAppended(data.length);
            os.flush();
            os.close();
        }
        catch (ExecutionException w) {
            throw new IOException(w.getMessage(), w.getCause());
        }
    }

    @Override
    public void truncAppend(byte[] data, long offset) throws IOException {
        if (offset == 0L) {
            this.write(data, 0L, data.length, data.length);
            return;
        }
        if (this.getDataSize() != offset) {
            throw new IOException("Truncate is not supported.");
        }
        this.append(data);
    }

    protected IStorageAdapter getStorageAdapter() {
        return this.storageAdapter;
    }

    protected String getResourcePath() {
        return this.resourcePath;
    }

    protected void bytesRead(long bytes) {
    }

    protected void bytesWritten(long bytes) {
    }

    protected void bytesAppended(long bytes) {
    }

    protected long getDataSize() {
        String filename = this.getResourcePath();
        try {
            XnjsFileWithACL f = this.getStorageAdapter().getProperties(filename);
            if (f != null) {
                return f.getSize();
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)("Could not determine file size for <" + filename + ">"), (Throwable)e, (Logger)logger);
        }
        return 0L;
    }

    protected InputStream createInputStream() throws IOException, ExecutionException {
        InputStream is = this.getStorageAdapter().getInputStream(this.getResourcePath());
        return is;
    }

    protected OutputStream createOutputStream(boolean append) throws IOException, ExecutionException {
        OutputStream os = this.getStorageAdapter().getOutputStream(this.getResourcePath(), append);
        return os;
    }
}

