/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.byteio;

import de.fzj.unicore.uas.fts.DataResource;
import de.fzj.unicore.uas.fts.byteio.ByteIO;
import de.fzj.unicore.uas.fts.byteio.ByteIOSizeResourceProperty;
import de.fzj.unicore.uas.fts.byteio.RandomByteIO;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.byteio.x2005.x10.byteIo.TransferInformationType;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.AppendDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.AppendResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.ReadDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.ReadResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.ReadableDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.TransferMechanismDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.TruncAppendDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.TruncAppendResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.WriteDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.WriteResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.WriteableDocument;

public abstract class RandomByteIOSupport {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", RandomByteIOSupport.class);
    private transient Kernel kernel;

    public ReadResponseDocument read(ReadDocument req) throws BaseFault {
        byte[] data;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)req.toString());
        }
        BigInteger offset = req.getRead().getStartOffset();
        long numBlocks = req.getRead().getNumBlocks();
        long bytesPerBlock = req.getRead().getBytesPerBlock();
        long stride = req.getRead().getStride();
        try {
            data = this.read(offset.longValue(), bytesPerBlock, numBlocks, stride);
        }
        catch (IOException e) {
            throw BaseFault.createFault((String)("Could not perform read: " + e.getMessage()), (Throwable)e);
        }
        ReadResponseDocument res = ReadResponseDocument.Factory.newInstance();
        TransferInformationType ti = res.addNewReadResponse().addNewTransferInformation();
        String mechanism = req.getRead().getTransferInformation().getTransferMechanism();
        ti.set(ByteIO.encode((String)mechanism, (byte[])data));
        ti.setTransferMechanism(mechanism);
        return res;
    }

    public WriteResponseDocument write(WriteDocument req) throws BaseFault {
        BigInteger offsetP;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)req.toString());
        }
        long offset = (offsetP = req.getWrite().getStartOffset()) == null ? 0L : offsetP.longValue();
        long bytesPerBlock = req.getWrite().getBytesPerBlock();
        long stride = req.getWrite().getStride();
        TransferInformationType ti = req.getWrite().getTransferInformation();
        String mechanism = ti.getTransferMechanism();
        try {
            byte[] data = ByteIO.decode((String)mechanism, (XmlObject)ti);
            this.write(data, offset, bytesPerBlock, stride);
        }
        catch (Exception e) {
            throw BaseFault.createFault((String)("Could not perform write: " + e.getMessage()), (Throwable)e);
        }
        WriteResponseDocument res = WriteResponseDocument.Factory.newInstance();
        TransferInformationType tiRes = res.addNewWriteResponse().addNewTransferInformation();
        tiRes.setTransferMechanism(mechanism);
        return res;
    }

    public AppendResponseDocument append(AppendDocument req) throws BaseFault {
        TransferInformationType ti = req.getAppend().getTransferInformation();
        try {
            byte[] data = ByteIO.decode((String)ti.getTransferMechanism(), (XmlObject)ti);
            this.append(data);
        }
        catch (Exception e) {
            throw BaseFault.createFault((String)("Could not perform append: " + e.getMessage()), (Throwable)e);
        }
        AppendResponseDocument res = AppendResponseDocument.Factory.newInstance();
        res.addNewAppendResponse();
        res.getAppendResponse().addNewTransferInformation().setTransferMechanism(req.getAppend().getTransferInformation().getTransferMechanism());
        return res;
    }

    public TruncAppendResponseDocument truncAppend(TruncAppendDocument req) throws BaseFault {
        TransferInformationType ti = req.getTruncAppend().getTransferInformation();
        try {
            byte[] data = ByteIO.decode((String)ti.getTransferMechanism(), (XmlObject)ti);
            BigInteger offset = req.getTruncAppend().getOffset();
            this.truncAppend(data, offset.longValue());
        }
        catch (Exception e) {
            throw BaseFault.createFault((String)("Could not perform truncAppend: " + e.getMessage()), (Throwable)e);
        }
        TruncAppendResponseDocument res = TruncAppendResponseDocument.Factory.newInstance();
        res.addNewTruncAppendResponse();
        res.getTruncAppendResponse().addNewTransferInformation().setTransferMechanism(req.getTruncAppend().getTransferInformation().getTransferMechanism());
        return res;
    }

    public static void addByteIOProperties(DataResource resource, Map<QName, ResourceProperty> properties, long size, boolean readable, boolean writable) throws Exception {
        properties.put(RandomByteIO.RPSize, new ByteIOSizeResourceProperty(resource));
        ReadableDocument r = ReadableDocument.Factory.newInstance();
        r.setReadable(readable);
        WriteableDocument w = WriteableDocument.Factory.newInstance();
        w.setWriteable(writable);
        properties.put(RandomByteIO.RPReadable, (ResourceProperty)new ImmutableResourceProperty((XmlObject)r));
        properties.put(RandomByteIO.RPWriteable, (ResourceProperty)new ImmutableResourceProperty((XmlObject)w));
        TransferMechanismDocument tmd = TransferMechanismDocument.Factory.newInstance();
        tmd.setTransferMechanism("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple");
        TransferMechanismDocument tmd2 = TransferMechanismDocument.Factory.newInstance();
        tmd2.setTransferMechanism("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/mtom");
        properties.put(RandomByteIO.RPTransferMechanisms, (ResourceProperty)new ImmutableResourceProperty(new XmlObject[]{tmd}));
    }

    public abstract byte[] read(long var1, long var3, long var5, long var7) throws IOException;

    public abstract void write(byte[] var1, long var2, long var4, long var6) throws IOException;

    public abstract void append(byte[] var1) throws IOException;

    public abstract void truncAppend(byte[] var1, long var2) throws IOException;

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }
}

