/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.byteio;

import de.fzj.unicore.uas.fts.FileTransferImpl;
import de.fzj.unicore.uas.fts.byteio.ByteIO;
import de.fzj.unicore.uas.fts.byteio.ByteIOSizeResourceProperty;
import de.fzj.unicore.uas.fts.byteio.RandomByteIO;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.simple.LocalTS;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.byteio.x2005.x10.byteIo.TransferInformationType;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.AppendDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.AppendResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.ReadDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.ReadResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.ReadableDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.TransferMechanismDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.TruncAppendDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.TruncAppendResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.WriteDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.WriteResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.WriteableDocument;

public class RandomByteIOImpl
extends FileTransferImpl
implements RandomByteIO {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", RandomByteIOImpl.class);
    @Persist
    private long transferredBytes = 0L;
    private static final QName portType = new QName("http://schemas.ggf.org/byteio/2005/10/random-access", "RandomByteIO");

    @Override
    protected Long getTransferredBytes() {
        return this.transferredBytes;
    }

    public ReadResponseDocument read(ReadDocument req) throws BaseFault {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)req.toString());
            }
            BigInteger offset = req.getRead().getStartOffset();
            long numBlocks = req.getRead().getNumBlocks();
            long bytesPerBlock = req.getRead().getBytesPerBlock();
            long stride = req.getRead().getStride();
            byte[] data = this.doRead(offset.longValue(), bytesPerBlock, numBlocks, stride);
            ReadResponseDocument res = ReadResponseDocument.Factory.newInstance();
            TransferInformationType ti = res.addNewReadResponse().addNewTransferInformation();
            String mechanism = req.getRead().getTransferInformation().getTransferMechanism();
            ti.set(ByteIO.encode((String)mechanism, (byte[])data));
            ti.setTransferMechanism(mechanism);
            this.setOK();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not perform read", (Throwable)e, (Logger)logger);
            this.status = 5;
            this.description = "Could not perform read for request " + req;
            this.setDirty();
            throw BaseFault.createFault((String)"Could not perform read", (Throwable)e);
        }
    }

    public WriteResponseDocument write(WriteDocument req) throws BaseFault {
        try {
            BigInteger offsetP;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)req.toString());
            }
            long offset = (offsetP = req.getWrite().getStartOffset()) == null ? 0L : offsetP.longValue();
            long bytesPerBlock = req.getWrite().getBytesPerBlock();
            long stride = req.getWrite().getStride();
            TransferInformationType ti = req.getWrite().getTransferInformation();
            String mechanism = ti.getTransferMechanism();
            byte[] data = ByteIO.decode((String)mechanism, (XmlObject)ti);
            this.doWrite(data, offset, bytesPerBlock, stride);
            WriteResponseDocument res = WriteResponseDocument.Factory.newInstance();
            TransferInformationType tiRes = res.addNewWriteResponse().addNewTransferInformation();
            tiRes.setTransferMechanism(mechanism);
            this.setOK();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not perform write.", (Throwable)e, (Logger)logger);
            this.status = 5;
            this.description = "Could not perform write for request " + req;
            this.setDirty();
            throw BaseFault.createFault((String)"Could not perform write.", (Throwable)e);
        }
    }

    public AppendResponseDocument append(AppendDocument req) throws BaseFault {
        try {
            TransferInformationType ti = req.getAppend().getTransferInformation();
            byte[] data = ByteIO.decode((String)ti.getTransferMechanism(), (XmlObject)ti);
            this.doAppend(data);
            AppendResponseDocument res = AppendResponseDocument.Factory.newInstance();
            res.addNewAppendResponse();
            res.getAppendResponse().addNewTransferInformation().setTransferMechanism(req.getAppend().getTransferInformation().getTransferMechanism());
            this.setOK();
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.logException((String)"Could not perform append().", (Throwable)e, (Logger)logger);
            this.status = 5;
            this.description = "Could not perform append for request " + req;
            this.setDirty();
            throw BaseFault.createFault((String)"Could not perform append", (Throwable)e);
        }
    }

    public TruncAppendResponseDocument truncAppend(TruncAppendDocument req) throws BaseFault {
        try {
            TransferInformationType ti = req.getTruncAppend().getTransferInformation();
            byte[] data = ByteIO.decode((String)ti.getTransferMechanism(), (XmlObject)ti);
            BigInteger offset = req.getTruncAppend().getOffset();
            this.doTruncAppend(data, offset.longValue());
            TruncAppendResponseDocument res = TruncAppendResponseDocument.Factory.newInstance();
            res.addNewTruncAppendResponse();
            res.getTruncAppendResponse().addNewTransferInformation().setTransferMechanism(req.getTruncAppend().getTransferInformation().getTransferMechanism());
            this.setOK();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not perform truncAppend().", (Throwable)e, (Logger)logger);
            this.status = 5;
            this.description = "Could not perform truncAppend for request " + req;
            this.setDirty();
            throw BaseFault.createFault((String)"Could not perform truncAppend", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doRead(long offset, long bytesPerBlock, long numBlocks, long stride) throws IOException, ExecutionException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        InputStream is = this.createNewInputStream();
        try {
            byte[] data = new byte[(int)bytesPerBlock];
            long skipped = is.skip(offset);
            if (skipped < offset) {
                throw new IOException("Attempted to offset past end of file.");
            }
            int block = 0;
            while ((long)block < numBlocks) {
                int read = is.read(data);
                if (read > 0) {
                    this.transferredBytes += (long)read;
                    os.write(data, 0, read);
                }
                if (stride > 0L) {
                    long t;
                    if (is != null) {
                        is.close();
                    }
                    if ((skipped = (is = this.createNewInputStream()).skip(t = offset + stride * (long)(block + 1))) < t) {
                        throw new IOException("Attempted to skip past end of file.");
                    }
                }
                ++block;
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(byte[] data, long initialOffset, long bytesPerBlock, long stride) throws IOException, ExecutionException {
        IStorageAdapter tsi = this.getStorageAdapter();
        if (tsi instanceof LocalTS) {
            String file = this.isExport != false ? this.source : this.target;
            RandomAccessFile f = ((LocalTS)tsi).getRandomAccessFile(file);
            try {
                int toWrite;
                for (int off = 0; off < data.length; off += toWrite) {
                    toWrite = data.length - off;
                    if ((long)toWrite > bytesPerBlock) {
                        toWrite = (int)bytesPerBlock;
                    }
                    if (initialOffset != 0L) {
                        f.seek(initialOffset);
                    }
                    f.write(data, off, toWrite);
                    this.transferredBytes += (long)toWrite;
                    initialOffset += stride;
                }
            }
            finally {
                if (f != null) {
                    f.close();
                }
            }
        } else {
            this.doWriteToOutputStream(data, initialOffset, bytesPerBlock, stride);
        }
    }

    protected void doWriteToOutputStream(byte[] data, long initialOffset, long bytesPerBlock, long stride) throws IOException, ExecutionException {
        if (initialOffset > 0L) {
            throw new IllegalArgumentException("Can't fulfil write request.");
        }
        OutputStream os = this.createNewOutputStream(false);
        os.write(data, 0, (int)bytesPerBlock);
        this.transferredBytes += bytesPerBlock;
        os.close();
    }

    protected void doAppend(byte[] data) throws IOException, ExecutionException {
        OutputStream os = this.createNewOutputStream(true);
        os.write(data);
        this.transferredBytes += (long)data.length;
        this.firstWrite = false;
        os.flush();
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTruncAppend(byte[] data, long offset) throws IOException, ExecutionException {
        IStorageAdapter tsi = this.getStorageAdapter();
        if (tsi instanceof LocalTS) {
            String file = this.isExport != false ? this.source : this.target;
            RandomAccessFile f = ((LocalTS)tsi).getRandomAccessFile(file);
            try {
                f.setLength(offset);
                f.seek(offset);
                f.write(data);
                this.transferredBytes += (long)data.length;
            }
            finally {
                if (f != null) {
                    f.close();
                }
            }
        } else {
            this.doTruncAppendToOutputStream(data, offset);
        }
    }

    protected void doTruncAppendToOutputStream(byte[] data, long offset) throws IOException, ExecutionException {
        if (!this.firstWrite.booleanValue()) {
            if (this.getDataSize() != offset) {
                throw new IOException("Truncate is not supported.");
            }
            if (offset == 0L) {
                this.doWrite(data, 0L, data.length, data.length);
            }
        }
        this.doAppend(data);
    }

    @Override
    public void initialise(String sname, Map<String, Object> map) throws Exception {
        super.initialise(sname, map);
        this.properties.put(RandomByteIO.RPSize, new ByteIOSizeResourceProperty(this));
        ReadableDocument r = ReadableDocument.Factory.newInstance();
        r.setReadable(true);
        WriteableDocument w = WriteableDocument.Factory.newInstance();
        w.setWriteable(true);
        this.properties.put(RPReadable, new ImmutableResourceProperty((XmlObject)r));
        this.properties.put(RPWriteable, new ImmutableResourceProperty((XmlObject)w));
        TransferMechanismDocument tmd = TransferMechanismDocument.Factory.newInstance();
        tmd.setTransferMechanism("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple");
        TransferMechanismDocument tmd2 = TransferMechanismDocument.Factory.newInstance();
        tmd2.setTransferMechanism("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/mtom");
        this.properties.put(RPTransferMechanisms, new ImmutableResourceProperty(new XmlObject[]{tmd}));
    }

    @Override
    public QName getPortType() {
        return portType;
    }
}

