/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts;

import de.fzj.unicore.uas.fts.FileTransferImpl;
import de.fzj.unicore.uas.fts.ProtocolRP;
import de.fzj.unicore.uas.fts.SourceResourceProperty;
import de.fzj.unicore.uas.fts.StatusResourceProperty;
import de.fzj.unicore.uas.fts.TargetResourceProperty;
import de.fzj.unicore.uas.fts.TransferRateResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.U6FileTransferBase;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.messaging.ResourceDeletedMessage;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.SourceTargetType;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.x2006.x04.services.fts.ScheduledStartTimeDocument;
import org.unigrids.x2006.x04.services.fts.TransferRateDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ServerToServerFileTransferImpl
extends FileTransferImpl {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", ServerToServerFileTransferImpl.class);
    private transient IFileTransfer ft;
    static final Map<String, IFileTransfer> map = new ConcurrentHashMap<String, IFileTransfer>();
    @Persist
    private long scheduledStartTime = 0L;
    @Persist
    private boolean reliableMode = false;
    @Persist
    protected Client client;
    public static final String PARAM_SCHEDULED_START = "scheduledStartTime";
    public static final String INIT_RELIABLE = "reliableMode";
    private static DateFormat format = null;

    @Override
    public void initialise(String sname, Map<String, Object> map) throws Exception {
        String startTime;
        super.initialise(sname, map);
        this.properties.put(RPStatus, new StatusResourceProperty(null, (ResourceImpl)this));
        String string = startTime = this.extraParameters != null ? (String)this.extraParameters.get(PARAM_SCHEDULED_START) : null;
        if (startTime != null) {
            try {
                this.scheduledStartTime = ServerToServerFileTransferImpl.parseDate(startTime);
                logger.info((Object)("Filetransfer scheduled to start at " + startTime));
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("Could not parse supplied scheduledStartTime as a date", ex);
            }
        }
        this.reliableMode = Boolean.TRUE.equals(map.get(INIT_RELIABLE));
        this.client = AuthZAttributeStore.getClient();
        this.overWrite = true;
        this.createTransfer(IFileTransfer.OverwritePolicy.OVERWRITE);
        this.properties.put(TransferRateDocument.type.getDocumentElementName(), new TransferRateResourceProperty((ResourceImpl)this));
        this.startFileTransfer();
    }

    @Override
    public void customPostActivate() {
        this.ft = map.get(this.getUniqueID());
        if (this.ft != null) {
            IFileTransfer.Status s = this.ft.getStatus();
            if (s.equals((Object)IFileTransfer.Status.FAILED)) {
                this.status = 5;
                this.description = this.ft.getStatusMessage();
            } else if (s.equals((Object)IFileTransfer.Status.DONE)) {
                this.status = 4;
                this.description = "File transfer done.";
            } else {
                this.setOK();
            }
        }
    }

    protected boolean isFinished() {
        return this.status == 4 || this.status == 5;
    }

    protected void checkRestart() {
        if (!this.isFinished() && map.get(this.getUniqueID()) == null) {
            logger.info((Object)("Attempting to recover file transfer " + this.toString() + (this.client != null ? " for " + this.client.getDistinguishedName() : "")));
            try {
                AuthZAttributeStore.setClient((Client)this.client);
                this.createTransfer(IFileTransfer.OverwritePolicy.RESUME_FAILED_TRANSFER);
                this.startFileTransfer();
            }
            catch (Exception ex) {
                this.status = 5;
                this.description = "Failed (during restart, error message: " + ex.getMessage() + ")";
                Log.logException((String)("Attempt to restart server-to-server file transfer " + this.getUniqueID() + " failed"), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (!this.isFinished()) {
            try {
                this.ft = map.get(this.getUniqueID());
                if (this.ft != null) {
                    logger.info((Object)("Aborting filetransfer " + this.getUniqueID() + " for client " + this.getClient().getDistinguishedName()));
                    this.ft.abort();
                }
            }
            catch (Exception e) {
                LogUtil.logException((String)"Problem cleaning up filetransfer.", (Throwable)e, (Logger)logger);
            }
            finally {
                map.remove(this.getUniqueID());
            }
        }
        try {
            ResourceDeletedMessage m = new ResourceDeletedMessage((Serializable)((Object)("deleted:" + this.getUniqueID())));
            m.setServiceName(this.getServiceName());
            m.setDeletedResource(this.getUniqueID());
            this.getKernel().getMessaging().getChannel(WSUtilities.extractResourceID((EndpointReferenceType)this.parentEPR)).publish((Message)m);
        }
        catch (Exception ex) {
            LogUtil.logException((String)"Problem notifying parent SMS.", (Throwable)ex, (Logger)logger);
        }
        super.destroy();
    }

    @Override
    public long getDataSize() {
        return this.ft != null ? this.ft.getDataSize() : -1L;
    }

    public long getTransferRate() {
        if (this.ft != null && this.ft instanceof U6FileTransferBase) {
            U6FileTransferBase u6ft = (U6FileTransferBase)this.ft;
            long dataSize = this.getDataSize();
            long consumedMillis = u6ft.getElapsedTime();
            if (dataSize > 0L && consumedMillis > 0L) {
                return 1000L * dataSize / consumedMillis;
            }
        }
        return -1L;
    }

    protected void createTransfer(IFileTransfer.OverwritePolicy policy) throws Exception {
        ProtocolType.Enum p;
        Configuration config = XNJSFacade.get(this.xnjsReference, this.kernel).getConfiguration();
        this.ft = this.isExport == false ? config.getFileTransferEngine().createFileImport(this.client, this.workdir, this.toURI(ServerToServerFileTransferImpl.urlEncode(this.source)), this.target, policy, null) : config.getFileTransferEngine().createFileExport(this.client, this.workdir, this.source, this.toURI(ServerToServerFileTransferImpl.urlEncode(this.target)), policy, null);
        map.put(this.getUniqueID(), this.ft);
        if (this.ft instanceof U6FileTransferBase) {
            ((U6FileTransferBase)this.ft).setStorageAdapter(this.getStorageAdapter());
            ((U6FileTransferBase)this.ft).setReliableMode(this.reliableMode);
        }
        if ((p = ProtocolType.Enum.forString((String)this.ft.getProtocol())) == null) {
            p = ProtocolType.OTHER;
        }
        this.properties.put(RPProtocol, new ProtocolRP(new ProtocolType.Enum[]{p}));
    }

    protected void startFileTransfer() {
        Calendar c = Calendar.getInstance();
        long delay = this.scheduledStartTime - System.currentTimeMillis();
        ScheduledStartTimeDocument sd = ScheduledStartTimeDocument.Factory.newInstance();
        if (delay > 20000L) {
            c.add(14, (int)delay);
        }
        sd.setScheduledStartTime(c);
        ImmutableResourceProperty rp = new ImmutableResourceProperty((XmlObject)sd);
        this.properties.put(ScheduledStartTimeDocument.type.getDocumentElementName(), rp);
        if (delay > 20000L) {
            this.kernel.getContainerProperties().getThreadingServices().getScheduledExecutorService().schedule((Runnable)this.ft, delay, TimeUnit.MILLISECONDS);
        } else {
            this.kernel.getContainerProperties().getThreadingServices().getExecutorService().execute((Runnable)this.ft);
        }
    }

    @Override
    protected Long getTransferredBytes() {
        if (this.ft != null) {
            this.transferredBytes = this.ft.getTransferredBytes();
        }
        return this.transferredBytes;
    }

    @Override
    protected boolean isExport() {
        return false;
    }

    @Override
    protected void initialiseSourceAndTarget(String rawsource, String rawtarget) {
        SourceTargetType stt = SourceTargetType.Factory.newInstance();
        stt.setURI(rawsource);
        this.properties.put(RPSource, new SourceResourceProperty(stt));
        this.source = rawsource;
        SourceTargetType stt2 = SourceTargetType.Factory.newInstance();
        stt2.setURI(rawtarget);
        this.properties.put(RPTarget, new TargetResourceProperty(stt2));
        this.target = rawtarget;
    }

    private static synchronized long parseDate(String s) throws ParseException {
        if (format == null) {
            format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }
        return format.parse(s).getTime();
    }
}

