/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts;

import de.fzj.unicore.uas.fts.DataResource;
import de.fzj.unicore.uas.fts.FileTransfer;
import de.fzj.unicore.uas.fts.ProtocolRP;
import de.fzj.unicore.uas.fts.SourceResourceProperty;
import de.fzj.unicore.uas.fts.StatusResourceProperty;
import de.fzj.unicore.uas.fts.TargetResourceProperty;
import de.fzj.unicore.uas.fts.TransferredBytesResourceProperty;
import de.fzj.unicore.uas.fts.UASSizeResourceProperty;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.StorageAdapterFactory;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.SourceTargetType;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.services.atomic.types.StorageEndpointReferenceDocument;
import org.unigrids.x2006.x04.services.fts.FileTransferPropertiesDocument;
import org.unigrids.x2006.x04.services.fts.StatusType;
import org.unigrids.x2006.x04.services.fts.SummaryType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class FileTransferImpl
extends UASWSResourceImpl
implements DataResource,
FileTransfer {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", FileTransferImpl.class);
    public static final String INIT_ACTIONID = "uas.filetransfer.impl.actionid";
    public static final String INIT_SOURCE = "uas.filetransfer.impl.source";
    public static final String INIT_TARGET = "uas.filetransfer.impl.target";
    public static final String INIT_IS_PIPE = "uas.filetransfer.impl.ispipe";
    public static final String INIT_PROTOCOL = "uas.filetransfer.impl.protocol";
    public static final String INIT_SMS_EPR = "uas.filetransfer.impl.sms";
    public static final String INIT_SMS_WORKDIR = "uas.filetransfer.impl.sms.wd";
    public static final String INIT_IS_EXPORT = "uas.filetransfer.impl.sms.isexport";
    public static final String INIT_OVERWRITE = "uas.filetransfer.impl.sms.overwrite";
    public static final String INIT_UMASK = "uas.filetransfer.impl.sms.umask";
    public static final String INIT_STORAGE_ADAPTER_FACTORY = "uas.filetransfer.impl.sms.storageadapterfactory";
    public static final String INIT_EXTRA_PARAMETERS = "uas.filetransfer.impl.extraparameters";
    public static final String CONFIG_PROTOCOL_KEY = "uas.filetransfer.protocol.";
    @Persist
    protected String source;
    @Persist
    protected String target;
    @Persist
    protected Boolean isPipe;
    @Persist
    protected ProtocolType.Enum protocol;
    @Persist
    protected EndpointReferenceType parentEPR;
    @Persist
    protected String workdir;
    @Persist
    protected Boolean firstWrite = Boolean.TRUE;
    @Persist
    protected Boolean isExport = null;
    @Persist
    protected Boolean overWrite = Boolean.TRUE;
    @Persist
    protected Long transferredBytes = 0L;
    @Persist
    protected Map<String, String> extraParameters = null;
    @Persist
    protected StorageAdapterFactory storageAdapterFactory;
    @Persist
    protected String umask;
    protected static final int STATUS_RUNNING = 3;
    protected static final int STATUS_DONE = 4;
    protected static final int STATUS_FAILED = 5;
    protected static final int STATUS_UNDEFINED = 1;
    protected static final int STATUS_READY = 2;
    @Persist
    protected int status = 1;
    @Persist
    protected String description = "";
    private static final QName portType = new QName("http://unigrids.org/2006/04/services/fts", "FileTransfer");

    @Override
    public QName getResourcePropertyDocumentQName() {
        return FileTransferPropertiesDocument.type.getDocumentElementName();
    }

    @Override
    public void initialise(String sname, Map<String, Object> map) throws Exception {
        super.initialise(sname, map);
        String rawsource = (String)map.get(INIT_SOURCE);
        String rawtarget = (String)map.get(INIT_TARGET);
        this.isPipe = (Boolean)map.get(INIT_IS_PIPE);
        this.protocol = (ProtocolType.Enum)map.get(INIT_PROTOCOL);
        this.parentEPR = (EndpointReferenceType)map.get(INIT_SMS_EPR);
        this.workdir = (String)map.get(INIT_SMS_WORKDIR);
        this.isExport = (Boolean)map.get(INIT_IS_EXPORT);
        Boolean o = (Boolean)map.get(INIT_OVERWRITE);
        if (o != null) {
            this.overWrite = o;
        }
        this.umask = (String)map.get(INIT_UMASK);
        this.extraParameters = (Map)map.get(INIT_EXTRA_PARAMETERS);
        this.properties.put(RPProtocol, new ProtocolRP(new ProtocolType.Enum[]{this.protocol}));
        this.properties.put(RPTransferred, new TransferredBytesResourceProperty(0L, (ResourceImpl)this));
        this.properties.put(RPStatus, new StatusResourceProperty(null, (ResourceImpl)this));
        StorageEndpointReferenceDocument parent = StorageEndpointReferenceDocument.Factory.newInstance();
        parent.setStorageEndpointReference(this.parentEPR);
        this.properties.put(RPParentSMS, new ImmutableResourceProperty((XmlObject)parent));
        this.initialiseSourceAndTarget(rawsource, rawtarget);
        this.properties.put(RPSize, new UASSizeResourceProperty(this));
        this.storageAdapterFactory = (StorageAdapterFactory)map.get(INIT_STORAGE_ADAPTER_FACTORY);
        if (this.isPipe.booleanValue() && !this.isExport()) {
            this.createFIFO();
        }
        logger.info((Object)("New file transfer: " + this.toString()));
    }

    protected void initialiseSourceAndTarget(String rawsource, String rawtarget) {
        SourceTargetType stt;
        if (rawsource != null) {
            stt = SourceTargetType.Factory.newInstance();
            stt.setURI(this.makeQualifiedURI(rawsource));
            this.properties.put(RPSource, new SourceResourceProperty(stt));
            this.source = rawsource;
        } else {
            this.properties.put(RPSource, new SourceResourceProperty(null));
        }
        if (rawtarget != null) {
            stt = SourceTargetType.Factory.newInstance();
            stt.setURI(this.makeQualifiedURI(rawtarget));
            this.properties.put(RPTarget, new TargetResourceProperty(stt));
            this.target = rawtarget;
        } else {
            this.properties.put(RPTarget, new TargetResourceProperty(null));
        }
    }

    protected boolean isExport() {
        return this.isExport;
    }

    protected IStorageAdapter getStorageAdapter() throws IOException {
        if (this.storageAdapterFactory != null) {
            IStorageAdapter adapter = this.storageAdapterFactory.createStorageAdapter(this);
            adapter.setUmask(this.umask);
            adapter.setStorageRoot(this.workdir);
            return adapter;
        }
        throw new IOException("No storage adaptor factory.");
    }

    @Override
    public long getDataSize() {
        String filename = this.source != null ? this.source : this.target;
        try {
            XnjsFileWithACL f = this.getStorageAdapter().getProperties(filename);
            if (f != null) {
                return f.getSize();
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)("Could not determine file size for <" + filename + ">"), (Throwable)e, (Logger)logger);
        }
        return 0L;
    }

    protected InputStream createNewInputStream() throws IOException, ExecutionException {
        InputStream is = this.getStorageAdapter().getInputStream(this.source);
        return is;
    }

    protected OutputStream createNewOutputStream(boolean append) throws IOException, ExecutionException {
        OutputStream os = this.getStorageAdapter().getOutputStream(this.target, append);
        return os;
    }

    protected void createFIFO() throws ExecutionException {
        TSI tsi = XNJSFacade.get(this.xnjsReference, this.kernel).getTSI(this.getClient());
        tsi.setStorageRoot(this.workdir);
        tsi.mkfifo(this.target);
    }

    protected void destroyFIFO() throws ExecutionException {
        TSI tsi = XNJSFacade.get(this.xnjsReference, this.kernel).getTSI(this.getClient());
        tsi.setStorageRoot(this.workdir);
        tsi.rm(this.target);
    }

    public void destroy() {
        if (this.isPipe.booleanValue() && !this.isExport()) {
            try {
                logger.info((Object)"Removing fifo...");
                this.destroyFIFO();
            }
            catch (Exception e) {
                Log.logException((String)("Can't destroy fifo <" + this.target + ">"), (Throwable)e, (Logger)logger);
            }
        }
        super.destroy();
    }

    protected String makeQualifiedURI(String path) {
        String prefix = this.protocol.toString().toLowerCase() + ":" + this.parentEPR.getAddress().getStringValue() + "#";
        return FileTransferImpl.urlEncode(prefix + path);
    }

    public static String urlEncode(String orig) {
        try {
            return orig.replaceAll(" ", "%20");
        }
        catch (Exception e) {
            logger.error((Object)e);
            return orig;
        }
    }

    protected URI toURI(String path) throws URISyntaxException {
        URI uri = new URI(path);
        return uri;
    }

    protected Long getTransferredBytes() {
        return this.transferredBytes;
    }

    protected StatusType getStatus() {
        StatusType ret = StatusType.Factory.newInstance();
        ret.setSummary(SummaryType.Enum.forInt((int)this.status));
        ret.setDescription(this.description);
        return ret;
    }

    protected void setReady() {
        this.status = 2;
        this.description = "Ready.";
    }

    protected void setOK() {
        this.status = 3;
        this.description = "OK.";
    }

    public String toString() {
        Client cl;
        StringBuilder sb = new StringBuilder();
        if (this.source != null) {
            sb.append(" from '").append(this.source).append("'");
        }
        if (this.target != null) {
            sb.append(" to '").append(this.target).append("'");
        }
        if ((cl = this.getClient()) != null && cl.getDistinguishedName() != null) {
            sb.append(" for ").append(cl.getDistinguishedName());
        }
        sb.append(" protocol=").append(this.protocol);
        sb.append(" isExport=").append(this.isExport);
        sb.append(" overwrite=").append(this.overWrite);
        sb.append(" workdir=").append(this.workdir);
        sb.append(" isPipe=").append(this.isPipe);
        sb.append(" myAddress=").append(this.getEPR().getAddress().getStringValue());
        return sb.toString();
    }

    public QName getPortType() {
        return portType;
    }
}

