/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts;

import de.fzj.unicore.uas.fts.FileTransferCapability;
import de.fzj.unicore.uas.fts.FileTransferImpl;
import de.fzj.unicore.uas.fts.byteio.RandomByteIOImpl;
import de.fzj.unicore.uas.fts.byteio.StreamableByteIOImpl;
import de.fzj.unicore.uas.fts.http.HttpFileTransferImpl;
import de.fzj.unicore.uas.xnjs.BFTExport;
import de.fzj.unicore.uas.xnjs.BFTImport;
import de.fzj.unicore.uas.xnjs.RByteIOExport;
import de.fzj.unicore.uas.xnjs.RByteIOImport;
import de.fzj.unicore.uas.xnjs.SByteIOExport;
import de.fzj.unicore.uas.xnjs.SByteIOImport;
import de.fzj.unicore.uas.xnjs.U6FileTransferBase;
import de.fzj.unicore.wsrflite.Capabilities;
import de.fzj.unicore.wsrflite.Capability;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class FileTransferCapabilities {
    private static final Map<String, FileTransferCapability> filetransferCapabilities = new HashMap<String, FileTransferCapability>();
    public static FileTransferCapability BFT = new FileTransferCapability(){

        @Override
        public String getProtocol() {
            return "BFT";
        }

        public Class<?> getImplementation() {
            return HttpFileTransferImpl.class;
        }

        public Class<?> getInterface() {
            return FileTransferImpl.class;
        }

        @Override
        public Class<? extends U6FileTransferBase> getExporter() {
            return BFTExport.class;
        }

        @Override
        public Class<? extends U6FileTransferBase> getImporter() {
            return BFTImport.class;
        }
    };
    public static FileTransferCapability RBYTEIO = new FileTransferCapability(){

        @Override
        public String getProtocol() {
            return "RBYTEIO";
        }

        public Class<?> getImplementation() {
            return RandomByteIOImpl.class;
        }

        public Class<?> getInterface() {
            return FileTransferImpl.class;
        }

        @Override
        public Class<? extends U6FileTransferBase> getExporter() {
            return RByteIOExport.class;
        }

        @Override
        public Class<? extends U6FileTransferBase> getImporter() {
            return RByteIOImport.class;
        }
    };
    public static FileTransferCapability SBYTEIO = new FileTransferCapability(){

        @Override
        public String getProtocol() {
            return "SBYTEIO";
        }

        public Class<?> getImplementation() {
            return StreamableByteIOImpl.class;
        }

        public Class<?> getInterface() {
            return FileTransferImpl.class;
        }

        @Override
        public Class<? extends U6FileTransferBase> getExporter() {
            return SByteIOExport.class;
        }

        @Override
        public Class<? extends U6FileTransferBase> getImporter() {
            return SByteIOImport.class;
        }
    };

    public static FileTransferImpl getFileTransferImpl(String protocol) throws Exception {
        FileTransferCapability cp = FileTransferCapabilities.getCapability(protocol);
        String clazz = cp.getImplementation().getName();
        return (FileTransferImpl)Class.forName(clazz).newInstance();
    }

    public static synchronized FileTransferCapability getCapability(String protocol) {
        FileTransferCapability result = filetransferCapabilities.get(protocol);
        if (result == null) {
            FileTransferCapabilities.loadCapabilities();
            result = filetransferCapabilities.get(protocol);
        }
        return result;
    }

    private static void loadCapabilities() {
        ServiceLoader<Capabilities> sl = ServiceLoader.load(Capabilities.class);
        Iterator<Capabilities> iter = sl.iterator();
        while (iter.hasNext()) {
            Capability[] cs = iter.next().getCapabilities();
            for (int j = 0; j < cs.length; ++j) {
                Capability c = cs[j];
                if (!(c instanceof FileTransferCapability)) continue;
                FileTransferCapability ftc = (FileTransferCapability)c;
                filetransferCapabilities.put(ftc.getProtocol(), ftc);
            }
        }
    }

    public static synchronized String[] getProtocols() {
        if (filetransferCapabilities.size() == 0) {
            FileTransferCapabilities.loadCapabilities();
        }
        int l = filetransferCapabilities.size();
        String[] res = new String[l];
        int i = 0;
        for (FileTransferCapability fc : filetransferCapabilities.values()) {
            res[i] = fc.getProtocol();
            ++i;
        }
        return res;
    }
}

