/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.admin;

import de.fzj.unicore.uas.admin.UASAdminMBean;
import de.fzj.unicore.uas.impl.tss.TargetSystemHomeImpl;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.legacy.LegacyTSI;
import de.fzj.unicore.xnjs.legacy.TSIConnectionFactory;
import de.fzj.unicore.xnjs.simple.LocalTS;

public class UASAdmin
implements UASAdminMBean {
    private final Kernel useKernel;

    public UASAdmin(Kernel useKernel) {
        this.useKernel = useKernel;
    }

    @Override
    public String getTSIConnectionStatus() {
        try {
            if (this.useKernel.getHome("TargetSystemService") == null) {
                return "N/A";
            }
            String tsiClass = XNJSFacade.get(null, this.useKernel).getConfiguration().getProperty("XNJS.tsiclass");
            if (LegacyTSI.class.getName().equals(tsiClass)) {
                TSIConnectionFactory tsif = (TSIConnectionFactory)XNJSFacade.get(null, this.useKernel).getConfiguration().getComponentInstanceOfType(TSIConnectionFactory.class);
                return tsif.getConnectionStatus();
            }
            if (tsiClass == null || LocalTS.class.getName().equals(tsiClass)) {
                return "OK [using embedded TSI]";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "N/A";
    }

    @Override
    public String isJobSubmissionEnabled() {
        return String.valueOf(((TargetSystemHomeImpl)this.useKernel.getHome("TargetSystemService")).isJobSubmissionEnabled());
    }

    @Override
    public void toggleJobSubmissionEnabled() {
        TargetSystemHomeImpl th;
        boolean enabled = (th = (TargetSystemHomeImpl)this.useKernel.getHome("TargetSystemService")).isJobSubmissionEnabled();
        th.setJobSubmissionEnabled(!enabled);
    }
}

