/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.admin;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Service;
import de.fzj.unicore.wsrflite.admin.AdminAction;
import de.fzj.unicore.wsrflite.admin.AdminActionResult;
import de.fzj.unicore.wsrflite.impl.DefaultHome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ShowServerUsageOverview
implements AdminAction {
    public String getName() {
        return "ShowServerUsageOverview";
    }

    public AdminActionResult invoke(Map<String, String> params, Kernel kernel) {
        String requestedDN = params.get("clientDN");
        boolean success = true;
        String message = requestedDN != null ? "Retrieving usage for users matching '" + requestedDN + "'" : "Usage by all users";
        AdminActionResult res = new AdminActionResult(success, message);
        Map<Object, Object> merged = new HashMap();
        ArrayList<String> serviceNames = new ArrayList<String>();
        ArrayList<Map> instPerDN = new ArrayList<Map>();
        for (Service service : kernel.getServices()) {
            DefaultHome home = (DefaultHome)service.getHome();
            if (home == null) continue;
            Map perDN = home.getInstancesPerUser();
            String serviceName = home.getServiceName();
            serviceNames.add(serviceName);
            instPerDN.add(perDN);
        }
        merged = this.merge(requestedDN, serviceNames, instPerDN.toArray(new Map[instPerDN.size()]));
        for (String string : merged.keySet()) {
            Map perService = (Map)merged.get(string);
            StringBuilder sb = new StringBuilder();
            for (String serviceName : perService.keySet()) {
                Integer num = (Integer)perService.get(serviceName);
                if (num == null || num <= 0) continue;
                sb.append(serviceName).append(": ").append(num).append(" ");
            }
            res.addResult(string, sb.toString());
        }
        return res;
    }

    Map<String, Map<String, Integer>> merge(String requestedDN, List<String> serviceNames, Map<String, AtomicInteger> ... perDNInstances) {
        HashMap<String, Map<String, Integer>> merged = new HashMap<String, Map<String, Integer>>();
        for (int i = 0; i < serviceNames.size(); ++i) {
            Map<String, AtomicInteger> instPerDN = perDNInstances[i];
            String serviceName = serviceNames.get(i);
            for (String dn : instPerDN.keySet()) {
                Number n;
                if (requestedDN != null && !dn.contains(requestedDN)) continue;
                HashMap<String, Integer> instPerService = (HashMap<String, Integer>)merged.get(dn);
                if (instPerService == null) {
                    instPerService = new HashMap<String, Integer>();
                }
                int num = (n = (Number)instPerDN.get(dn)) != null ? n.intValue() : 0;
                instPerService.put(serviceName, num);
                merged.put(dn, instPerService);
            }
        }
        return merged;
    }

    public String getDescription() {
        return "parameters: [clientDN]";
    }
}

