/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.admin;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.admin.AdminAction;
import de.fzj.unicore.wsrflite.admin.AdminActionResult;
import de.fzj.unicore.xnjs.ems.Action;
import eu.unicore.util.Log;
import java.util.Map;

public class ShowJobDetails
implements AdminAction {
    public String getName() {
        return "ShowJobDetails";
    }

    public AdminActionResult invoke(Map<String, String> params, Kernel kernel) {
        String requestedID = params.get("jobID");
        String xnjsReference = params.get("xnjsReference");
        boolean success = true;
        String message = "Job information for " + requestedID;
        if (xnjsReference != null) {
            message = message + " on XNJS " + xnjsReference;
        }
        StringBuilder info = new StringBuilder();
        try {
            Action a = XNJSFacade.get(xnjsReference, kernel).getAction(requestedID);
            if (a != null) {
                info.append(a.toString());
                info.append("Processing context: ");
                info.append(a.getProcessingContext());
                if (a.getApplicationInfo() != null) {
                    info.append("\nApplication Info: ");
                    info.append(a.getApplicationInfo());
                }
                info.append("\nJob log: ");
                for (String l : a.getLog()) {
                    info.append("\n").append(l);
                }
            } else {
                info.append("No such job!");
            }
        }
        catch (Exception ex) {
            success = false;
            message = Log.createFaultMessage((String)"Getting info failed", (Throwable)ex);
        }
        AdminActionResult res = new AdminActionResult(success, message);
        res.addResult("Info", info.toString());
        return res;
    }

    public String getDescription() {
        return "parameters: jobID, [xnjsReference]";
    }
}

