/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas;

import de.fzj.unicore.uas.SMSFactoryProperties;
import de.fzj.unicore.uas.SMSProperties;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageInfoProvider;
import de.fzj.unicore.uas.impl.sms.StorageManagementHomeImpl;
import de.fzj.unicore.uas.impl.sms.StorageSharingMode;
import de.fzj.unicore.uas.metadata.MetadataManager;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyChangeListener;
import eu.unicore.util.configuration.PropertyMD;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class UASProperties
extends PropertiesHelper {
    private static final Logger log = Log.getLogger((String)"unicore.configuration", UASProperties.class);
    @DocumentationReferencePrefix
    public static final String PREFIX = "coreServices.";
    public static final String TSF_XNJS_CONFIGFILE = "targetsystemfactory.xnjs.configfile";
    public static final String TSS_DISABLE_HOME_PROPERTY = "targetsystem.homeDisable";
    public static final String TSS_FORCE_UNIQUE_STORAGE_IDS = "targetsystem.uniqueStorageIds";
    public static final String SMS_PROTOCOLS = "sms.protocols";
    public static final String SMS_LS_LIMIT = "sms.lsLimit";
    public static final String SMS_ENABLED_ADDON_STORAGES = "targetsystem.enabledStorages";
    public static final String SMS_ADDON_STORAGE_PREFIX = "targetsystem.storage.";
    public static final String SMS_FACTORY_PREFIX = "sms.factory.";
    public static final String SMS_ENABLED_FACTORIES = "sms.enabledFactories";
    public static final String SMS_GROUP_SHARING_MODE = "sms.sharingMode";
    public static final String SMS_TRANSFER_FORCEREMOTE = "filetransfer.forceremote";
    public static final String SMS_DIRECT_FILETRANSFER = "filetransfer.direct";
    public static final String SMS_STAGING_MAXTHREADS = "filetransfer.maxthreads";
    public static final String FTS_HTTP_PREFER_POST = "filetransfer.httpPreferPost";
    public static final String DEFSMS_WORKDIR = "defaultsms.workdir";
    public static final String DEFSMS_CLASS = "defaultsms.class";
    public static final String DEFSMS_NAME = "defaultsms.name";
    public static final String DEFSMS_CONF_PROTOCOLS = "defaultsms.protocols";
    public static final String METADATA_MANAGER_CLASSNAME = "metadata.managerClass";
    public static final String GRIDBEAN_DIR = "gridbean.directory";
    private Collection<StorageDescription> addOnStorages;
    private Map<String, StorageDescription> factories = this.parseStorages("sms.factory.", "sms.enabledFactories", true);
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();

    public UASProperties(Properties properties) throws ConfigurationException, IOException {
        super(PREFIX, properties, META, log);
        this.addOnStorages = this.parseStorages(SMS_ADDON_STORAGE_PREFIX, SMS_ENABLED_ADDON_STORAGES, false).values();
        this.addPropertyChangeListener(new PropertyChangeListener(){
            private final String[] PROPS = new String[]{"targetsystem.storage.", "sms.factory."};

            public void propertyChanged(String propertyKey) {
                if (propertyKey.equals(UASProperties.SMS_ADDON_STORAGE_PREFIX)) {
                    UASProperties.this.updateStorages(UASProperties.this.addOnStorages, UASProperties.SMS_ADDON_STORAGE_PREFIX, false);
                } else if (propertyKey.equals(UASProperties.SMS_FACTORY_PREFIX)) {
                    UASProperties.this.updateStorages(UASProperties.this.factories.values(), UASProperties.SMS_FACTORY_PREFIX, true);
                }
            }

            public String[] getInterestingProperties() {
                return this.PROPS;
            }
        });
    }

    protected void checkConstraints() throws ConfigurationException {
        super.checkConstraints();
        this.parseStorages(SMS_FACTORY_PREFIX, SMS_ENABLED_FACTORIES, true);
        this.parseStorages(SMS_ADDON_STORAGE_PREFIX, SMS_ENABLED_ADDON_STORAGES, false);
    }

    public Collection<StorageDescription> getAddonStorages() {
        return this.addOnStorages;
    }

    public Map<String, StorageDescription> getStorageFactories() {
        return this.factories;
    }

    private void updateStorages(Collection<StorageDescription> storages, String prefixComponent, boolean factory) {
        for (StorageDescription storage : storages) {
            String pfx = prefixComponent + storage.getId() + ".";
            SMSProperties smsProps = factory ? new SMSFactoryProperties(pfx, this.properties) : new SMSProperties(pfx, this.properties);
            storage.update(smsProps.getValue("protocols"), smsProps.getBooleanValue("filterFiles"), smsProps.getBooleanValue("cleanup"), smsProps.getValue("defaultUmask"), smsProps.getValue("description"), smsProps.getExtraSettings());
        }
    }

    private Map<String, StorageDescription> parseStorages(String prefixComponent, String enabledKey, boolean factory) {
        String enabledV = this.getValue(enabledKey);
        Set<String> storageIds = UASProperties.getStorageIds(enabledV, prefixComponent, this.properties);
        HashMap<String, StorageDescription> ret = new HashMap<String, StorageDescription>();
        for (String id : storageIds) {
            String pfx = PREFIX + prefixComponent + id + ".";
            SMSProperties smsProps = factory ? new SMSFactoryProperties(pfx, this.properties) : new SMSProperties(pfx, this.properties);
            StorageDescription asd = new StorageDescription(id, smsProps.getValue("name"), smsProps.getValue("path"), (StorageManagementHomeImpl.StorageTypes)smsProps.getEnumValue("type", StorageManagementHomeImpl.StorageTypes.class), smsProps.getClassValue("class", StorageManagement.class), smsProps.getValue("protocols"), smsProps.getBooleanValue("filterFiles"), smsProps.getBooleanValue("cleanup"), smsProps.getBooleanValue("disableMetadata"), smsProps.getValue("defaultUmask"), smsProps.getValue("description"), smsProps.getExtraSettings());
            if (factory) {
                asd.setInfoProviderClass(smsProps.getClassValue("infoProviderClass", StorageInfoProvider.class));
            }
            ret.put(id, asd);
        }
        return ret;
    }

    public static Set<String> getStorageIds(String enabledTypesV, String prefixComponent, Properties properties) {
        boolean useAll = false;
        HashSet enabledTypes = null;
        if (enabledTypesV == null) {
            useAll = true;
        } else {
            String[] enabledTypesA = enabledTypesV.trim().split(" +");
            enabledTypes = new HashSet(enabledTypesA.length);
            Collections.addAll(enabledTypes, enabledTypesA);
        }
        String pfx = PREFIX + prefixComponent;
        HashSet<String> ret = new HashSet<String>();
        for (Object k : properties.keySet()) {
            String id;
            String key = ((String)k).trim();
            if (!key.startsWith(pfx) || key.length() < pfx.length() || !(id = key.substring(pfx.length())).contains(".") || (id = id.substring(0, id.indexOf(46))).length() == 0) continue;
            if (!useAll && !enabledTypes.contains(id)) {
                log.debug((Object)("Skipping storage definition " + id + " as it is not enabled."));
                continue;
            }
            ret.add(id);
        }
        return ret;
    }

    static {
        META.put(TSS_DISABLE_HOME_PROPERTY, new PropertyMD("false").setDescription("Whether to disable a SMS providing access to the user's home directory."));
        META.put(TSS_FORCE_UNIQUE_STORAGE_IDS, new PropertyMD("false").setDescription("Whether to use unique identifiers for all storages. If set to true, the storages attached to a TSS will always have unique IDs. In the default case, storage names will be formed from the user's xlogin and the storage name, e.g. 'a.user-Home'. Unique identifiers are long and not possible to be predicted but are needed if many grid users are mapped to the same local account."));
        META.put(SMS_PROTOCOLS, new PropertyMD("BFT RBYTEIO SBYTEIO").setUpdateable().setDescription("Space separated list of the default file transport protocols supported by SMSes."));
        META.put(SMS_TRANSFER_FORCEREMOTE, new PropertyMD("false").setDescription("When doing file transfers, UNICORE tries to detect whether two storage resources are accessing the same (local) filesystem. If yes, the transfer is done by direct copying. Set to 'true' to disable this feature."));
        META.put(SMS_DIRECT_FILETRANSFER, new PropertyMD("false").setDescription("If set to 'true', UNICORE/X will attempt to bypass the gateway for filetransfers. Note: there are firewall and security implications!"));
        META.put(SMS_STAGING_MAXTHREADS, new PropertyMD("10").setDescription("The maximum number of file transfer threads."));
        META.put(SMS_LS_LIMIT, new PropertyMD("50000").setBounds(1L, 50000L).setDescription("Controls the default amount of ListDirectory results which are returned in a single query."));
        META.put(SMS_ENABLED_ADDON_STORAGES, new PropertyMD((String)null).setDescription("Space separated list of names of enabled additional storages. If this property is left undefined then all defined storages are enabled. If this property value is empty then all are disabled."));
        META.put(SMS_ADDON_STORAGE_PREFIX, new PropertyMD().setCanHaveSubkeys().setDescription("Properties with this prefix are used to configure additional storages. See documentation of TargetSystem storages for details."));
        META.put(SMS_FACTORY_PREFIX, new PropertyMD().setCanHaveSubkeys().setDescription("Properties with this prefix are used to configure storage factories. See documentation of storage factories for details."));
        META.put(SMS_ENABLED_FACTORIES, new PropertyMD((String)null).setDescription("Space separated list of names of enabled storage factories.  If this property is left undefined then all defined factories are enabled. If this property value is empty then all are disabled."));
        META.put(SMS_GROUP_SHARING_MODE, new PropertyMD((Enum)StorageSharingMode.DISABLED).setDescription("How the group sharing of files is implemented. In the CHMOD files can be shared within one group only, but this is supported by most storages. The ACL implementation allows for sharing between multiple groups, but ACLs must be supported by the storage."));
        META.put(FTS_HTTP_PREFER_POST, new PropertyMD("false").setDescription("Controls whether to use HTTP POST for the HTTP filetransfers."));
        META.put(TSF_XNJS_CONFIGFILE, new PropertyMD().setPath().setDescription("The path or the XNJS config file."));
        META.put(METADATA_MANAGER_CLASSNAME, new PropertyMD().setClass(MetadataManager.class).setDescription("Metadata manager class name."));
        META.put(DEFSMS_CLASS, new PropertyMD().setClass(StorageManagement.class).setDescription("Class name providing implementation of the default SMS. If not set then default SMS is set to 'VARIABLE' SMS type."));
        META.put(DEFSMS_NAME, new PropertyMD("SHARE").setDescription("Name of the default SMS."));
        META.put(DEFSMS_WORKDIR, new PropertyMD().setDescription("Working directory of the default SMS. If not set, then system's default temp directory is used."));
        META.put(DEFSMS_CONF_PROTOCOLS, new PropertyMD().setDescription("Space separated list of the file transport protocols supported by the default SMS."));
        META.put(GRIDBEAN_DIR, new PropertyMD().setPath().setDescription("The path where GridBeans for the GridBeanService are stored."));
        META.put("metadata.", new PropertyMD().setHidden().setCanHaveSubkeys());
        META.put("uftp.", new PropertyMD().setHidden().setCanHaveSubkeys());
        META.put("dsms.", new PropertyMD().setHidden().setCanHaveSubkeys());
        META.put("bes.", new PropertyMD().setHidden().setCanHaveSubkeys());
        META.put("cip.", new PropertyMD().setHidden().setCanHaveSubkeys());
        META.put("hadoop.", new PropertyMD().setHidden().setCanHaveSubkeys());
        META.put("udt.", new PropertyMD().setHidden().setCanHaveSubkeys());
        META.put("uftp.", new PropertyMD().setHidden().setCanHaveSubkeys());
        META.put("xtreemfs.", new PropertyMD().setHidden().setCanHaveSubkeys());
        META.put("extension.", new PropertyMD().setHidden().setCanHaveSubkeys());
    }
}

