/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas;

import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.admin.UASAdmin;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.USEContainer;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHandler;
import eu.unicore.util.configuration.UpdateableConfiguration;
import java.util.Properties;

public class UAS
extends USEContainer {
    public static final String TSF = "TargetSystemFactoryService";
    public static final String TSS = "TargetSystemService";
    public static final String JMS = "JobManagement";
    public static final String SMS = "StorageManagement";
    public static final String SMF = "StorageFactory";
    public static final String RESERVATIONS = "ReservationManagement";
    public static final String ENUMERATION = "Enumeration";
    public static final String META = "MetadataManagement";
    public static final String TASK = "Task";
    public static final String FTS_BASE = "FileTransfer";
    public static final String[] AUTO_NEGOTIATE_FT_PROTOCOL = new String[]{"u6", "unicore6", "unicore"};
    private UASAdmin jmxBean;
    private UASProperties uasProperties;

    public UAS(String configFile) throws Exception {
        super(configFile, "UNICORE/X");
        this.initCommon();
    }

    public UAS(Properties properties) throws Exception {
        super(properties, "UNICORE/X");
        this.initCommon();
    }

    private void initCommon() throws Exception {
        this.uasProperties = new UASProperties(this.kernel.getContainerProperties().getRawProperties());
        this.kernel.addConfigurationHandler(UASProperties.class, (UpdateableConfiguration)this.uasProperties);
        this.jmxBean = new UASAdmin(this.kernel);
        Kernel.addMBean((Object)this.jmxBean, (String)"UNICORE/X");
    }

    public String getConnectionStatus() {
        if (!this.kernel.getContainerProperties().getBooleanValue("onstartupSelftest").booleanValue()) {
            return "";
        }
        StringBuilder report = new StringBuilder();
        report.append(super.getConnectionStatus());
        String newline = System.getProperty("line.separator");
        report.append(newline);
        report.append("Registry connection: ");
        RegistryHandler handler = (RegistryHandler)this.kernel.getAttribute(RegistryHandler.class);
        report.append(handler.getRegistryConnectionStatus());
        report.append(newline);
        if (this.kernel.getHome(TSS) != null) {
            report.append("TSI connection: ");
            report.append(this.jmxBean.getTSIConnectionStatus());
            report.append(newline);
        }
        return report.toString();
    }

    public static void main(String[] args) throws Exception {
        try {
            System.out.println("Reading config from " + args[0]);
            UAS uas = new UAS(args[0]);
            uas.startSynchronous();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("ERROR during server startup, server NOT started.");
            System.exit(1);
        }
    }
}

