/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.metrix.stats;

import de.fzj.unicore.metrix.IMetric;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics
implements Runnable {
    private final List<IMetric<?>> metrics = new ArrayList();
    private final File statsFile;
    private long startTime;
    private boolean isBuffering = true;
    private int bufferSize = 131072;
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

    public void start() throws IOException {
        this.writeHeader();
        this.startTime = System.currentTimeMillis();
    }

    public void stop() throws IOException {
        this.flush();
    }

    @Override
    public void run() {
        try {
            this.writeSnapshot();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void writeHeader() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.statsFile, true);
        OutputStreamWriter fw = new OutputStreamWriter(fos);
        try {
            fw.write("Time(ms)");
            for (IMetric<?> m : this.metrics) {
                fw.write(" , ");
                fw.write(m.getName());
            }
            fw.write("\n");
            fw.flush();
        }
        finally {
            fw.close();
        }
    }

    public synchronized void writeSnapshot() throws IOException {
        OutputStream fos = this.getStream();
        OutputStreamWriter fw = new OutputStreamWriter(fos);
        try {
            fw.write(String.valueOf(System.currentTimeMillis() - this.startTime));
            for (IMetric<?> m : this.metrics) {
                fw.write(" , ");
                fw.write(String.valueOf(m.getResult()));
            }
            fw.write("\n");
            if (this.isBuffering && this.bos.size() > this.bufferSize) {
                this.flush();
            }
        }
        finally {
            fw.close();
        }
    }

    public synchronized void flush() throws IOException {
        if (!this.isBuffering) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(this.statsFile, true);
        fos.write(this.bos.toByteArray());
        fos.close();
        this.bos.reset();
    }

    protected OutputStream getStream() throws IOException {
        if (this.isBuffering) {
            return this.bos;
        }
        return new FileOutputStream(this.statsFile, true);
    }

    public Statistics(File statsFile) {
        this.statsFile = statsFile;
    }

    public synchronized void registerMetric(IMetric<?> metric) {
        this.metrics.add(metric);
    }

    public boolean isBuffering() {
        return this.isBuffering;
    }

    public void setBuffering(boolean isBuffering) {
        this.isBuffering = isBuffering;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

