/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.metrix;

import de.fzj.unicore.metrix.Category;
import de.fzj.unicore.metrix.IMetric;
import de.fzj.unicore.metrix.exceptions.MetricIDAlreadyExistsException;
import de.fzj.unicore.metrix.management.jmx.Metrics;
import de.fzj.unicore.metrix.metrics.SystemInfo;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricRegistry {
    private static MetricRegistry theInstance;
    private Map<String, IMetric<?>> metrics = new HashMap();
    private Map<String, Category> categories = new HashMap<String, Category>();
    private ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(10);

    private MetricRegistry() {
        SystemInfo s = new SystemInfo();
        try {
            this.registerMetric(s);
        }
        catch (MetricIDAlreadyExistsException metricIDAlreadyExistsException) {
            // empty catch block
        }
    }

    public static synchronized MetricRegistry getInstance() {
        if (theInstance == null) {
            theInstance = new MetricRegistry();
        }
        return theInstance;
    }

    private void initJMX(Category category) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName adminName = null;
        Metrics adminBean = new Metrics(category);
        adminName = new ObjectName("Metrics:name=" + category.getName());
        if (!mbs.isRegistered(adminName)) {
            mbs.registerMBean(adminBean, adminName);
        }
    }

    public void registerMetric(IMetric<?> metric) throws MetricIDAlreadyExistsException {
        String[] metricCategories = metric.getCategories();
        String metricId = metric.getName();
        int i = 0;
        while (i < metricCategories.length) {
            if (this.categories.containsKey(metricCategories[i])) {
                Category category = this.categories.get(metricCategories[i]);
                category.addMetric(metricId, metric);
                metric.registerCategory(category);
            } else {
                Category newCategory = new Category(metricCategories[i]);
                newCategory.addMetric(metric.getName(), metric);
                this.categories.put(metricCategories[i], newCategory);
                metric.registerCategory(newCategory);
                try {
                    this.initJMX(newCategory);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++i;
        }
        if (!this.metrics.containsKey(metricId)) {
            this.metrics.put(metricId, metric);
        }
    }

    public synchronized void unregisterMetric(String metricID) {
        String[] metricCategories;
        IMetric<?> metric = this.metrics.get(metricID);
        String[] stringArray = metricCategories = metric.getCategories();
        int n = metricCategories.length;
        int n2 = 0;
        while (n2 < n) {
            String cat = stringArray[n2];
            Category category = this.categories.get(cat);
            if (category != null) {
                category.removeMetric(metric);
            }
            ++n2;
        }
        this.metrics.remove(metricID);
    }

    public synchronized void unregisterCategory(String categoryName) {
        this.categories.remove(categoryName);
    }

    public String[] getMetricIDs() {
        String[] metricIDs = new String[this.metrics.size()];
        this.metrics.keySet().toArray(metricIDs);
        return metricIDs;
    }

    public IMetric<?> getMetric(String metricId) {
        return this.metrics.get(metricId);
    }

    public IMetric<?>[] getMetrics(String ... categories) {
        HashSet<String> metricNames = new HashSet<String>();
        HashSet metricsWithoutDuplicates = new HashSet();
        String[] stringArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IMetric<?>[] metrics;
            String cat = stringArray[n2];
            IMetric<?>[] iMetricArray = metrics = this.categories.get(cat).getMetrics();
            int n3 = metrics.length;
            int n4 = 0;
            while (n4 < n3) {
                IMetric<?> m = iMetricArray[n4];
                if (!metricNames.contains(m.getName())) {
                    metricNames.add(m.getName());
                    metricsWithoutDuplicates.add(m);
                }
                ++n4;
            }
            ++n2;
        }
        return metricsWithoutDuplicates.toArray(new IMetric[metricsWithoutDuplicates.size()]);
    }

    public Set<IMetric<?>> getMetrics(String regexp) {
        Pattern p = Pattern.compile(regexp);
        HashSet result = new HashSet();
        for (IMetric<?> m : this.metrics.values()) {
            if (!p.matcher(m.getName()).matches()) continue;
            result.add(m);
        }
        return result;
    }

    public String[] getMetricCategories() {
        Iterator<Category> iter = this.categories.values().iterator();
        String[] cats = new String[this.categories.size()];
        int i = 0;
        while (iter.hasNext()) {
            cats[i] = iter.next().getName();
            ++i;
        }
        return cats;
    }

    public Category getCategory(String name) {
        return this.categories.get(name);
    }

    public void runTask(Runnable task) {
        this.executor.schedule(task, 0L, TimeUnit.SECONDS);
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.executor;
    }
}

