/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.client.Configurable;
import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.UFTPConstants;
import de.fzj.unicore.uas.fts.FiletransferOptions;
import de.fzj.unicore.uas.fts.ProgressListener;
import eu.unicore.uftp.client.UFTPClient;
import eu.unicore.uftp.client.UFTPProgressListener;
import eu.unicore.uftp.dpc.Utils;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.unigrids.services.atomic.types.ProtocolType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class UFTPFileTransferClient
extends FileTransferClient
implements Configurable,
UFTPConstants,
FiletransferOptions.IMonitorable,
UFTPProgressListener {
    private String secret;
    private final InetAddress[] serverHosts;
    private final int serverPort;
    private final int streams;
    private final byte[] key;
    private ProgressListener<Long> listener;
    private long lastTotal = 0L;

    public UFTPFileTransferClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public UFTPFileTransferClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
        Map<String, String> params = this.getProtocolDependentRPs();
        String hostParam = params.get("uftp.server.host");
        hostParam = sec.getExtraSettings().getProperty("uftp.server.host", hostParam);
        this.serverHosts = this.asHosts(hostParam);
        if (this.serverHosts.length == 0) {
            throw new Exception("No usable UFTP server host could be determined from <" + hostParam + ">");
        }
        this.serverPort = Integer.parseInt(params.get("uftp.server.port"));
        this.streams = Integer.parseInt(params.get("uftp.streams"));
        String keySpec = params.get("uftp.encryption_key");
        this.key = keySpec != null ? Utils.decodeBase64((String)keySpec) : null;
    }

    @Override
    public void configure(Map<String, String> params) {
        String secret = params.get("uftp.secret");
        if (secret != null) {
            this.setSecret(secret);
        }
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Override
    public void readAllData(OutputStream target) throws Exception {
        UFTPClient c = new UFTPClient(this.serverHosts, this.serverPort, target);
        c.setNumConnections(this.streams);
        c.setSecret(this.secret);
        c.setKey(this.key);
        if (this.listener != null) {
            c.setProgressListener((UFTPProgressListener)this);
        }
        c.run();
    }

    @Override
    public void writeAllData(InputStream source) throws Exception {
        UFTPClient c = new UFTPClient(this.serverHosts, this.serverPort, source);
        c.setNumConnections(this.streams);
        c.setSecret(this.secret);
        c.setKey(this.key);
        if (this.listener != null) {
            c.setProgressListener((UFTPProgressListener)this);
        }
        c.run();
    }

    @Override
    public void setProgressListener(ProgressListener<Long> listener) {
        this.listener = listener;
    }

    public static UFTPFileTransferClient createImport(String path, StorageClient sms, boolean append, String clientHost, int numConnections, String secret, boolean encrypt) throws Exception {
        UFTPFileTransferClient c = (UFTPFileTransferClient)sms.getImport(path, append, UFTPFileTransferClient.makeParams(clientHost, numConnections, secret, encrypt), ProtocolType.UFTP);
        c.secret = secret;
        return c;
    }

    public static UFTPFileTransferClient createExport(String path, StorageClient sms, String clientHost, int numConnections, String secret, boolean encrypt) throws Exception {
        UFTPFileTransferClient c = (UFTPFileTransferClient)sms.getExport(path, UFTPFileTransferClient.makeParams(clientHost, numConnections, secret, encrypt), ProtocolType.UFTP);
        c.secret = secret;
        return c;
    }

    public InetAddress[] getServerHosts() {
        return this.serverHosts;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getStreams() {
        return this.streams;
    }

    public String getEncryptionKey() {
        return this.key != null ? Utils.encodeBase64((byte[])this.key) : null;
    }

    public void notifyTotalBytesTransferred(long totalBytesTransferred) {
        if (this.listener != null) {
            this.listener.notifyProgress(totalBytesTransferred - this.lastTotal);
            this.lastTotal = totalBytesTransferred;
        }
    }

    private static Map<String, String> makeParams(String host, int numConnections, String secret, boolean encrypt) {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("uftp.client.host", host);
        p.put("uftp.streams", String.valueOf(numConnections));
        p.put("uftp.secret", secret);
        p.put("uftp.encryption", String.valueOf(encrypt));
        return p;
    }

    public InetAddress[] asHosts(String hostsProperty) {
        String[] hosts;
        ArrayList<InetAddress> hostList = new ArrayList<InetAddress>();
        for (String h : hosts = hostsProperty.split("[ ,]+")) {
            try {
                hostList.add(InetAddress.getByName(h));
            }
            catch (IOException io) {
                logger.trace((Object)("Un-usable UFTP host address <" + h + "> : " + io));
            }
        }
        return hostList.toArray(new InetAddress[hostList.size()]);
    }

    public String asString(InetAddress[] ips) {
        StringBuilder sb = new StringBuilder();
        for (InetAddress ip : ips) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(ip.getHostName());
        }
        return sb.toString();
    }
}

