/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.ResourceReservation;
import de.fzj.unicore.uas.TargetSystem;
import de.fzj.unicore.uas.TargetSystemFactory;
import de.fzj.unicore.uas.client.BaseClientWithStatus;
import de.fzj.unicore.uas.client.EnumerationClient;
import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.ReservationClient;
import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.faults.AutoStartNotSupportedException;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.unigrids.services.atomic.types.AvailableResourceType;
import org.unigrids.services.atomic.types.SecurityType;
import org.unigrids.services.atomic.types.SiteResourceType;
import org.unigrids.services.atomic.types.StorageReferenceType;
import org.unigrids.services.atomic.types.TextInfoType;
import org.unigrids.x2006.x04.services.reservation.ResourceReservationRequestDocument;
import org.unigrids.x2006.x04.services.reservation.ResourceReservationResponseDocument;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceType;
import org.unigrids.x2006.x04.services.tss.JobReferenceDocument;
import org.unigrids.x2006.x04.services.tss.SubmitDocument;
import org.unigrids.x2006.x04.services.tss.SubmitResponseDocument;
import org.unigrids.x2006.x04.services.tss.SupportsReservationDocument;
import org.unigrids.x2006.x04.services.tss.TargetSystemPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TSSClient
extends BaseClientWithStatus {
    private static final Logger logger = Log.getLogger((String)"unicore.client", TSSClient.class);
    private final TargetSystem tss = (TargetSystem)this.makeProxy(TargetSystem.class);
    private String name;

    public TSSClient(String endpointUrl, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(endpointUrl, epr, sec);
        this.setRetryDefaults();
    }

    public TSSClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public SubmitResponseDocument Submit(SubmitDocument in) throws Exception, AutoStartNotSupportedException {
        boolean autoStart;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Calling target system service at " + this.getEPR().getAddress().getStringValue()));
        }
        if ((autoStart = in.getSubmit().getAutoStartWhenReady()) && !this.checkVersion("1.4.1")) {
            throw new AutoStartNotSupportedException();
        }
        return this.tss.Submit(in);
    }

    public JobClient submit(SubmitDocument in) throws Exception {
        SubmitResponseDocument res = this.Submit(in);
        EndpointReferenceType epr = res.getSubmitResponse().getJobReference();
        return new JobClient(epr.getAddress().getStringValue(), epr, this.getSecurityConfiguration());
    }

    public TargetSystemPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return TargetSystemPropertiesDocument.Factory.parse((InputStream)this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public Calendar getUpSince() throws Exception {
        return this.getResourcePropertiesDocument().getTargetSystemProperties().getUpSince();
    }

    public long getNumberOfJobs() throws Exception {
        return this.getResourcePropertiesDocument().getTargetSystemProperties().getTotalNumberOfJobs().longValue();
    }

    private List<EndpointReferenceType> getJobsWithoutEnumeration() throws Exception {
        EndpointReferenceType[] eprs = this.getResourcePropertiesDocument().getTargetSystemProperties().getJobReferenceArray();
        return Arrays.asList(eprs);
    }

    public List<EndpointReferenceType> getJobs() throws Exception {
        EnumerationClient<JobReferenceDocument> c = this.getJobReferenceEnumeration();
        if (c == null) {
            return this.getJobsWithoutEnumeration();
        }
        ArrayList<EndpointReferenceType> res = new ArrayList<EndpointReferenceType>();
        Iterator<JobReferenceDocument> iter = c.iterator();
        while (iter.hasNext()) {
            res.add(iter.next().getJobReference());
        }
        return res;
    }

    public EnumerationClient<JobReferenceDocument> getJobReferenceEnumeration() throws Exception {
        EndpointReferenceType epr = this.getResourcePropertiesDocument().getTargetSystemProperties().getJobReferenceEnumeration();
        if (epr != null) {
            EnumerationClient<JobReferenceDocument> c = new EnumerationClient<JobReferenceDocument>(epr, this.getSecurityConfiguration(), JobReferenceDocument.type.getDocumentElementName());
            return c;
        }
        return null;
    }

    public List<EndpointReferenceType> getReservations() {
        try {
            EndpointReferenceType[] eprs = this.getResourcePropertiesDocument().getTargetSystemProperties().getReservationReferenceArray();
            return Arrays.asList(eprs);
        }
        catch (Exception e) {
            logger.error((Object)"Can't get reservation list.", (Throwable)e);
            return null;
        }
    }

    public List<EndpointReferenceType> getStorages() {
        try {
            StorageReferenceType[] srs = this.getResourcePropertiesDocument().getTargetSystemProperties().getStorageReferenceArray();
            ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
            for (StorageReferenceType s : srs) {
                eprs.add(s.getStorageEndpointReference());
            }
            return eprs;
        }
        catch (Exception e) {
            logger.error((Object)"Can't get storages list.", (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] getXlogins() {
        try {
            String[] srs = null;
            SecurityType secT = this.getSecurityInfo();
            if (secT != null) {
                return super.getXlogins();
            }
            srs = this.getResourcePropertiesDocument().getTargetSystemProperties().getXloginArray();
            return srs;
        }
        catch (Exception e) {
            logger.error((Object)"Can't get xlogins.", (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] getXgroups() {
        try {
            String[] srs = null;
            SecurityType secT = this.getSecurityInfo();
            if (secT != null) {
                return super.getXlogins();
            }
            srs = this.getResourcePropertiesDocument().getTargetSystemProperties().getXgroupArray();
            return srs;
        }
        catch (Exception e) {
            logger.error((Object)"Can't get xgroups.", (Throwable)e);
            return null;
        }
    }

    public String getTargetSystemName() {
        if (this.name == null) {
            try {
                this.name = this.getResourcePropertiesDocument().getTargetSystemProperties().getName();
            }
            catch (Exception e) {
                logger.warn((Object)"Can't get name from TSS.", (Throwable)e);
            }
        }
        return this.name;
    }

    public List<ApplicationResourceType> getApplications() {
        try {
            ApplicationResourceType[] apps = this.getResourcePropertiesDocument().getTargetSystemProperties().getApplicationResourceArray();
            return Arrays.asList(apps);
        }
        catch (Exception e) {
            logger.warn((Object)"Can't get applications from TSS.", (Throwable)e);
            return null;
        }
    }

    public List<TextInfoType> getTextInfo() {
        try {
            TextInfoType[] info = this.getResourcePropertiesDocument().getTargetSystemProperties().getTextInfoArray();
            return Arrays.asList(info);
        }
        catch (Exception e) {
            logger.warn((Object)"Can't get text info from TSS.", (Throwable)e);
            return null;
        }
    }

    public List<SiteResourceType> getSiteSpecificResources() {
        try {
            SiteResourceType[] info = this.getResourcePropertiesDocument().getTargetSystemProperties().getSiteResourceArray();
            return Arrays.asList(info);
        }
        catch (Exception e) {
            logger.warn((Object)"Can't get site-specific resource info from TSS.", (Throwable)e);
            return null;
        }
    }

    public List<AvailableResourceType> getAvailableResources() {
        try {
            AvailableResourceType[] info = this.getResourcePropertiesDocument().getTargetSystemProperties().getAvailableResourceArray();
            return Arrays.asList(info);
        }
        catch (Exception e) {
            logger.warn((Object)"Can't get resource info from TSS.", (Throwable)e);
            return null;
        }
    }

    public String getOperatingSystemInfo() throws Exception {
        OperatingSystemType os = this.getResourcePropertiesDocument().getTargetSystemProperties().getOperatingSystem();
        if (os == null) {
            return "UNKNOWN";
        }
        try {
            String name = os.getOperatingSystemType().getOperatingSystemName().toString();
            String version = os.getOperatingSystemVersion();
            String descrString = os.getDescription();
            return name + " " + (version != null ? version : "") + (descrString != null ? " (" + descrString + ")" : "");
        }
        catch (Exception e) {
            logger.warn((Object)"Error retrieving OS from target system.");
            return "UNKNOWN";
        }
    }

    public OperatingSystemType getOperatingSystem() throws Exception {
        OperatingSystemType os = this.getResourcePropertiesDocument().getTargetSystemProperties().getOperatingSystem();
        return os;
    }

    public static TSSClient getOrCreateTSS(String registryURL, IClientConfiguration sec) throws Exception {
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(registryURL);
        RegistryClient c = new RegistryClient(registryURL, epr, sec);
        List tss = c.listAccessibleServices(TargetSystem.TSS_PORT);
        if (tss.size() == 0) {
            return TSSClient.createTSS(c, sec);
        }
        if (((EndpointReferenceType)tss.get(0)).getAddress().getStringValue().contains("WorkflowTargetSystem")) {
            if (tss.size() > 0) {
                return new TSSClient(((EndpointReferenceType)tss.get(1)).getAddress().getStringValue(), (EndpointReferenceType)tss.get(1), sec);
            }
            return TSSClient.createTSS(c, sec);
        }
        return new TSSClient(((EndpointReferenceType)tss.get(0)).getAddress().getStringValue(), (EndpointReferenceType)tss.get(0), sec);
    }

    private static TSSClient createTSS(RegistryClient c, IClientConfiguration sec) throws Exception {
        List tsfs = c.listAccessibleServices(TargetSystemFactory.TSF_PORT);
        if (tsfs.size() == 0) {
            return null;
        }
        return new TSFClient(((EndpointReferenceType)tsfs.get(0)).getAddress().getStringValue(), (EndpointReferenceType)tsfs.get(0), sec).createTSS();
    }

    public boolean supportsReservation() throws Exception {
        SupportsReservationDocument resSupport = SupportsReservationDocument.Factory.parse((String)this.getResourceProperty(ResourceReservation.RP_SUPPORTS_RESERVATION));
        return resSupport.getSupportsReservation();
    }

    public EndpointReferenceType createReservation(ResourcesDocument resources, Calendar startTime) throws Exception {
        ResourceReservationRequestDocument req = ResourceReservationRequestDocument.Factory.newInstance();
        req.addNewResourceReservationRequest().setResources(resources.getResources());
        req.getResourceReservationRequest().setStartTime(startTime);
        TargetSystem tss = (TargetSystem)this.makeProxy(TargetSystem.class);
        ResourceReservationResponseDocument res = tss.ReserveResources(req);
        return res.getResourceReservationResponse().getReservationReference();
    }

    public ReservationClient createReservationClient(ResourcesDocument resources, Calendar startTime) throws Exception {
        EndpointReferenceType epr = this.createReservation(resources, startTime);
        ReservationClient client = new ReservationClient(epr.getAddress().getStringValue(), epr, this.getSecurityConfiguration());
        return client;
    }
}

