/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.StorageFactory;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.client.EnumerationClient;
import de.fzj.unicore.uas.client.StorageClient;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument;
import org.unigrids.x2006.x04.services.smf.AccessibleStorageReferenceDocument;
import org.unigrids.x2006.x04.services.smf.CreateSMSDocument;
import org.unigrids.x2006.x04.services.smf.CreateSMSResponseDocument;
import org.unigrids.x2006.x04.services.smf.StorageDescriptionType;
import org.unigrids.x2006.x04.services.smf.StorageFactoryPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class StorageFactoryClient
extends BaseUASClient {
    private static final Logger logger = Log.getLogger((String)"unicore.client", StorageFactoryClient.class);
    private final StorageFactory smf = (StorageFactory)this.makeProxy(StorageFactory.class);

    public StorageFactoryClient(String endpointUrl, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(endpointUrl, epr, sec);
        this.setRetryDefaults();
    }

    public StorageFactoryClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public StorageClient createSMS(CreateSMSDocument in) throws Exception {
        logger.info((Object)("Calling storage factory service at: " + this.getEPR().getAddress().getStringValue()));
        CreateSMSResponseDocument res = this.smf.CreateSMS(in);
        EndpointReferenceType epr = res.getCreateSMSResponse().getSmsReference();
        return new StorageClient(epr.getAddress().getStringValue(), epr, this.getSecurityConfiguration());
    }

    public StorageClient createSMS(String type, String name, Calendar initialTerminationTime) throws Exception {
        CreateSMSDocument in = CreateSMSDocument.Factory.newInstance();
        in.addNewCreateSMS();
        if (initialTerminationTime != null) {
            TerminationTimeDocument.TerminationTime tt = TerminationTimeDocument.TerminationTime.Factory.newInstance();
            tt.setCalendarValue(initialTerminationTime);
            in.getCreateSMS().setTerminationTime(tt);
        }
        StorageDescriptionType sd = in.getCreateSMS().addNewStorageDescription();
        if (type != null) {
            sd.setStorageBackendType(type);
        }
        if (name != null) {
            sd.addNewFileSystem().setName(name);
        }
        return this.createSMS(in);
    }

    public StorageClient createSMS(Calendar initialTerminationTime) throws Exception {
        CreateSMSDocument in = CreateSMSDocument.Factory.newInstance();
        TerminationTimeDocument.TerminationTime tt = TerminationTimeDocument.TerminationTime.Factory.newInstance();
        tt.setCalendarValue(initialTerminationTime);
        in.addNewCreateSMS().setTerminationTime(tt);
        return this.createSMS(in);
    }

    public StorageClient createSMS() throws Exception {
        CreateSMSDocument in = CreateSMSDocument.Factory.newInstance();
        in.addNewCreateSMS();
        return this.createSMS(in);
    }

    public StorageFactoryPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return StorageFactoryPropertiesDocument.Factory.parse((InputStream)this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public List<EndpointReferenceType> getStorages() {
        try {
            EndpointReferenceType[] eprs = this.getResourcePropertiesDocument().getStorageFactoryProperties().getStorageReferenceArray();
            return Arrays.asList(eprs);
        }
        catch (Exception e) {
            logger.error((Object)"Can't get storage list.", (Throwable)e);
            return null;
        }
    }

    public List<EndpointReferenceType> getAccessibleStorages() throws Exception {
        EnumerationClient<AccessibleStorageReferenceDocument> c = this.getAccessibleSMSEnumeration();
        if (c == null) {
            return this.getAccessibleSMSWithoutEnumeration();
        }
        ArrayList<EndpointReferenceType> res = new ArrayList<EndpointReferenceType>();
        Iterator<AccessibleStorageReferenceDocument> iter = c.iterator();
        while (iter.hasNext()) {
            res.add(iter.next().getAccessibleStorageReference());
        }
        return res;
    }

    private EnumerationClient<AccessibleStorageReferenceDocument> getAccessibleSMSEnumeration() throws Exception {
        EndpointReferenceType epr = this.getResourcePropertiesDocument().getStorageFactoryProperties().getAccessibleStorageEnumeration();
        if (epr != null) {
            EnumerationClient<AccessibleStorageReferenceDocument> c = new EnumerationClient<AccessibleStorageReferenceDocument>(epr, this.getSecurityConfiguration(), AccessibleStorageReferenceDocument.type.getDocumentElementName());
            return c;
        }
        return null;
    }

    private List<EndpointReferenceType> getAccessibleSMSWithoutEnumeration() {
        try {
            EndpointReferenceType[] eprs = this.getResourcePropertiesDocument().getStorageFactoryProperties().getAccessibleStorageReferenceArray();
            return Arrays.asList(eprs);
        }
        catch (Exception e) {
            logger.error((Object)"Can't get accessible storage list.", (Throwable)e);
            return null;
        }
    }

    public StorageDescriptionType[] getBackendStorageDescription() throws Exception {
        return this.getResourcePropertiesDocument().getStorageFactoryProperties().getStorageDescriptionArray();
    }
}

