/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.client.ByteIOBaseClient;
import de.fzj.unicore.uas.fts.ProgressListener;
import de.fzj.unicore.uas.fts.byteio.ByteIO;
import de.fzj.unicore.uas.fts.byteio.StreamableByteIO;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.byteio.x2005.x10.byteIo.TransferInformationType;
import org.ggf.schemas.byteio.x2005.x10.streamableAccess.SeekReadDocument;
import org.ggf.schemas.byteio.x2005.x10.streamableAccess.SeekReadResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.streamableAccess.SeekWriteDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class SByteIOClient
extends ByteIOBaseClient {
    private static final Logger logger = Log.getLogger((String)"unicore.client", SByteIOClient.class);
    private final StreamableByteIO fts = (StreamableByteIO)this.makeProxy(StreamableByteIO.class);

    public SByteIOClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
    }

    public SByteIOClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public byte[] seekRead(long offset, int numBytes) throws IOException {
        try {
            return this.doSeekRead("http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/current", offset, numBytes);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error in seekRead");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public byte[] seekReadFromOrigin(long offset, int numBytes) throws IOException {
        try {
            return this.doSeekRead("http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/beginning", offset, numBytes);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error in seekReadFromOrigin");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void seekWrite(byte[] data, long offset, String origin) throws IOException {
        try {
            this.doWrite(data, offset, origin);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error in seekWrite");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void append(byte[] data) throws IOException {
        try {
            this.doWrite(data, 0L, "http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/end");
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error in append");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected byte[] doSeekRead(String seekOrigin, long offset, int numBytes) throws IOException, BaseFault, XmlException {
        SeekReadDocument req = SeekReadDocument.Factory.newInstance();
        SeekReadDocument.SeekRead r = req.addNewSeekRead();
        r.addNewTransferInformation().setTransferMechanism("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple");
        r.setNumBytes((long)numBytes);
        r.setOffset(offset);
        r.setSeekOrigin(seekOrigin);
        SeekReadResponseDocument res = this.fts.seekRead(req);
        byte[] data = ByteIO.decode("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple", (XmlObject)res.getSeekReadResponse().getTransferInformation());
        return data;
    }

    protected void doWrite(byte[] data, long offset, String origin) throws IOException, BaseFault, XmlException {
        SeekWriteDocument req = SeekWriteDocument.Factory.newInstance();
        SeekWriteDocument.SeekWrite r = req.addNewSeekWrite();
        r.setOffset(offset);
        r.setSeekOrigin(origin);
        TransferInformationType ti = r.addNewTransferInformation();
        ti.set(ByteIO.encode("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple", data));
        ti.setTransferMechanism("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple");
        this.fts.seekWrite(req);
    }

    @Override
    public void readAllData(OutputStream target) throws IOException {
        this.readAllData(target, 128000);
    }

    public void readAllData(OutputStream os, int chunksize) throws IOException {
        try {
            byte[] data;
            long offset = 0L;
            while ((data = this.seekRead(0L, chunksize)) != null && data.length != 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Read " + data.length + " bytes."));
                }
                os.write(data);
                os.flush();
                if (this.progressListener == null) continue;
                try {
                    this.progressListener.notifyProgress(Long.valueOf(data.length));
                }
                catch (Exception e) {
                    Log.logException((String)"Error reporting progress.", (Throwable)e, (Logger)logger);
                }
                if (!this.progressListener.isCancelled()) continue;
                throw new ProgressListener.CancelledException("Cancelled.");
            }
        }
        catch (ProgressListener.CancelledException ce) {
            throw ce;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error in readAllData");
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public void writeAllData(InputStream source) throws Exception {
        this.writeAllData(source, this.chunksize);
    }

    public void writeAllData(InputStream source, int chunksize) throws Exception {
        block7: {
            byte[] data = new byte[chunksize];
            long total = 0L;
            boolean doAppend = this.append;
            while (true) {
                int l;
                if ((l = source.read(data)) == -1) {
                    if (total == 0L) {
                        this.doWrite(new byte[0], doAppend);
                    }
                    break block7;
                }
                if (l < data.length) {
                    byte[] read = new byte[l];
                    System.arraycopy(data, 0, read, 0, l);
                    this.doWrite(read, doAppend);
                } else {
                    this.doWrite(data, doAppend);
                }
                total += (long)l;
                doAppend = true;
                if (this.progressListener == null) continue;
                try {
                    this.progressListener.notifyProgress(Long.valueOf(l));
                }
                catch (Exception e) {
                    Log.logException((String)"Error reporting progress.", (Throwable)e, (Logger)logger);
                }
                if (this.progressListener.isCancelled()) break;
            }
            throw new ProgressListener.CancelledException("Cancelled.");
        }
    }

    private void doWrite(byte[] data, boolean append) throws Exception {
        if (append) {
            this.append(data);
        } else {
            this.doWrite(data, 0L, "http://schemas.ggf.org/byteio/2005/10/streamable-access/seek-origins/beginning");
        }
    }
}

