/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.Enumeration;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.unicore.unicore6.enumeration.EnumerationPropertiesDocument;
import eu.unicore.unicore6.enumeration.GetResultsRequestDocument;
import eu.unicore.unicore6.enumeration.GetResultsResponseDocument;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class EnumerationClient<T>
extends BaseUASClient
implements Iterable<T> {
    private final Enumeration enumeration;
    private final QName resultQName;
    private int batchSize = 50;

    public EnumerationClient(String url, EndpointReferenceType epr, IClientConfiguration sec, QName resultQName) throws Exception {
        super(url, epr, sec);
        this.resultQName = resultQName;
        this.enumeration = (Enumeration)this.makeProxy(Enumeration.class);
        this.setRetryDefaults();
    }

    public EnumerationClient(EndpointReferenceType address, IClientConfiguration sec, QName resultQName) throws Exception {
        this(address.getAddress().getStringValue(), address, sec, resultQName);
    }

    public List<T> getResults(long offset, long length) throws Exception {
        ArrayList<XmlObject> results = new ArrayList<XmlObject>();
        GetResultsRequestDocument req = GetResultsRequestDocument.Factory.newInstance();
        req.addNewGetResultsRequest().setOffset(offset);
        req.getGetResultsRequest().setNumberOfResults(length);
        GetResultsResponseDocument respD = this.enumeration.GetResults(req);
        XmlObject[] res = WSUtilities.extractAnyElements((XmlObject)respD, (QName)this.resultQName);
        if (res != null) {
            for (XmlObject o : res) {
                results.add(o);
            }
        }
        return results;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int current = 0;
            private List<T> buffer = null;

            @Override
            public boolean hasNext() {
                try {
                    return (long)this.current < EnumerationClient.this.getNumberOfResults();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public T next() {
                if (this.buffer == null || this.buffer.size() == 0) {
                    this.getNextBatch();
                }
                ++this.current;
                return this.buffer.remove(0);
            }

            @Override
            public void remove() {
            }

            private void getNextBatch() {
                try {
                    this.buffer = EnumerationClient.this.getResults(this.current, EnumerationClient.this.batchSize);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    public EnumerationPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return EnumerationPropertiesDocument.Factory.parse((InputStream)this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public long getNumberOfResults() throws Exception {
        return this.getResourcePropertiesDocument().getEnumerationProperties().getNumberOfResults();
    }

    public EndpointReferenceType getParentServiceEPR() throws Exception {
        return this.getResourcePropertiesDocument().getEnumerationProperties().getParentServiceReference();
    }

    public void setBatchSize(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("Need batch size larger than 1");
        }
        this.batchSize = batchSize;
    }
}

